/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.api.service.impl;

import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.api.service.FinanceTodoListRpcService;
import com.els.modules.sample.api.dto.TodoCountInfoDTO;
import com.els.modules.sample.api.dto.TodoStatusDTO;
import com.els.modules.sample.api.service.ExtendTodoListRpcService;
import com.els.modules.sample.enums.TodoExtendTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ExtendTodoListSingleServiceImpl
implements ExtendTodoListRpcService {
    private static final Logger log = LoggerFactory.getLogger(ExtendTodoListSingleServiceImpl.class);
    @Resource
    @Lazy
    private FinanceTodoListRpcService financeTodoListRpcService;

    public List<TodoCountInfoDTO> getExtendTodoCountList(List<PermissionDTO> permissionDTOList, String elsAccount, String subAccount) {
        ArrayList<TodoCountInfoDTO> todList = new ArrayList<TodoCountInfoDTO>();
        for (PermissionDTO permissionDTO : permissionDTOList) {
            if (!TodoExtendTypeEnum.PURCHASE_TEST.getUrl().equals(permissionDTO.getUrl())) continue;
        }
        return todList;
    }

    private static TodoCountInfoDTO testTodoData() {
        TodoCountInfoDTO dto = new TodoCountInfoDTO();
        dto.setModuleName("\u6d4b\u8bd5");
        dto.setCountNumber(Integer.valueOf(88));
        dto.setIcon("testIcon");
        dto.setPageRoute("/test");
        ArrayList<TodoStatusDTO> statusList = new ArrayList<TodoStatusDTO>();
        TodoStatusDTO statusDTO = new TodoStatusDTO();
        statusDTO.setName("\u5904\u7406\u4e2d");
        statusDTO.setValue("2");
        statusList.add(statusDTO);
        dto.setStatusList(statusList);
        return dto;
    }

    private void countTabTest(String elsAccount, String subAccount, List<TodoCountInfoDTO> todList, PermissionDTO permissionDTO) {
        String accountBusinessType = this.getAccountBusinessType("addCost");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("1");
        Integer count = this.financeTodoListRpcService.countPurchaseAddCostList(elsAccount, statusList, accountBusinessType);
        log.info("\u5f85\u529e\u4e8b\u9879-" + TodoExtendTypeEnum.PURCHASE_TEST.getModuleName() + ",\u83b7\u53d6\u5230\u7edf\u8ba1\u6761\u6570\u4e3a[{}]", (Object)count);
        if (count > 0) {
            TodoCountInfoDTO vo = this.processTodoInfo(permissionDTO, count);
            TodoStatusDTO statusDTO = new TodoStatusDTO();
            statusDTO.setName("confirmStatus");
            statusDTO.setValue("1");
            vo.setStatusList(Arrays.asList(statusDTO));
            todList.add(vo);
        }
    }

    private TodoCountInfoDTO processTodoInfo(PermissionDTO permissionDTO, Integer count) {
        TodoCountInfoDTO vo = new TodoCountInfoDTO();
        vo.setModuleName(I18nUtil.translate((String)permissionDTO.getNameI18nKey(), (String)permissionDTO.getName()));
        vo.setCountNumber(count);
        vo.setIcon(permissionDTO.getIcon());
        vo.setPageRoute(permissionDTO.getUrl());
        return vo;
    }

    private String getAccountBusinessType(String businessType) {
        String accountBusinessType = null;
        if (StringUtils.isNotBlank((CharSequence)businessType)) {
            accountBusinessType = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount() + "-" + businessType;
        }
        return accountBusinessType;
    }
}

