/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SupplierRetificationResultAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            // empty if block
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSupplierRectificationReportHead supplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(inputParamVO.getBusinessId());
        supplierRectificationReportHead.setResultAuditStatus(outputParamVO.getAuditStatus());
        supplierRectificationReportHead.setResultFlowCode(outputParamVO.getProcessRootId());
        String params = inputParamVO.getParams();
        JSONObject paramsJsonObject = null;
        if (StringUtils.isNotBlank((CharSequence)params)) {
            paramsJsonObject = JSONObject.parseObject((String)params);
        }
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            supplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.RECTIFICATIONED.getValue());
        }
        if (paramsJsonObject != null) {
            supplierRectificationReportHead.setRectificationConclusion(paramsJsonObject.getString("rectificationConclusion"));
        }
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)supplierRectificationReportHead);
    }
}

