/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.SaleSupplierRectificationReportHead;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportHeadMapper;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierRetificationResultAuditOptCallBackServiceImpl")
public class SupplierRetificationResultAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;
    @Resource
    private SaleSupplierRectificationReportHeadMapper saleSupplierRectificationReportHeadMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            // empty if block
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSupplierRectificationReportHead supplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(inputParamVO.getBusinessId());
        supplierRectificationReportHead.setResultAuditStatus(outputParamVO.getAuditStatus());
        supplierRectificationReportHead.setResultFlowCode(outputParamVO.getProcessRootId());
        supplierRectificationReportHead.setWorkFlowType(outputParamVO.getBpmnType());
        String params = inputParamVO.getParams();
        JSONObject paramsJsonObject = null;
        if (StringUtils.isNotBlank((CharSequence)params)) {
            paramsJsonObject = JSONObject.parseObject((String)params);
        }
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            supplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.RECTIFICATIONED.getValue());
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            supplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONFAILD.getValue());
        }
        if (paramsJsonObject != null) {
            supplierRectificationReportHead.setRectificationConclusion(paramsJsonObject.getString("rectificationConclusion"));
        }
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)supplierRectificationReportHead);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(SaleSupplierRectificationReportHead::getRectificationStatus, (Object)SupplierRectificationStatusEnum.RECTIFICATIONED.getValue());
        updateWrapper.lambda().eq(SaleSupplierRectificationReportHead::getRelationId, (Object)inputParamVO.getBusinessId());
        this.saleSupplierRectificationReportHeadMapper.update(null, (Wrapper)updateWrapper);
    }
}

