/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="purchaseSampleCheckAdapter")
public class PurchaseSampleCheckAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseSampleCheckHeadService purchaseSampleCheckHeadService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseSampleCheckHead purchaseStandardHead = (PurchaseSampleCheckHead)((Object)JSONObject.parseObject((String)param, PurchaseSampleCheckHead.class));
        purchaseStandardHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseStandardHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseStandardHead);
        this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseSampleCheckHead.setId(inputParamVO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(outputParamVO.getAuditStatus());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseSampleCheckHead.setCheckStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        }
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
        trackingItem.setSampleId(purchaseSampleCheckHead.getId());
        trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
        trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
        Date now = new Date();
        trackingItem.setActualEndTime(new Date());
        trackingItem.setActualEndTime(now);
        if (purchaseSampleCheckHead.getCheckStartDate() != null) {
            trackingItem.setEstimatedTimePeriod((now.getTime() - purchaseSampleCheckHead.getCheckStartDate().getTime()) / 86400000L + "");
        }
        this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        purchaseSampleCheckHead.setId(inputParamVO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        purchaseSampleCheckHead.setId(inputParamVO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)purchaseSampleCheckHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        return msgParamsVO;
    }
}

