/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.massProduction.adapter;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.modules.massProduction.entity.PurchaseMassProdHead;
import com.els.modules.massProduction.entity.SaleMassProdHead;
import com.els.modules.massProduction.enums.MassProdEnum;
import com.els.modules.massProduction.service.PurchaseMassProdHeadService;
import com.els.modules.massProduction.service.SaleMassProdHeadService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMassProdAdapter")
public class PurchaseMassProdAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseMassProdHeadService massProdHeadService;
    @Autowired
    private SaleMassProdHeadService saleMassProdHeadService;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId) {
        PurchaseMassProdHead purchaseMassProdHead = (PurchaseMassProdHead)((Object)this.massProdHeadService.getById((Serializable)((Object)businessId)));
        purchaseMassProdHead.setResultAuditStatus(auditStatus).setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            purchaseMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
            SaleMassProdHead saleMassProdHead = (SaleMassProdHead)((Object)this.saleMassProdHeadService.getById((Serializable)((Object)purchaseMassProdHead.getRelationId())));
            saleMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
            this.saleMassProdHeadService.updateById((Object)saleMassProdHead);
        }
        this.massProdHeadService.updateById((Object)purchaseMassProdHead);
    }

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }
}

