/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckProject;
import com.els.modules.sample.enumerate.PurchaseSampleCheckProjectEnum;
import com.els.modules.sample.service.PurchaseSampleCheckProjectService;
import com.els.modules.sample.vo.PurchaseSampleCheckProjectVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/sample/purchaseSampleCheckProject"})
public class PurchaseSampleCheckProjectController
extends BaseController<PurchaseSampleCheckProject, PurchaseSampleCheckProjectService> {
    @Autowired
    private PurchaseSampleCheckProjectService purchaseSampleCheckProjectService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseSampleCheckProject purchaseSampleCheckProject, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckProject), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleCheckProjectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)")
    @GetMapping(value={"/enableList"})
    public Result<?> queryPageEnableList(PurchaseSampleCheckProject purchaseSampleCheckProject, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckProject), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"project_status", (Object)PurchaseSampleCheckProjectEnum.ENABLED);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleCheckProjectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseSampleCheckProject purchaseSampleCheckProject) {
        this.purchaseSampleCheckProjectService.savePurchaseSampleCheckProject(purchaseSampleCheckProject);
        return Result.ok((Object)((Object)purchaseSampleCheckProject));
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseSampleCheckProject purchaseSampleCheckProject) {
        this.purchaseSampleCheckProjectService.updatePurchaseSampleCheckProject(purchaseSampleCheckProject);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u72b6\u6001\u53d8\u66f4")
    @ApiOperation(value="\u72b6\u6001\u53d8\u66f4", notes="\u72b6\u6001\u53d8\u66f4")
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody PurchaseSampleCheckProjectVO purchaseSampleCheckProjectVO) {
        if ("1".equals(purchaseSampleCheckProjectVO.getStatusType())) {
            purchaseSampleCheckProjectVO.setProjectStatus(PurchaseSampleCheckProjectEnum.ENABLED.getValue());
        } else if ("2".equals(purchaseSampleCheckProjectVO.getStatusType())) {
            purchaseSampleCheckProjectVO.setProjectStatus(PurchaseSampleCheckProjectEnum.DISABLED.getValue());
        }
        PurchaseSampleCheckProject purchaseSampleCheckProject = new PurchaseSampleCheckProject();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckProjectVO), (Object)((Object)purchaseSampleCheckProject));
        this.purchaseSampleCheckProjectService.updateById((Object)purchaseSampleCheckProject);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseSampleCheckProjectService.delPurchaseSampleCheckProject(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseSampleCheckProjectService.delBatchPurchaseSampleCheckProject(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseSampleCheckProject purchaseSampleCheckProject = (PurchaseSampleCheckProject)((Object)this.purchaseSampleCheckProjectService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)purchaseSampleCheckProject));
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseSampleCheckProject purchaseSampleCheckProject, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckProject), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"project_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"project_status");
        List list = ((PurchaseSampleCheckProjectService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseSampleCheckProject::getProjectStatus, PurchaseSampleCheckProject::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"", (String)"\u5168\u90e8"), "projectStatus", null, all));
        List sampleCheckProjectStatus = this.invokeBaseRpcService.queryDictItemsByCode("sampleCheckProjectStatus", "307000");
        for (DictDTO status : sampleCheckProjectStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "projectStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

