/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.eightReport.rpc.service.InvokeMainDataRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.quality.entity.PurchaseRetificationReviewTeam;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportItem;
import com.els.modules.quality.entity.SaleSupplierRectificationReportHead;
import com.els.modules.quality.entity.SaleSupplierRectificationReportItem;
import com.els.modules.quality.enumerate.SupplierRectificationPublishStatusEnum;
import com.els.modules.quality.enumerate.SupplierRectificationReviewResultStatusEnum;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportItemMapper;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PurchaseSupplierRectificationReportHeadServiceImpl
extends BaseServiceImpl<PurchaseSupplierRectificationReportHeadMapper, PurchaseSupplierRectificationReportHead>
implements PurchaseSupplierRectificationReportHeadService {
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;
    @Resource
    private SaleSupplierRectificationReportHeadMapper saleSupplierRectificationReportHeadMapper;
    @Resource
    private SaleSupplierRectificationReportItemMapper saleSupplierRectificationReportItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeMainDataRpcService invokeMainDataRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseSupplierRectificationReportHead.setDeleted(Integer.parseInt("0"));
        purchaseSupplierRectificationReportHead.setReportCode(this.invokeBaseRpcService.getNextCode("saleRetification", (Object)purchaseSupplierRectificationReportHead));
        if ("0".equals(purchaseSupplierRectificationReportHead.getPreAudit())) {
            purchaseSupplierRectificationReportHead.setPreAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseSupplierRectificationReportHead.setPreAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        if ("0".equals(purchaseSupplierRectificationReportHead.getResultAudit())) {
            purchaseSupplierRectificationReportHead.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseSupplierRectificationReportHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        purchaseSupplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.NEW.getValue());
        purchaseSupplierRectificationReportHead.setPublishStatus(SupplierRectificationPublishStatusEnum.UN_PUBLISH.getValue());
        purchaseSupplierRectificationReportHead.setApplicant(loginUser.getRealname());
        purchaseSupplierRectificationReportHead.setApplicantId(loginUser.getSubAccount());
        List<PurchaseOrganizationInfoDTO> deptOrgList = this.getDeptById(loginUser.getOrgCode());
        if (CollectionUtil.isNotEmpty(deptOrgList)) {
            purchaseSupplierRectificationReportHead.setApplicantDepartment(this.getDeptName(deptOrgList));
            purchaseSupplierRectificationReportHead.setApplicantDepartmentId(this.getDeptCode(deptOrgList));
        }
        purchaseSupplierRectificationReportHead.setBusAccount(TenantContext.getTenant());
        purchaseSupplierRectificationReportHead.setRelationId(IdWorker.getIdStr());
        purchaseSupplierRectificationReportHead.setRectificationDate(new Date());
        this.purchaseSupplierRectificationReportHeadMapper.insert((Object)purchaseSupplierRectificationReportHead);
    }

    private String getDeptName(List<PurchaseOrganizationInfoDTO> deptOrgList) {
        if (CollectionUtil.isEmpty(deptOrgList)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < deptOrgList.size()) {
            PurchaseOrganizationInfoDTO purchaseOrganizationInfo = deptOrgList.get(i);
            if (!StringUtils.isEmpty((Object)purchaseOrganizationInfo.getOrgName())) {
                sb.append(purchaseOrganizationInfo.getOrgName());
                sb.append(",");
            }
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String getDeptCode(List<PurchaseOrganizationInfoDTO> deptOrgList) {
        if (CollectionUtil.isEmpty(deptOrgList)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < deptOrgList.size()) {
            PurchaseOrganizationInfoDTO purchaseOrganizationInfo = deptOrgList.get(i);
            if (!StringUtils.isEmpty((Object)purchaseOrganizationInfo.getOrgCode())) {
                sb.append(purchaseOrganizationInfo.getOrgCode());
                sb.append(",");
            }
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private List<PurchaseOrganizationInfoDTO> getDeptById(String deptIds) {
        if (StringUtils.isEmpty((Object)deptIds)) {
            return null;
        }
        String[] depts = deptIds.split(",");
        List<PurchaseOrganizationInfoDTO> list = this.invokeMainDataRpcService.selectOrgByIds(depts, "dept");
        return list;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)purchaseSupplierRectificationReportHead);
        this.purchaseSupplierRectificationReportItemMapper.deleteByMainId(purchaseSupplierRectificationReportHead.getId());
        this.purchaseRetificationReviewTeamMapper.deleteByMainId(purchaseSupplierRectificationReportHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSupplierRectificationReportHead.getId());
        this.insertData(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportItemList, purchaseRetificationReviewTeamList, purchaseAttachmentList);
    }

    private void insertData(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        for (PurchaseSupplierRectificationReportItem purchaseSupplierRectificationReportItem : purchaseSupplierRectificationReportItemList) {
            purchaseSupplierRectificationReportItem.setHeadId(purchaseSupplierRectificationReportHead.getId());
            purchaseSupplierRectificationReportItem.setRelationId(IdWorker.getIdStr());
            purchaseSupplierRectificationReportItem.setToElsAccount(purchaseSupplierRectificationReportHead.getToElsAccount());
            purchaseSupplierRectificationReportItem.setReportCode(purchaseSupplierRectificationReportHead.getReportCode());
            SysUtil.setSysParam((BaseEntity)purchaseSupplierRectificationReportItem, (BaseEntity)purchaseSupplierRectificationReportHead);
        }
        if (!purchaseSupplierRectificationReportItemList.isEmpty()) {
            this.purchaseSupplierRectificationReportItemMapper.insertBatchSomeColumn(purchaseSupplierRectificationReportItemList);
        }
        if (CollectionUtil.isNotEmpty(purchaseRetificationReviewTeamList)) {
            for (PurchaseRetificationReviewTeam purchaseRetificationReviewTeam : purchaseRetificationReviewTeamList) {
                purchaseRetificationReviewTeam.setHeadId(purchaseSupplierRectificationReportHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseRetificationReviewTeam, (BaseEntity)purchaseSupplierRectificationReportHead);
            }
            if (!purchaseRetificationReviewTeamList.isEmpty()) {
                this.purchaseRetificationReviewTeamMapper.insertBatchSomeColumn(purchaseRetificationReviewTeamList);
            }
        }
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setHeadId(purchaseSupplierRectificationReportHead.getId());
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchaseSupplierRectificationReportHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSupplierRectificationReportItemMapper.deleteByMainId(id);
        this.purchaseRetificationReviewTeamMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseSupplierRectificationReportHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSupplierRectificationReportItemMapper.deleteByMainId(serializable.toString());
            this.purchaseRetificationReviewTeamMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseSupplierRectificationReportHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction
    public void publish(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItems, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeams, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.updateMain(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportItems, purchaseRetificationReviewTeams, purchaseAttachmentList);
        purchaseSupplierRectificationReportHead.setPublishStatus(SupplierRectificationPublishStatusEnum.PUBLISH.getValue());
        purchaseSupplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.RECTIFICATIONING.getValue());
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)purchaseSupplierRectificationReportHead);
        SaleSupplierRectificationReportHead saleSupplierRectificationReportHead = new SaleSupplierRectificationReportHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSupplierRectificationReportHead), (Object)((Object)saleSupplierRectificationReportHead));
        saleSupplierRectificationReportHead.setId(purchaseSupplierRectificationReportHead.getRelationId());
        saleSupplierRectificationReportHead.setRelationId(purchaseSupplierRectificationReportHead.getId());
        saleSupplierRectificationReportHead.setElsAccount(purchaseSupplierRectificationReportHead.getToElsAccount());
        saleSupplierRectificationReportHead.setToElsAccount(purchaseSupplierRectificationReportHead.getElsAccount());
        this.saleSupplierRectificationReportHeadMapper.insert((Object)saleSupplierRectificationReportHead);
        if (CollectionUtil.isNotEmpty(purchaseSupplierRectificationReportItems)) {
            ArrayList<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItems = new ArrayList<SaleSupplierRectificationReportItem>();
            for (PurchaseSupplierRectificationReportItem item : purchaseSupplierRectificationReportItems) {
                SaleSupplierRectificationReportItem saleSupplierRectificationReportItem = new SaleSupplierRectificationReportItem();
                BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleSupplierRectificationReportItem));
                saleSupplierRectificationReportItem.setElsAccount(item.getToElsAccount());
                saleSupplierRectificationReportItem.setToElsAccount(item.getElsAccount());
                saleSupplierRectificationReportItem.setId(item.getRelationId());
                saleSupplierRectificationReportItem.setRelationId(item.getId());
                saleSupplierRectificationReportItem.setHeadId(saleSupplierRectificationReportHead.getId());
                saleSupplierRectificationReportItems.add(saleSupplierRectificationReportItem);
            }
            this.saleSupplierRectificationReportItemMapper.insertBatchSomeColumn(saleSupplierRectificationReportItems);
        }
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(TenantContext.getTenant());
            sendVO.setHeadId(purchaseSupplierRectificationReportHead.getId());
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(saleSupplierRectificationReportHead.getId(), saleSupplierRectificationReportHead.getElsAccount());
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
        }
        String url = "reportCode=" + purchaseSupplierRectificationReportHead.getReportCode();
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void acceptRectification(PurchaseRetificationReviewTeam purchaseRetificationReviewTeam) {
        PurchaseRetificationReviewTeam retificationReviewTeam2;
        LoginUser loginUser = SysUtil.getLoginUser();
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(purchaseRetificationReviewTeam.getHeadId());
        Assert.isNotEmpty(purchaseRetificationReviewTeamList, (String)"\u5f53\u524d\u5355\u636e\u7684\u8bc4\u5ba1\u5c0f\u7ec4\u6570\u636e\u4e3a\u7a7a!");
        List purchaseRetificationReviewTeams = purchaseRetificationReviewTeamList.stream().filter(item -> loginUser.getSubAccount().equals(item.getSubAccount())).collect(Collectors.toList());
        Assert.isNotEmpty(purchaseRetificationReviewTeams, (String)("\u5f53\u524d\u767b\u5f55\u4eba\u5458" + loginUser.getRealname() + "\u4e0d\u662f\u8be5\u6574\u6539\u5355\u636e\u7684\u8bc4\u5ba1\u4eba\u5458,\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!"));
        for (PurchaseRetificationReviewTeam retificationReviewTeam2 : purchaseRetificationReviewTeams) {
            if (StringUtils.isEmpty((Object)retificationReviewTeam2.getReviewResult())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APEHLjWWWWIOkRUUWxOVBtk_c9900dce", (String)"\u5f53\u524d\u767b\u5f55\u4eba\u5458${0}\u5df2\u7ecf\u505a\u8fc7\u8bc4\u5ba1\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String[])new String[]{loginUser.getRealname()}));
        }
        retificationReviewTeam2 = new PurchaseRetificationReviewTeam();
        retificationReviewTeam2.setId(((PurchaseRetificationReviewTeam)((Object)purchaseRetificationReviewTeams.get(0))).getId());
        retificationReviewTeam2.setReviewResult(SupplierRectificationReviewResultStatusEnum.ACCEPT.getValue());
        retificationReviewTeam2.setReviesOption(purchaseRetificationReviewTeam.getReviesOption());
        this.purchaseRetificationReviewTeamMapper.updateById((Object)retificationReviewTeam2);
        this.syncRetificationStatus(purchaseRetificationReviewTeam.getHeadId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void rejectRectification(PurchaseRetificationReviewTeam purchaseRetificationReviewTeam) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(purchaseRetificationReviewTeam.getHeadId());
        Assert.isNotEmpty(purchaseRetificationReviewTeamList, (String)"\u5f53\u524d\u5355\u636e\u7684\u8bc4\u5ba1\u5c0f\u7ec4\u6570\u636e\u4e3a\u7a7a!");
        List purchaseRetificationReviewTeams = purchaseRetificationReviewTeamList.stream().filter(item -> loginUser.getSubAccount().equals(item.getSubAccount())).collect(Collectors.toList());
        Assert.isNotEmpty(purchaseRetificationReviewTeams, (String)("\u5f53\u524d\u767b\u5f55\u4eba\u5458" + loginUser.getRealname() + "\u4e0d\u662f\u8be5\u6574\u6539\u5355\u636e\u7684\u8bc4\u5ba1\u4eba\u5458,\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!"));
        PurchaseRetificationReviewTeam retificationReviewTeam = new PurchaseRetificationReviewTeam();
        retificationReviewTeam.setId(((PurchaseRetificationReviewTeam)((Object)purchaseRetificationReviewTeams.get(0))).getId());
        retificationReviewTeam.setReviewResult(SupplierRectificationReviewResultStatusEnum.REJECT.getValue());
        retificationReviewTeam.setReviesOption(purchaseRetificationReviewTeam.getReviesOption());
        this.purchaseRetificationReviewTeamMapper.updateById((Object)retificationReviewTeam);
        this.syncRetificationStatus(purchaseRetificationReviewTeam.getHeadId());
    }

    private void syncRetificationStatus(String headId) {
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)headId)));
        PurchaseSupplierRectificationReportHead tempSuppplierRectificationRepostHead = new PurchaseSupplierRectificationReportHead();
        SaleSupplierRectificationReportHead tempSaleSupplierRectificationReportHead = new SaleSupplierRectificationReportHead();
        String isResultStatus = purchaseSupplierRectificationReportHead.getResultAudit();
        tempSuppplierRectificationRepostHead.setId(purchaseSupplierRectificationReportHead.getId());
        tempSaleSupplierRectificationReportHead.setId(purchaseSupplierRectificationReportHead.getRelationId());
        if (!"1".equals(isResultStatus)) {
            tempSuppplierRectificationRepostHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONED.getValue());
        } else {
            List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(headId);
            List purchaseRetificationReviewTeam4HadCacluationList = purchaseRetificationReviewTeamList.stream().filter(item -> !StringUtils.isEmpty((Object)item.getReviewResult())).collect(Collectors.toList());
            if (purchaseRetificationReviewTeamList.size() == purchaseRetificationReviewTeam4HadCacluationList.size()) {
                tempSuppplierRectificationRepostHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONED.getValue());
            } else {
                tempSuppplierRectificationRepostHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONING.getValue());
            }
        }
        tempSaleSupplierRectificationReportHead.setRectificationStatus(tempSuppplierRectificationRepostHead.getRectificationStatus());
        this.saleSupplierRectificationReportHeadMapper.updateById((Object)tempSaleSupplierRectificationReportHead);
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)tempSuppplierRectificationRepostHead);
    }
}

