/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.modules.report.entity.ElsTimeToleranceSetting;
import com.els.modules.report.entity.ElsTimeToleranceSettingHis;
import com.els.modules.report.mapper.ElsTimeToleranceSettingHisMapper;
import com.els.modules.report.mapper.ElsTimeToleranceSettingMapper;
import com.els.modules.report.service.ElsTimeToleranceSettingService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsTimeToleranceSettingServiceImpl
extends ServiceImpl<ElsTimeToleranceSettingMapper, ElsTimeToleranceSetting>
implements ElsTimeToleranceSettingService {
    @Autowired
    private ElsTimeToleranceSettingHisMapper elsTimeToleranceSettingHisMapper;
    @Autowired
    private ElsTimeToleranceSettingMapper elsTimeToleranceSettingMapper;

    @Override
    public void saveElsTimeToleranceSetting(ElsTimeToleranceSetting elsTimeToleranceSetting) {
        this.checkTimeToleranceSetting(elsTimeToleranceSetting);
        elsTimeToleranceSetting.setFbk3("1");
        ((ElsTimeToleranceSettingMapper)this.baseMapper).insert((Object)elsTimeToleranceSetting);
    }

    @Override
    public void updateElsTimeToleranceSetting(ElsTimeToleranceSetting elsTimeToleranceSetting) {
        this.checkTimeToleranceSetting(elsTimeToleranceSetting);
        ElsTimeToleranceSetting dbElsTimeToleranceSetting = (ElsTimeToleranceSetting)((Object)((ElsTimeToleranceSettingMapper)this.baseMapper).selectById((Serializable)((Object)elsTimeToleranceSetting.getId())));
        if (dbElsTimeToleranceSetting != null && !elsTimeToleranceSetting.equals((Object)dbElsTimeToleranceSetting)) {
            ElsTimeToleranceSettingHis elsTimeToleranceSettingHis = new ElsTimeToleranceSettingHis();
            BeanUtils.copyProperties((Object)((Object)dbElsTimeToleranceSetting), (Object)((Object)elsTimeToleranceSettingHis));
            this.elsTimeToleranceSettingHisMapper.insert((Object)elsTimeToleranceSettingHis);
            String currentVersion = dbElsTimeToleranceSetting.getFbk3();
            if (StringUtils.isBlank((CharSequence)currentVersion)) {
                currentVersion = "0";
            }
            Integer newVersion = Integer.parseInt(currentVersion) + 1;
            elsTimeToleranceSetting.setFbk3(newVersion + "");
        }
        ((ElsTimeToleranceSettingMapper)this.baseMapper).updateById((Object)elsTimeToleranceSetting);
    }

    private void checkTimeToleranceSetting(ElsTimeToleranceSetting elsTimeToleranceSetting) {
        String toElsAccount = elsTimeToleranceSetting.getToElsAccount();
        LambdaQueryWrapper elsTimeToleranceSettingLambdaQueryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)toElsAccount)) {
            elsTimeToleranceSettingLambdaQueryWrapper.eq(ElsTimeToleranceSetting::getToElsAccount, (Object)toElsAccount);
            if (StringUtils.isNotBlank((CharSequence)elsTimeToleranceSetting.getId())) {
                elsTimeToleranceSettingLambdaQueryWrapper.ne(BaseEntity::getId, (Object)elsTimeToleranceSetting.getId());
            } else {
                elsTimeToleranceSettingLambdaQueryWrapper.last("and( id is not null )");
            }
            List elsTimeToleranceSettings = this.elsTimeToleranceSettingMapper.selectList((Wrapper)elsTimeToleranceSettingLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)elsTimeToleranceSettings)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXWWWWWIOGRrKIcmWxOVBGRW_4c91910", (String)"\u4f9b\u5e94\u5546:${0}\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u65f6\u95f4\u5bb9\u5dee\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e!", (String[])new String[]{toElsAccount}));
            }
        } else if (StringUtils.isBlank((CharSequence)toElsAccount) && StringUtils.isNotBlank((CharSequence)elsTimeToleranceSetting.getAccountGroup())) {
            elsTimeToleranceSettingLambdaQueryWrapper.eq(ElsTimeToleranceSetting::getAccountGroup, (Object)elsTimeToleranceSetting.getAccountGroup());
            if (StringUtils.isNotBlank((CharSequence)elsTimeToleranceSetting.getId())) {
                elsTimeToleranceSettingLambdaQueryWrapper.ne(BaseEntity::getId, (Object)elsTimeToleranceSetting.getId());
            } else {
                elsTimeToleranceSettingLambdaQueryWrapper.last("and( id is not null )");
            }
            elsTimeToleranceSettingLambdaQueryWrapper.last("and (to_els_account is null or to_els_account='' )");
            List elsTimeToleranceSettings = this.elsTimeToleranceSettingMapper.selectList((Wrapper)elsTimeToleranceSettingLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)elsTimeToleranceSettings)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eDVWWWWWIOGRrKIcmWxOVBGRW_3cfb9196", (String)"\u8d26\u6237\u7ec4:${0}\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u65f6\u95f4\u5bb9\u5dee\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e!", (String[])new String[]{elsTimeToleranceSetting.getAccountGroup()}));
            }
        }
    }

    @Override
    public void delElsTimeToleranceSetting(String id) {
        ((ElsTimeToleranceSettingMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTimeToleranceSetting(List<String> idList) {
        ((ElsTimeToleranceSettingMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void upgradeVersion(String id) {
        ElsTimeToleranceSetting elsTimeToleranceSetting = (ElsTimeToleranceSetting)((Object)((ElsTimeToleranceSettingMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ElsTimeToleranceSettingHis elsTiemeToleranceSettingHis = new ElsTimeToleranceSettingHis();
        BeanUtils.copyProperties((Object)((Object)elsTimeToleranceSetting), (Object)((Object)elsTiemeToleranceSettingHis));
        this.elsTimeToleranceSettingHisMapper.insert((Object)elsTiemeToleranceSettingHis);
        String currentVersion = elsTimeToleranceSetting.getFbk3();
        if (StringUtils.isBlank((CharSequence)currentVersion)) {
            currentVersion = "0";
        }
        Integer y = Integer.parseInt(currentVersion) + 1;
        elsTimeToleranceSetting.setFbk3(y.toString());
        ((ElsTimeToleranceSettingMapper)this.baseMapper).updateById((Object)elsTimeToleranceSetting);
    }
}

