/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.PurchaseMouldMaintain;
import com.els.modules.mould.entity.SaleMouldData;
import com.els.modules.mould.entity.SaleMouldMaintain;
import com.els.modules.mould.enumerate.MaintainStatusEnum;
import com.els.modules.mould.enumerate.MouldStatusEnum;
import com.els.modules.mould.enumerate.TargetStatusEnum;
import com.els.modules.mould.mapper.PurchaseMouldMaintainMapper;
import com.els.modules.mould.mapper.SaleMouldMaintainMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.PurchaseMouldMaintainService;
import com.els.modules.mould.service.SaleMouldDataService;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseMouldMaintainServiceImpl
extends BaseServiceImpl<PurchaseMouldMaintainMapper, PurchaseMouldMaintain>
implements PurchaseMouldMaintainService {
    @Resource
    private SaleMouldMaintainMapper saleMouldMaintainMapper;
    @Autowired
    private SaleMouldDataService saleMouldDataService;
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;

    @Override
    public void add(SaleMouldMaintain saleMaintain) {
        PurchaseMouldMaintain maintain = new PurchaseMouldMaintain();
        BeanUtils.copyProperties((Object)((Object)saleMaintain), (Object)((Object)maintain));
        maintain.setId(saleMaintain.getRelationId());
        maintain.setRelationId(saleMaintain.getId());
        maintain.setElsAccount(saleMaintain.getToElsAccount());
        maintain.setToElsAccount(saleMaintain.getElsAccount());
        ((PurchaseMouldMaintainMapper)this.baseMapper).insert((Object)maintain);
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseMouldData::getRelationId, (Object)maintain.getMouldDataId())).set(PurchaseMouldData::getTargetStatus, (Object)TargetStatusEnum.MAINTAIN.getValue()));
    }

    @Override
    @SrmTransaction
    public void agree(PurchaseMouldMaintain maintain) {
        maintain.setConfirmTime(new Date());
        maintain.setMaintainStatus(MaintainStatusEnum.AGREE.getValue());
        this.updateById((Object)maintain);
        this.updateSale(maintain);
        SaleMouldData saleData = new SaleMouldData();
        saleData.setId(maintain.getMouldDataId());
        saleData.setMouldStatus(MouldStatusEnum.MAINTAIN.getValue());
        this.saleMouldDataService.updateById((Object)saleData);
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseMouldData::getRelationId, (Object)maintain.getMouldDataId())).set(PurchaseMouldData::getMouldStatus, (Object)MouldStatusEnum.MAINTAIN.getValue()));
    }

    @Override
    @SrmTransaction
    public void refuse(PurchaseMouldMaintain maintain) {
        Assert.hasText((String)maintain.getPurchaseRemark(), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u65b9\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a"));
        maintain.setMaintainStatus(MaintainStatusEnum.CLOSE.getValue());
        ((PurchaseMouldMaintainMapper)this.baseMapper).updateById((Object)maintain);
        this.updateSale(maintain);
        this.saleMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)maintain.getMouldDataId())).set(SaleMouldData::getTargetStatus, null));
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseMouldData::getRelationId, (Object)maintain.getMouldDataId())).set(PurchaseMouldData::getTargetStatus, null));
    }

    private void updateSale(PurchaseMouldMaintain maintain) {
        SaleMouldMaintain saleMaintain = new SaleMouldMaintain();
        BeanUtils.copyProperties((Object)((Object)maintain), (Object)((Object)saleMaintain));
        saleMaintain.setId(maintain.getRelationId());
        saleMaintain.setRelationId(maintain.getId());
        saleMaintain.setElsAccount(maintain.getToElsAccount());
        saleMaintain.setToElsAccount(maintain.getElsAccount());
        this.saleMouldMaintainMapper.updateById((Object)saleMaintain);
    }
}

