/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleCheckItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.sample.service.PurchaseSampleCheckItemService;
import com.els.modules.sample.vo.PurchaseSampleCheckHeadRecordVO;
import com.els.modules.sample.vo.PurchaseSampleCheckHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sample/purchaseSampleCheckHead"})
@Api(tags={"\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934"})
public class PurchaseSampleCheckHeadController
extends BaseController<PurchaseSampleCheckHead, PurchaseSampleCheckHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSampleCheckHeadController.class);
    @Autowired
    private PurchaseSampleCheckHeadService purchaseSampleCheckHeadService;
    @Autowired
    private PurchaseSampleCheckItemService purchaseSampleCheckItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="sampleCheck")
    public Result<?> queryPageList(PurchaseSampleCheckHead purchaseSampleCheckHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleCheckHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchaseSampleCheckHead:add"})
    public Result<?> add(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        Assert.hasText((String)purchaseSampleCheckHeadPage.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)purchaseSampleCheckHeadPage.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        this.purchaseSampleCheckHeadService.saveMain(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList());
        return Result.ok((Object)((Object)purchaseSampleCheckHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"purchaseSampleCheckHead:edit"})
    public Result<?> edit(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        this.purchaseSampleCheckHeadService.updateMain(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), 1);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        purchaseSampleCheckHeadPage.setCheckStatus(PurchaseSampleCheckHeadEnum.TEST_ING.getValue());
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        this.purchaseSampleCheckHeadService.updateMain(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), 2);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934", value="\u7ed3\u679c\u5f55\u5165")
    @ApiOperation(value="\u7ed3\u679c\u5f55\u5165", notes="\u7ed3\u679c\u5f55\u5165")
    @PostMapping(value={"/resultRecord"})
    @RequiresPermissions(value={"purchaseSampleCheckHead:result"})
    public Result<?> resultRecord(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        purchaseSampleCheckHead.setSampleQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getSampleQuantity());
        purchaseSampleCheckHead.setQualifiedQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedQuantity());
        purchaseSampleCheckHead.setDefectiveQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getDefectiveQuantity());
        purchaseSampleCheckHead.setQualifiedRate(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedRate());
        purchaseSampleCheckHead.setQualified(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualified());
        purchaseSampleCheckHead.setCheckResult(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getCheckResult());
        this.purchaseSampleCheckHeadService.resultRecord(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), 1);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934", value="\u7ed3\u679c\u5f55\u5165\u63d0\u4ea4")
    @ApiOperation(value="\u7ed3\u679c\u5f55\u5165\u63d0\u4ea4", notes="\u7ed3\u679c\u5f55\u5165\u63d0\u4ea4")
    @PostMapping(value={"/resultRecordSubmit"})
    public Result<?> resultRecordSubmit(@RequestBody PurchaseSampleCheckHeadVO purchaseSampleCheckHeadPage) {
        if ("0".equals(purchaseSampleCheckHeadPage.getResultAudit())) {
            purchaseSampleCheckHeadPage.setCheckStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        }
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadPage), (Object)((Object)purchaseSampleCheckHead));
        purchaseSampleCheckHead.setSampleQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getSampleQuantity());
        purchaseSampleCheckHead.setQualifiedQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedQuantity());
        purchaseSampleCheckHead.setDefectiveQuantity(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getDefectiveQuantity());
        purchaseSampleCheckHead.setQualifiedRate(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualifiedRate());
        purchaseSampleCheckHead.setQualified(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getQualified());
        purchaseSampleCheckHead.setCheckResult(purchaseSampleCheckHeadPage.getPurchaseSampleRecord().getCheckResult());
        this.purchaseSampleCheckHeadService.resultRecord(purchaseSampleCheckHead, purchaseSampleCheckHeadPage.getPurchaseSampleCheckItemList(), 2);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchaseSampleCheckHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseSampleCheckHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"purchaseSampleCheckHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseSampleCheckHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)id)));
        PurchaseSampleCheckHeadVO purchaseSampleCheckHeadVO = new PurchaseSampleCheckHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHead), (Object)((Object)purchaseSampleCheckHeadVO));
        List<PurchaseSampleCheckItem> purchaseSampleCheckItemList = this.purchaseSampleCheckItemService.selectByMainId(id);
        purchaseSampleCheckHeadVO.setPurchaseSampleCheckItemList(purchaseSampleCheckItemList);
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseSampleCheckHeadVO.setPurchaseAttachmentList(attachmentList);
        PurchaseSampleCheckHeadRecordVO recordVO = new PurchaseSampleCheckHeadRecordVO();
        recordVO.setSampleQuantity(purchaseSampleCheckHead.getSampleQuantity());
        recordVO.setQualifiedQuantity(purchaseSampleCheckHead.getQualifiedQuantity());
        recordVO.setDefectiveQuantity(purchaseSampleCheckHead.getDefectiveQuantity());
        recordVO.setQualifiedRate(purchaseSampleCheckHead.getQualifiedRate());
        recordVO.setQualified(purchaseSampleCheckHead.getQualified());
        recordVO.setCheckResult(purchaseSampleCheckHead.getCheckResult());
        recordVO.setResultAudit(purchaseSampleCheckHead.getResultAudit());
        purchaseSampleCheckHeadVO.setPurchaseSampleRecord(recordVO);
        return Result.ok((Object)((Object)purchaseSampleCheckHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u5934id\u67e5\u8be2\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u884c")
    @GetMapping(value={"/queryPurchaseSampleCheckItemByMainId"})
    public Result<?> queryPurchaseSampleCheckItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseSampleCheckItem> purchaseSampleCheckItemList = this.purchaseSampleCheckItemService.selectByMainId(id);
        return Result.ok(purchaseSampleCheckItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseSampleCheckHead purchaseSampleCheckHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"check_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"check_status");
        List list = ((PurchaseSampleCheckHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseSampleCheckHead::getCheckStatus, PurchaseSampleCheckHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "checkStatus", null, all));
        String[] statuses = new String[]{"1", "2"};
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("1", I18nUtil.translate((String)"i18n_title_checking", (String)"\u68c0\u6d4b\u4e2d"));
        statusMap.put("2", I18nUtil.translate((String)"i18n_title_usbRootHub", (String)"\u68c0\u6d4b\u5b8c\u6210"));
        for (Map.Entry entry : statusMap.entrySet()) {
            String status = (String)entry.getKey();
            Integer total = countMap.get(status) == null ? Integer.valueOf(0) : countMap.get(status);
            result.add(new CountVO((String)entry.getValue(), "checkStatus", status, total));
        }
        return Result.ok(result);
    }
}

