/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u6a21\u5177\u4e3b\u6570\u636e"})
@RestController
@RequestMapping(value={""})
public class PurchaseMouldDataController
extends BaseController<PurchaseMouldData, PurchaseMouldDataService> {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseMouldData")
    public Result<?> queryPageList(PurchaseMouldData mouldData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)mouldData), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseMouldDataService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6a21\u5177\u7ec4\u5206\u9875\u67e5\u8be2", notes="\u6a21\u5177\u7ec4\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/groupList"})
    @PermissionDataView(businessType="purchaseMouldData")
    public Result<?> queryPageGroupList(PurchaseMouldData mouldData, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)mouldData), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"mould_group_number", "max(mould_group_desc) as mould_group_desc"});
        queryWrapper.groupBy((Object)"mould_group_number");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseMouldDataService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u6a21\u5177\u4e3b\u6570\u636e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchaseMouldData:add"})
    @PermissionDataOpt(businessType="purchaseMouldData", beanClass=PurchaseMouldDataService.class)
    public Result<?> add(@RequestBody PurchaseMouldData mouldData) {
        ((PurchaseMouldDataService)this.service).savePurchaseMouldData(mouldData);
        return Result.ok((Object)((Object)mouldData));
    }

    @AutoLog(value="\u91c7\u8d2d\u6a21\u5177\u4e3b\u6570\u636e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"purchaseMouldData:edit"})
    @PermissionDataOpt(businessType="purchaseMouldData", beanClass=PurchaseMouldDataService.class)
    public Result<?> edit(@RequestBody PurchaseMouldData mouldData) {
        ((PurchaseMouldDataService)this.service).updatePurchaseMouldData(mouldData);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6a21\u5177\u4e3b\u6570\u636e-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"purchaseMouldData:publish"})
    @PermissionDataOpt(businessType="purchaseMouldData", beanClass=PurchaseMouldDataService.class)
    public Result<?> publish(@RequestBody PurchaseMouldData mouldData) {
        PurchaseMouldData dbData = (PurchaseMouldData)((Object)((PurchaseMouldDataService)this.service).getById((Serializable)((Object)mouldData.getId())));
        Assert.isNull((Object)dbData.getRelationId(), (String)I18nUtil.translate((String)"", (String)"\u5df2\u53d1\u5e03\u7684\u5355\u636e\u4e0d\u53ef\u91cd\u590d\u53d1\u5e03"));
        ((PurchaseMouldDataService)this.service).publish(mouldData);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6a21\u5177\u4e3b\u6570\u636e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchaseMouldData:delete"})
    @PermissionDataOpt(businessType="purchaseMouldData", beanClass=PurchaseMouldDataService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((PurchaseMouldDataService)this.service).removeById((Serializable)((Object)id));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMouldData mouldData = (PurchaseMouldData)((Object)((PurchaseMouldDataService)this.service).getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)mouldData));
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="purchaseMouldData")
    public Result<?> queryTabsCount(PurchaseMouldData purchaseMouldData, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMouldData), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"mould_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"mould_status");
        List list = ((PurchaseMouldDataService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseMouldData::getMouldStatus, PurchaseMouldData::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "requestStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmMouldDataStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "requestStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

