/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.entity.SaleSampleHead;
import com.els.modules.sample.entity.SaleSampleItem;
import com.els.modules.sample.entity.SampleSupplierList;
import com.els.modules.sample.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.sample.enumerate.PurchaseSampleStatusEnum;
import com.els.modules.sample.enumerate.PurchaseSampleStatusItemEnum;
import com.els.modules.sample.mapper.PurchaseSampleHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleItemMapper;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.mapper.SampleSupplierListMapper;
import com.els.modules.sample.rpc.service.SampleInvokeMainDataRpcService;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.service.SaleSampleHeadService;
import com.els.modules.sample.service.SaleSampleItemService;
import com.els.modules.sample.service.impl.PurchaseSampleItemServiceImpl;
import com.els.modules.sample.service.impl.SaleSampleHeadServiceImpl;
import com.els.modules.sample.service.impl.SaleSampleItemServiceImpl;
import com.els.modules.sample.vo.PurchaseSampleHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSampleHeadServiceImpl
extends BaseServiceImpl<PurchaseSampleHeadMapper, PurchaseSampleHead>
implements PurchaseSampleHeadService {
    @Resource
    private PurchaseSampleHeadMapper purchaseSampleHeadMapper;
    @Resource
    private PurchaseSampleItemMapper purchaseSampleItemMapper;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private SampleSupplierListMapper sampleSupplierListMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SampleInvokeMainDataRpcService sampleInvokeMainDataRpcService;
    @Autowired
    private SaleSampleHeadService saleSampleHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSampleHead purchaseSampleHead, List<PurchaseSampleItem> purchaseSampleItemList, List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList, List<SampleSupplierList> sampleSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        List<PurchaseOrganizationInfoDTO> list;
        if (StringUtils.isBlank((CharSequence)purchaseSampleHead.getSampleNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSampleNumber", (Object)purchaseSampleHead);
            purchaseSampleHead.setSampleNumber(nextCode);
        }
        super.setHeadDefaultValue((BaseEntity)purchaseSampleHead);
        purchaseSampleHead.setApplyDate(new Date());
        purchaseSampleHead.setBusAccount(TenantContext.getTenant());
        purchaseSampleHead.setSampleStatus(PurchaseSampleStatusEnum.SAMPLE_NEW.getValue());
        if ("1".equals(purchaseSampleHead.getPublishAudit())) {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseSampleHead.setApplicant(String.valueOf(loginUser.getSubAccount()) + "_" + loginUser.getRealname());
        purchaseSampleHead.setPublishUser(String.valueOf(loginUser.getSubAccount()) + "_" + loginUser.getRealname());
        if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length == 1 && !CollectionUtils.isEmpty(list = this.sampleInvokeMainDataRpcService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
            purchaseSampleHead.setApplyDept(String.valueOf(list.get(0).getOrgCode()) + "_" + list.get(0).getOrgName());
        }
        this.purchaseSampleHeadMapper.insert((Object)purchaseSampleHead);
        this.insertData(purchaseSampleHead, purchaseSampleItemList, purchaseSampleTrackingItemList, sampleSupplierList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSampleHead purchaseSampleHead, List<PurchaseSampleItem> purchaseSampleItemList, List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList, List<SampleSupplierList> sampleSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if ("1".equals(purchaseSampleHead.getPublishAudit())) {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSampleHeadMapper.updateById((Object)purchaseSampleHead);
        this.purchaseSampleItemMapper.deleteByMainId(purchaseSampleHead.getId());
        this.purchaseSampleTrackingItemMapper.deleteByMainId(purchaseSampleHead.getId());
        this.sampleSupplierListMapper.deleteByMainId(purchaseSampleHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSampleHead.getId());
        this.insertData(purchaseSampleHead, purchaseSampleItemList, purchaseSampleTrackingItemList, sampleSupplierList, purchaseAttachmentList);
    }

    private void insertData(PurchaseSampleHead purchaseSampleHead, List<PurchaseSampleItem> purchaseSampleItemList, List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList, List<SampleSupplierList> sampleSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseSampleItemList)) {
            int count = 1;
            for (PurchaseSampleItem entity : purchaseSampleItemList) {
                entity.setHeadId(purchaseSampleHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleHead);
                entity.setSampleNumber(purchaseSampleHead.getSampleNumber());
                entity.setItemNumber(String.valueOf(count));
                ++count;
                entity.setPurchaseGroup(purchaseSampleHead.getPurchaseGroup());
                entity.setPurchaseOrg(purchaseSampleHead.getPurchaseOrg());
                entity.setFactory(purchaseSampleHead.getFactory());
                entity.setCompany(purchaseSampleHead.getCompany());
                entity.setStorageLocation(purchaseSampleHead.getStorageLocation());
                if (!StringUtils.isBlank((CharSequence)entity.getItemStatus())) continue;
                entity.setItemStatus(PurchaseSampleStatusItemEnum.SAMPLE_NEW.getValue());
            }
            if (!purchaseSampleItemList.isEmpty()) {
                this.purchaseSampleItemMapper.insertBatchSomeColumn(purchaseSampleItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseSampleTrackingItemList)) {
            for (PurchaseSampleTrackingItem entity : purchaseSampleTrackingItemList) {
                entity.setHeadId(purchaseSampleHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleHead);
            }
            if (!purchaseSampleTrackingItemList.isEmpty()) {
                this.purchaseSampleTrackingItemMapper.insertBatchSomeColumn(purchaseSampleTrackingItemList);
            }
        }
        if (!CollectionUtils.isEmpty(sampleSupplierList)) {
            for (SampleSupplierList entity : sampleSupplierList) {
                entity.setHeadId(purchaseSampleHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleHead);
            }
            if (!sampleSupplierList.isEmpty()) {
                this.sampleSupplierListMapper.insertBatchSomeColumn(sampleSupplierList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                attachment.setId(null);
                attachment.setHeadId(purchaseSampleHead.getId());
                attachment.setBusinessType("sample");
                attachment.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)purchaseSampleHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSampleItemMapper.deleteByMainId(id);
        this.purchaseSampleTrackingItemMapper.deleteByMainId(id);
        this.sampleSupplierListMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseSampleHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSampleItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSampleTrackingItemMapper.deleteByMainId(serializable.toString());
            this.sampleSupplierListMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseSampleHeadMapper.deleteById(serializable);
        }
    }

    public static void setHeadParamAndCheck(PurchaseSampleHeadVO headVO, boolean isPublish) {
        SysUtil.setNullCreate((BaseEntity)headVO);
        String elsAccount = TenantContext.getTenant();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setSampleStatus(isPublish ? PurchaseSampleStatusEnum.SAMPLE_NEW.getValue() : PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue());
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        if (isPublish) {
            Date currentDate = new Date();
            headVO.setPublishTime(currentDate);
            LoginUser user = SysUtil.getLoginUser();
            headVO.setPublishUser(String.valueOf(user.getSubAccount()) + "_" + user.getRealname());
            headVO.setSampleDate(headVO.getSampleDate() == null ? currentDate : headVO.getSampleDate());
            Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"", (String)"\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notEmpty(headVO.getPurchaseSampleItemList(), (String)I18nUtil.translate((String)"", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
            headVO.getPurchaseSampleItemList().forEach(item -> {
                if ("1".equals(headVO.getMustMaterialNumber())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            });
            Assert.notEmpty(headVO.getSampleSupplierList(), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    private void deleteSubTable(String headId) {
        this.purchaseSampleItemMapper.deleteByMainId(headId);
        this.sampleSupplierListMapper.deleteByMainId(headId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseSampleHeadVO headVO) {
        PurchaseSampleHeadServiceImpl.setHeadParamAndCheck(headVO, true);
        PurchaseSampleHead head = new PurchaseSampleHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            List<PurchaseOrganizationInfoDTO> list;
            String enquiryNumber = this.invokeBaseRpcService.getNextCode("srmSampleNumber", (Object)head);
            head.setSampleNumber(enquiryNumber);
            super.setHeadDefaultValue((BaseEntity)head);
            head.setApplyDate(new Date());
            head.setBusAccount(TenantContext.getTenant());
            head.setSampleStatus(PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue());
            head.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            LoginUser loginUser = SysUtil.getLoginUser();
            head.setApplicant(String.valueOf(loginUser.getSubAccount()) + "_" + loginUser.getRealname());
            if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length == 1 && !CollectionUtils.isEmpty(list = this.sampleInvokeMainDataRpcService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
                head.setApplyDept(String.valueOf(list.get(0).getOrgCode()) + "_" + list.get(0).getOrgName());
            }
            ((PurchaseSampleHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            head.setSampleStatus(PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue());
            ((PurchaseSampleHeadMapper)this.baseMapper).updateById((Object)head);
            this.deleteSubTable(head.getId());
        }
        List<PurchaseSampleItem> itemList = headVO.getPurchaseSampleItemList();
        List<SampleSupplierList> supplierList = headVO.getSampleSupplierList();
        this.insertInitTable(head.getId(), itemList);
        this.publishSample(head, itemList, supplierList, headVO.getPurchaseAttachmentList());
    }

    private void insertInitTable(String headId, List<PurchaseSampleItem> itemList) {
        int itemNumber = 1;
        for (PurchaseSampleItem item : itemList) {
            item.setItemNumber(String.valueOf(itemNumber++));
        }
        ElsInitialTableDTO elsInitialTable = new ElsInitialTableDTO();
        elsInitialTable.setRelationId(headId);
        elsInitialTable.setBusinessInfoJson(JSON.toJSONString(itemList));
        this.invokeBaseRpcService.addElsInitialTable(elsInitialTable);
    }

    @Override
    public AttachmentSendDTO publishSample(PurchaseSampleHead head, List<PurchaseSampleItem> itemList, List<SampleSupplierList> supplierList, List<PurchaseAttachmentDTO> attachmentList) {
        String headId = head.getId();
        List<String> toElsAccountList = supplierList.stream().map(SampleSupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseSampleItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.sampleInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        ArrayList<PurchaseSampleItem> insertItemList = new ArrayList<PurchaseSampleItem>();
        ArrayList<PurchaseAttachmentDTO> insertAttachList = new ArrayList<PurchaseAttachmentDTO>();
        LoginUser user = SysUtil.getLoginUser();
        for (SampleSupplierList supplier : supplierList) {
            supplier.setId(IdWorker.getIdStr());
            supplier.setHeadId(headId);
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            int itemNumber = 1;
            for (PurchaseSampleItem item2 : itemList) {
                PurchaseSampleItem insertItem = new PurchaseSampleItem();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)insertItem));
                insertItem.setId(null);
                insertItem.setHeadId(headId);
                insertItem.setSampleNumber(head.getSampleNumber());
                insertItem.setItemNumber(String.valueOf(itemNumber++));
                insertItem.setItemStatus(PurchaseSampleStatusItemEnum.WAIT_SUPPLIER_OPT.getValue());
                insertItem.setPurchaseName(user.getEnterpriseName());
                insertItem.setToElsAccount(supplier.getToElsAccount());
                insertItem.setSupplierName(supplier.getSupplierName());
                insertItem.setSupplierCode(supplier.getSupplierCode());
                if (EnquiryQuoteWayEnum.NORMAL.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setLadderPriceJson(null);
                    insertItem.setCostFormJson(null);
                }
                if (StrUtil.isNotBlank((CharSequence)item2.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(String.valueOf(item2.getMaterialNumber()) + supplier.getToElsAccount());
                    insertItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                SysUtil.setSysParam((BaseEntity)insertItem, (BaseEntity)head);
                insertItemList.add(insertItem);
            }
            for (PurchaseAttachmentDTO attachment : attachmentList) {
                PurchaseAttachmentDTO dto = new PurchaseAttachmentDTO();
                BeanUtils.copyProperties((Object)attachment, (Object)dto);
                dto.setElsAccount(supplier.getToElsAccount());
                insertAttachList.add(dto);
            }
        }
        this.purchaseSampleItemMapper.insertBatchSomeColumn(insertItemList);
        this.sampleSupplierListMapper.insertBatchSomeColumn(supplierList);
        Map<String, SaleSampleHead> supplierMap = this.saleSampleHeadService.add(head, insertItemList, supplierList, insertAttachList);
        HashMap<String, String> idMap = new HashMap<String, String>();
        supplierMap.forEach((key, value) -> {
            String string = idMap.put((String)key, value.getId());
        });
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(TenantContext.getTenant());
        sendVO.setHeadId(head.getId());
        HashMap toSend = new HashMap();
        idMap.forEach((key, value) -> {
            String string = toSend.put(value, key);
        });
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)head, receiveParamMap, "sample", "publish");
        return sendVO;
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, SaleSampleHead> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("busAccount", (Object)value.getBusAccount());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    public void publishNewSupplier(PurchaseSampleHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseSampleHead dbHead = (PurchaseSampleHead)((Object)((PurchaseSampleHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((!"0".equals(dbHead.getPublishNewSupplier()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        Assert.isTrue((boolean)dbHead.getApplyEndTime().after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        Assert.isTrue((!PurchaseSampleStatusEnum.CLOSE.getValue().equals(dbHead.getSampleStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5df2\u5173\u95ed\u7684\u5355\u636e\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        List hadList = this.sampleSupplierListMapper.selectByMainId(headId).parallelStream().map(SampleSupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<SampleSupplierList> supplierList = headVO.getSampleSupplierList().parallelStream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List itemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseSampleItem.class);
        this.publishSample(dbHead, itemList, supplierList, headVO.getPurchaseAttachmentList());
        List toElsAccountList = supplierList.stream().map(SampleSupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        String url = "enquiryNumber=" + dbHead.getSampleNumber();
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)dbHead, url, "sample", "publish");
    }

    @Override
    public void updateQuoteEntTime(PurchaseSampleHead dbHead, Date quoteEndTime) {
        PurchaseSampleHead updateHead = new PurchaseSampleHead();
        updateHead.setId(dbHead.getId());
        updateHead.setApplyEndTime(quoteEndTime);
        this.updateById((Object)updateHead);
        this.saleSampleHeadService.update((Wrapper)new LambdaUpdateWrapper().set(SaleSampleHead::getApplyEndTime, (Object)quoteEndTime));
    }

    @Override
    public void colse(String id) {
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadMapper.selectById((Serializable)((Object)id)));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id)).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleSampleHeadService.lambdaUpdate().eq(SaleSampleHead::getBusAccount, (Object)purchaseSampleHead.getElsAccount())).eq(SaleSampleHead::getSampleNumber, (Object)purchaseSampleHead.getSampleNumber())).set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update();
        List<PurchaseSampleItem> purchaseSampleItems = this.purchaseSampleItemMapper.selectByMainId(id);
        List collectPurchase = purchaseSampleItems.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectPurchase)).update();
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectSale)).update();
    }

    @Override
    public void cutOff(String id) {
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadMapper.selectById((Serializable)((Object)id)));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id)).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue())).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleSampleHeadService.lambdaUpdate().eq(SaleSampleHead::getBusAccount, (Object)purchaseSampleHead.getElsAccount())).eq(SaleSampleHead::getSampleNumber, (Object)purchaseSampleHead.getSampleNumber())).eq(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue())).set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.saleSampleHeadService.lambdaQuery().eq(SaleSampleHead::getBusAccount, (Object)purchaseSampleHead.getElsAccount())).eq(SaleSampleHead::getSampleNumber, (Object)purchaseSampleHead.getSampleNumber())).eq(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List collectSale = list.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
            SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(SaleSampleItem::getHeadId, collectSale)).update();
        }
    }

    @Override
    public void colseByItems(List<PurchaseSampleItem> purchaseSampleItemList) {
        List collectPurchase = purchaseSampleItemList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(collectPurchase);
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectPurchase)).update();
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectSale)).update();
        List<PurchaseSampleItem> purchaseSampleItems1 = purchaseSampleItemService.selectByMainId(purchaseSampleItemList.get(0).getHeadId());
        if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseSampleItemList.get(0).getHeadId())).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update();
        } else if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseSampleItemList.get(0).getHeadId())).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue())).update();
        }
    }

    @Override
    public void signSample(List<PurchaseSampleItem> purchaseSampleItemList) {
        purchaseSampleItemList.forEach(item -> {
            if (!PurchaseSampleStatusItemEnum.SENDING_SAMPLES.getValue().equals(item.getItemStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5df2\u9009\u4e2d\u884c\u4e2d\u5b58\u5728\u72b6\u6001\u4e0d\u4e3a\u9001\u6837\u4e2d\u7684\u884c\u9879\u76ee"));
            }
        });
        List collectPurchase = purchaseSampleItemList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(collectPurchase);
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, collectPurchase)).update();
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, collectSale)).update();
        List<PurchaseSampleItem> purchaseSampleItems1 = purchaseSampleItemService.selectByMainId(purchaseSampleItemList.get(0).getHeadId());
        if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseSampleItemList.get(0).getHeadId())).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue())).update();
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(SaleSampleHead::getRelationId, (Object)purchaseSampleItemList.get(0).getHeadId());
            updateWrapper.lambda().set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue());
            SaleSampleHeadService saleSampleheadService = (SaleSampleHeadService)SpringContextUtils.getBean(SaleSampleHeadServiceImpl.class);
            saleSampleheadService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void deliveryByOrder(List<String> sampleItemList, String headId) {
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(sampleItemList);
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, sampleItemList)).update();
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, collectSale)).update();
        List<PurchaseSampleItem> purchaseSampleItems1 = purchaseSampleItemService.selectByMainId(headId);
        if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)headId)).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue())).update();
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(SaleSampleHead::getRelationId, (Object)headId);
            updateWrapper.lambda().set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue());
            SaleSampleHeadService saleSampleheadService = (SaleSampleHeadService)SpringContextUtils.getBean(SaleSampleHeadServiceImpl.class);
            saleSampleheadService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void orderByRequestItem(List<String> sampleItemList) {
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(sampleItemList);
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.ORDER_TRANSFERRED.getValue())).in(BaseEntity::getId, sampleItemList)).update();
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.ORDER_TRANSFERRED.getValue())).in(BaseEntity::getId, collectSale)).update();
    }
}

