/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.quality.entity.PurchaseRetificationReviewTeam;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportItem;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportHeadService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierRetificationAuditOptCallBackServiceImpl")
public class SupplierRetificationAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String bussinessId = inputParamVO.getBusinessId();
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)bussinessId)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(purchaseSupplierRectificationReportHead.getPreAuditStatus())) {
            throw new ELSBootException("\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u5df2\u7ecf\u5904\u4e8e\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u5ba1\u6279");
        }
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendSupplierRetificationToSale(inputParamVO.getBusinessId());
        }
    }

    private void sendSupplierRetificationToSale(String businessId) {
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)businessId)));
        List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList = this.purchaseSupplierRectificationReportItemMapper.selectByMainId(businessId);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(businessId);
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(businessId);
        ((PurchaseSupplierRectificationReportHeadService)SpringContextUtils.getBean(PurchaseSupplierRectificationReportHeadService.class)).publish(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportItemList, purchaseRetificationReviewTeamList, purchaseAttachmentList);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSupplierRectificationReportHead supplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(inputParamVO.getBusinessId());
        supplierRectificationReportHead.setPreAuditStatus(outputParamVO.getAuditStatus());
        supplierRectificationReportHead.setPreFlowCode(outputParamVO.getProcessRootId());
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)supplierRectificationReportHead);
    }
}

