/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.SaleSupplierRectificationReportHead;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportHeadMapper;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplierRetificationResultAuditOptCallBackServiceImpl")
public class SupplierRetificationResultAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;
    @Resource
    private SaleSupplierRectificationReportHeadMapper saleSupplierRectificationReportHeadMapper;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String bussinessId = inputParamVO.getBusinessId();
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)bussinessId)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(purchaseSupplierRectificationReportHead.getPreAuditStatus())) {
            throw new ELSBootException("\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u5df2\u7ecf\u5904\u4e8e\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u5ba1\u6279");
        }
        this.updateStatus(inputParamVO, outputParamVO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.updateStatus(inputParamVO, outputParamVO, SupplierRectificationStatusEnum.RECTIFICATIONED.getValue());
        } else {
            this.updateStatus(inputParamVO, outputParamVO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String rectificationStatus) {
        PurchaseSupplierRectificationReportHead supplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(inputParamVO.getBusinessId());
        supplierRectificationReportHead.setResultAuditStatus(outputParamVO.getAuditStatus());
        supplierRectificationReportHead.setResultFlowCode(outputParamVO.getProcessRootId());
        supplierRectificationReportHead.setWorkFlowType(outputParamVO.getBpmnType());
        supplierRectificationReportHead.setRectificationStatus(rectificationStatus);
        String params = inputParamVO.getParams();
        JSONObject paramsJsonObject = null;
        if (StringUtils.isNotBlank((CharSequence)params)) {
            paramsJsonObject = JSONObject.parseObject((String)params);
        }
        if (paramsJsonObject != null && SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(rectificationStatus)) {
            supplierRectificationReportHead.setRectificationConclusion(paramsJsonObject.getString("rectificationConclusion"));
        } else {
            supplierRectificationReportHead.setRectificationConclusion(null);
        }
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)supplierRectificationReportHead);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(SaleSupplierRectificationReportHead::getRectificationStatus, (Object)rectificationStatus);
        updateWrapper.lambda().set(SaleSupplierRectificationReportHead::getRectificationConclusion, (Object)supplierRectificationReportHead.getRectificationConclusion());
        updateWrapper.lambda().eq(SaleSupplierRectificationReportHead::getRelationId, (Object)inputParamVO.getBusinessId());
        this.saleSupplierRectificationReportHeadMapper.update(null, (Wrapper)updateWrapper);
    }
}

