/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.enumerate.CheckStatusEnum;
import com.els.modules.quality.api.dto.PurchaseQualityCheckItemDTO;
import com.els.modules.quality.entity.PurchaseQualityCheckHead;
import com.els.modules.quality.entity.PurchaseQualityCheckItem;
import com.els.modules.quality.entity.SaleQualityCheckHead;
import com.els.modules.quality.entity.SaleQualityCheckItem;
import com.els.modules.quality.enumerate.CheckSourceTypeEnum;
import com.els.modules.quality.mapper.PurchaseQualityCheckHeadMapper;
import com.els.modules.quality.mapper.PurchaseQualityCheckItemMapper;
import com.els.modules.quality.mapper.SaleQualityCheckHeadMapper;
import com.els.modules.quality.mapper.SaleQualityCheckItemMapper;
import com.els.modules.quality.rpc.service.QualityInvokeSupplierRpcService;
import com.els.modules.quality.service.PurchaseQualityCheckHeadService;
import com.els.modules.quality.vo.PurchaseQualityCheckHeadVO;
import com.els.modules.report.rpc.service.InvokeOrderRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseQualityCheckHeadServiceImpl
extends ServiceImpl<PurchaseQualityCheckHeadMapper, PurchaseQualityCheckHead>
implements PurchaseQualityCheckHeadService {
    @Resource
    private PurchaseQualityCheckHeadMapper purchaseQualityCheckHeadMapper;
    @Resource
    private PurchaseQualityCheckItemMapper purchaseQualityCheckItemMapper;
    @Resource
    private SaleQualityCheckHeadMapper saleQualityCheckHeadMapper;
    @Resource
    private SaleQualityCheckItemMapper saleQualityCheckItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private QualityInvokeSupplierRpcService qualityInvokeSupplierRpcService;
    @Autowired
    private InvokeOrderRpcService invokeOrderRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseQualityCheckHead purchaseQualityCheckHead, List<PurchaseQualityCheckItem> purchaseQualityCheckItemList) {
        purchaseQualityCheckHead.setCheckStatus(CheckStatusEnum.NEW.getValue());
        purchaseQualityCheckHead.setSourceType(CheckSourceTypeEnum.MANUAL.getValue());
        purchaseQualityCheckHead.setBusAccount(TenantContext.getTenant());
        purchaseQualityCheckHead.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmCheckNumber", (Object)purchaseQualityCheckHead));
        String publishAudit = purchaseQualityCheckHead.getPublishAudit();
        this.setDefualtValue(purchaseQualityCheckHead);
        if (StringUtils.isNotBlank((CharSequence)publishAudit)) {
            purchaseQualityCheckHead.setPublishAudit(publishAudit);
        }
        if ("1".equals(purchaseQualityCheckHead.getPublishAudit())) {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseQualityCheckHeadMapper.insert((Object)purchaseQualityCheckHead);
        this.insertData(purchaseQualityCheckHead, purchaseQualityCheckItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseQualityCheckHead purchaseQualityCheckHead, List<PurchaseQualityCheckItem> purchaseQualityCheckItemList) {
        String publishAudit = purchaseQualityCheckHead.getPublishAudit();
        if ("1".equals(publishAudit)) {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseQualityCheckHeadMapper.updateById((Object)purchaseQualityCheckHead);
        this.purchaseQualityCheckItemMapper.deleteByMainId(purchaseQualityCheckHead.getId());
        this.insertData(purchaseQualityCheckHead, purchaseQualityCheckItemList);
    }

    private void insertData(PurchaseQualityCheckHead purchaseQualityCheckHead, List<PurchaseQualityCheckItem> purchaseQualityCheckItemList) {
        if (purchaseQualityCheckItemList != null) {
            for (PurchaseQualityCheckItem entity : purchaseQualityCheckItemList) {
                entity.setHeadId(purchaseQualityCheckHead.getId());
                entity.setId(null);
                entity.setCheckNumber(purchaseQualityCheckHead.getCheckNumber());
                entity.setItemNumber(purchaseQualityCheckHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseQualityCheckHead);
            }
            if (!purchaseQualityCheckItemList.isEmpty()) {
                this.purchaseQualityCheckItemMapper.insertBatchSomeColumn(purchaseQualityCheckItemList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseQualityCheckItemMapper.deleteByMainId(id);
        this.purchaseQualityCheckHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseQualityCheckItemMapper.deleteByMainId(serializable.toString());
            this.purchaseQualityCheckHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseQualityCheckHead head, List<PurchaseQualityCheckItem> itemList) {
        String resultSyncSupplier;
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        String publishAudit = head.getPublishAudit();
        if ("1".equals(publishAudit) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_auditViaPublish", (String)"\u5ba1\u6279\u901a\u8fc7\u624d\u53ef\u4ee5\u53d1\u5e03\uff01"));
        }
        head.setCheckStatus(CheckStatusEnum.CHECK_DONE.getValue());
        head.setCheckEndDate(new Date());
        this.purchaseQualityCheckHeadMapper.updateById((Object)head);
        PurchaseQualityCheckHead checkHead = (PurchaseQualityCheckHead)((Object)this.purchaseQualityCheckHeadMapper.selectById((Serializable)((Object)head.getId())));
        this.purchaseQualityCheckItemMapper.deleteByMainId(head.getId());
        for (PurchaseQualityCheckItem item : itemList) {
            String decisionConclusion;
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            item.setHeadId(head.getId());
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setId(null);
            }
            if ("Accept".equals(decisionConclusion = item.getDecisionConclusion())) {
                item.setTestResult("1");
                JSONObject urlParam = new JSONObject();
                urlParam.put("id", (Object)head.getId());
                urlParam.put("checkNumber", (Object)item.getCheckNumber());
                receiveParamMap.put(head.getElsAccount(), urlParam);
                continue;
            }
            item.setTestResult("2");
        }
        if (itemList != null && !itemList.isEmpty()) {
            this.purchaseQualityCheckItemMapper.insertBatchSomeColumn(itemList);
        }
        if ("1".equals(resultSyncSupplier = head.getResultSyncSupplier())) {
            SaleQualityCheckHead saleHead = new SaleQualityCheckHead();
            BeanUtil.copyProperties((Object)((Object)head), (Object)((Object)saleHead), (String[])new String[0]);
            saleHead.setId(IdWorker.getIdStr());
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(head.getToElsAccount());
            saleHead.setToElsAccount(head.getElsAccount());
            this.saleQualityCheckHeadMapper.insert((Object)saleHead);
            ArrayList<SaleQualityCheckItem> saleItemList = new ArrayList<SaleQualityCheckItem>();
            for (PurchaseQualityCheckItem item : itemList) {
                SaleQualityCheckItem saleItem = new SaleQualityCheckItem();
                BeanUtil.copyProperties((Object)((Object)item), (Object)((Object)saleItem), (String[])new String[0]);
                saleItem.setId(null);
                saleItem.setHeadId(saleHead.getId());
                saleItem.setRelationId(item.getId());
                saleItem.setCheckNumber(saleHead.getCheckNumber());
                saleItem.setItemNumber(saleHead.getId());
                saleItem.setElsAccount(saleHead.getElsAccount());
                saleItemList.add(saleItem);
            }
            if (!saleItemList.isEmpty()) {
                this.saleQualityCheckItemMapper.insertBatchSomeColumn(saleItemList);
            }
            PurchaseQualityCheckHead updateHead = new PurchaseQualityCheckHead();
            updateHead.setId(head.getId());
            updateHead.setSendStatus("1");
            updateHead.setRelationId(saleHead.getId());
            this.purchaseQualityCheckHeadMapper.updateById((Object)updateHead);
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setHeadId(head.getId());
            sendVO.setElsAccount(head.getElsAccount());
            HashMap<String, String> toSend = new HashMap<String, String>();
            String id = saleHead.getElsAccount();
            String id2 = saleHead.getId();
            toSend.put(id2, id);
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
        }
        if (checkHead.getSourceType().equals(CheckSourceTypeEnum.DELIVERY_VOUCHER.getValue())) {
            this.invokeOrderRpcService.createChargeAgainstByQuality(SysUtil.copyProperties(itemList, PurchaseQualityCheckItemDTO.class));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseQualityCheckHead head, List<PurchaseQualityCheckItem> itemList) {
        head.setCheckStatus(CheckStatusEnum.CHECK_ING.getValue());
        this.purchaseQualityCheckHeadMapper.updateById((Object)head);
        this.purchaseQualityCheckItemMapper.deleteByMainId(head.getId());
        for (PurchaseQualityCheckItem item : itemList) {
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            item.setHeadId(head.getId());
            item.setId(null);
            item.setItemNumber(head.getId());
            item.setCheckNumber(head.getCheckNumber());
        }
        if (itemList != null && !itemList.isEmpty()) {
            this.purchaseQualityCheckItemMapper.insertBatchSomeColumn(itemList);
        }
    }

    private void setDefualtValue(PurchaseQualityCheckHead head) {
        Map defualtMap = this.invokeBaseRpcService.getHeadDefaultValuetMap(head.getTemplateAccount(), head.getTemplateNumber(), head.getTemplateVersion() + "");
        HashMap defaultMap1 = new HashMap();
        Set keys = defualtMap.keySet();
        if (CollectionUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)defualtMap.get(key)))) continue;
                defaultMap1.put(key, defualtMap.get(key));
            }
        }
        BeanUtil.copyProperties(defaultMap1, (Object)((Object)head), (String[])new String[0]);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseQualityCheckHead publishCheck(PurchaseQualityCheckHead head, List<PurchaseQualityCheckItem> itemList) {
        List list = this.invokeBaseRpcService.getDefaultTemplateByType("qualityCheck");
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_businessTemplate", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        TemplateHeadDTO templateHead = (TemplateHeadDTO)list.get(0);
        head.setTemplateName(templateHead.getTemplateName());
        head.setTemplateNumber(templateHead.getTemplateNumber());
        head.setTemplateVersion(templateHead.getTemplateVersion());
        head.setTemplateAccount(templateHead.getElsAccount());
        this.setDefualtValue(head);
        head.setCheckStatus(CheckStatusEnum.CHECK_ING.getValue());
        head.setBusAccount(TenantContext.getTenant());
        head.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmCheckNumber", (Object)head));
        head.setSourceType(CheckSourceTypeEnum.DELIVERY_VOUCHER.getValue());
        String publishAudit = head.getPublishAudit();
        if ("1".equals(publishAudit)) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseQualityCheckHeadMapper.insert((Object)head);
        this.insertData(head, itemList);
        return head;
    }

    @Override
    public PurchaseQualityCheckHeadVO createQuality(List<PurchaseVoucherItemDTO> voucherItems) {
        if (CollectionUtil.isEmpty(voucherItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_voucherLine", (String)"\u51ed\u8bc1\u884c\u4e3a\u7a7a"));
        }
        PurchaseVoucherItemDTO purchaseVoucherItem = voucherItems.get(0);
        String toElsAccount = purchaseVoucherItem.getToElsAccount();
        String company = purchaseVoucherItem.getCompany();
        String purchaseOrg = purchaseVoucherItem.getPurchaseOrg();
        String purchaseGroup = purchaseVoucherItem.getPurchaseGroup();
        String factory = purchaseVoucherItem.getFactory();
        String storageLocation = purchaseVoucherItem.getStorageLocation();
        String srmReceiptNumber = purchaseVoucherItem.getVoucherNumber();
        SupplierMasterDataDTO masterData = this.qualityInvokeSupplierRpcService.getByAccount(TenantContext.getTenant(), toElsAccount);
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchaseQualityCheckHead purchaseQualityCheckHead = new PurchaseQualityCheckHead();
        purchaseQualityCheckHead.setBusAccount(TenantContext.getTenant());
        purchaseQualityCheckHead.setPurchaseName(loginUser.getEnterpriseName());
        purchaseQualityCheckHead.setSourceType(CheckSourceTypeEnum.DELIVERY_VOUCHER.getValue());
        purchaseQualityCheckHead.setToElsAccount(toElsAccount);
        purchaseQualityCheckHead.setSupplierCode(masterData.getSupplierCode());
        purchaseQualityCheckHead.setSupplierName(masterData.getSupplierName());
        purchaseQualityCheckHead.setCompany(company);
        purchaseQualityCheckHead.setFactory(factory);
        purchaseQualityCheckHead.setStorageLocation(storageLocation);
        purchaseQualityCheckHead.setCheckStartDate(DateUtils.getDate());
        purchaseQualityCheckHead.setSrmReceiptNumber(srmReceiptNumber);
        ArrayList<PurchaseQualityCheckItem> purchaseQualityCheckItems = new ArrayList<PurchaseQualityCheckItem>();
        for (PurchaseVoucherItemDTO voucherItem : voucherItems) {
            PurchaseQualityCheckItem purchaseQualityCheckItem = new PurchaseQualityCheckItem();
            BeanUtils.copyProperties((Object)voucherItem, (Object)((Object)purchaseQualityCheckItem));
            purchaseQualityCheckItem.setSourceType("0");
            purchaseQualityCheckItem.setSourceNumber(voucherItem.getVoucherNumber());
            purchaseQualityCheckItem.setSourceItemNumber(voucherItem.getItemNumber());
            purchaseQualityCheckItem.setSourceItemId(voucherItem.getId());
            purchaseQualityCheckItem.setCheckQuantity(voucherItem.getVoucherQuantity());
            purchaseQualityCheckItems.add(purchaseQualityCheckItem);
        }
        PurchaseQualityCheckHead qualityCheckHead = this.publishCheck(purchaseQualityCheckHead, purchaseQualityCheckItems);
        PurchaseQualityCheckHeadVO purchaseQualityCheckHeadVO = new PurchaseQualityCheckHeadVO();
        BeanUtils.copyProperties((Object)((Object)qualityCheckHead), (Object)((Object)purchaseQualityCheckHeadVO));
        purchaseQualityCheckHeadVO.setPurchaseQualityCheckItemList(purchaseQualityCheckItems);
        return purchaseQualityCheckHeadVO;
    }
}

