/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcnsample.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.mcnsample.entity.MerchandiseInventoryHead;
import com.els.modules.mcnsample.service.MerchandiseInventoryHeadService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="merchandiseInventoryImportServiceImpl")
public class MerchandiseInventoryImportServiceImpl
implements ExcelImportRpcService {
    @Autowired
    private MerchandiseInventoryHeadService merchandiseInventoryHeadService;
    @Autowired
    private TemplateRpcService templateRpcService;
    protected Log log = LogFactory.getLog(this.getClass());

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        MerchandiseInventoryImportHandleBean bean = new MerchandiseInventoryImportHandleBean(dataList);
        this.handle(bean);
        for (List merchandiseInventoryHeads : bean.resultList) {
            this.merchandiseInventoryHeadService.saveOrUpdateBatch(merchandiseInventoryHeads, merchandiseInventoryHeads.size());
        }
        return dataList;
    }

    private void handle(MerchandiseInventoryImportHandleBean bean) {
        MerchandiseInventoryHead finalBean;
        List dataList = bean.dataList;
        int nowIndex = bean.nowIndex++;
        if (dataList.size() == nowIndex) {
            if (bean.materialNumberList.size() > 0) {
                List<MerchandiseInventoryHead> materialList = this.merchandiseInventoryHeadService.listByMaterialNumbers(bean.materialNumberList);
                bean.materialMap = materialList.stream().collect(Collectors.toMap(MerchandiseInventoryHead::getSupplierNo, Function.identity(), (newVal, oldVal) -> oldVal));
            }
            return;
        }
        Map map = (Map)dataList.get(nowIndex);
        MerchandiseInventoryHead importBean = (MerchandiseInventoryHead)((Object)JSON.parseObject((String)JSON.toJSONString((Object)map), MerchandiseInventoryHead.class));
        String supplierNo = importBean.getSupplierNo();
        Assert.hasText((String)supplierNo, (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        bean.materialNumberList.add(supplierNo);
        this.handle(bean);
        Map materialMap = bean.materialMap;
        MerchandiseInventoryHead oldBean = (MerchandiseInventoryHead)((Object)materialMap.get(supplierNo));
        LoginUser loginUser = SysUtil.getLoginUser();
        if (oldBean != null) {
            finalBean = oldBean;
            finalBean.setSupplierName(importBean.getSupplierName());
            finalBean.setBrand(importBean.getBrand());
            finalBean.setCompany(importBean.getCompany());
            finalBean.setSupplierType(importBean.getSupplierType());
            finalBean.setSupplierTypeName(importBean.getSupplierTypeName());
            finalBean.setSupplierGroup(importBean.getSupplierGroup());
            finalBean.setSupplierGroupName(importBean.getSupplierGroupName());
            finalBean.setSupplierDesc(importBean.getSupplierDesc());
            finalBean.setSupplierStandards(importBean.getSupplierStandards());
            finalBean.setInventoryAddressNo(importBean.getInventoryAddressNo());
            finalBean.setInventoryAddressDesc(importBean.getInventoryAddressDesc());
            finalBean.setInventoryAlertQuantity(importBean.getInventoryAlertQuantity());
            finalBean.setInventoryBalanceQuantity(importBean.getInventoryBalanceQuantity());
            finalBean.setRemark(importBean.getRemark());
        } else {
            finalBean = importBean;
            finalBean.setAssignmentStatus("0");
            TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)bean.templateHeadDTOList.get(0);
            finalBean.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            finalBean.setTemplateName(templateHeadDTO.getTemplateName());
            finalBean.setTemplateVersion(templateHeadDTO.getTemplateVersion());
            finalBean.setTemplateAccount(templateHeadDTO.getTemplateAccount());
            finalBean.setElsAccount(loginUser.getElsAccount());
            finalBean.setCreateBy(loginUser.getSubAccount());
            finalBean.setCreateTime(new Date());
            finalBean.setUpdateBy(loginUser.getSubAccount());
        }
        finalBean.setUpdateBy(loginUser.getSubAccount());
        finalBean.setUpdateTime(new Date());
        bean.setResultList(finalBean);
    }

    static /* synthetic */ TemplateRpcService access$800(MerchandiseInventoryImportServiceImpl x0) {
        return x0.templateRpcService;
    }

    private class MerchandiseInventoryImportHandleBean {
        private int nowIndex = 0;
        private final List<Map<String, Object>> dataList;
        private final List<String> materialNumberList;
        private final List<List<MerchandiseInventoryHead>> resultList;
        private int resultIndex = 0;
        private final List<TemplateHeadDTO> templateHeadDTOList = MerchandiseInventoryImportServiceImpl.access$800(MerchandiseInventoryImportServiceImpl.this).getDefaultTemplateByType("popularizeProjectManager");
        private Map<String, MerchandiseInventoryHead> materialMap = Collections.emptyMap();

        private MerchandiseInventoryImportHandleBean(List<Map<String, Object>> dataList) {
            if (dataList == null) {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u5bfc\u5165\u5f02\u5e38\uff1anull"));
            }
            this.dataList = dataList;
            this.materialNumberList = new ArrayList<String>(dataList.size());
            this.resultList = new ArrayList<List<MerchandiseInventoryHead>>((int)Math.ceil((double)dataList.size() / 1000.0));
        }

        private void setResultList(MerchandiseInventoryHead head) {
            List<MerchandiseInventoryHead> merchandiseInventoryHeads = this.resultList.get(this.resultIndex);
            if (merchandiseInventoryHeads == null) {
                merchandiseInventoryHeads = new ArrayList<MerchandiseInventoryHead>(Math.min(1000, this.dataList.size() - this.resultIndex * 1000));
                this.resultList.add(merchandiseInventoryHeads);
            }
            if (merchandiseInventoryHeads.size() == 1000) {
                ++this.resultIndex;
                this.setResultList(head);
            } else {
                merchandiseInventoryHeads.add(head);
            }
        }
    }
}

