/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcnsample.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.mcnsample.entity.MerchandiseInventoryHead;
import com.els.modules.mcnsample.entity.MerchandiseInventoryItem;
import com.els.modules.mcnsample.service.MerchandiseInventoryHeadService;
import com.els.modules.mcnsample.service.MerchandiseInventoryItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/merchandise/inventory"})
@Api(tags={"\u5546\u54c1\u5e93\u5b58\u7ba1\u7406"})
public class MerchandiseInventoryController
extends BaseController<MerchandiseInventoryHead, MerchandiseInventoryHeadService> {
    private static final Logger log = LoggerFactory.getLogger(MerchandiseInventoryController.class);
    @Autowired
    private MerchandiseInventoryItemService merchandiseInventoryItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(MerchandiseInventoryHead merchandiseInventoryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)merchandiseInventoryHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((MerchandiseInventoryHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        MerchandiseInventoryHead merchandiseInventoryHead = (MerchandiseInventoryHead)((Object)((MerchandiseInventoryHeadService)this.service).getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)merchandiseInventoryHead));
    }

    @ApiOperation(value="\u901a\u8fc7\u8868\u5934id\u67e5\u8be2\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u8868\u5934id\u67e5\u8be2\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryItemByHeadId"})
    public Result<?> queryItemByHeadId(final @RequestParam(name="headId") String headId) {
        QueryWrapper<MerchandiseInventoryItem> queryWrapper = new QueryWrapper<MerchandiseInventoryItem>(){
            {
                this.lambda().eq(MerchandiseInventoryItem::getHeadId, (Object)headId);
                this.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            }
        };
        List merchandiseInventoryItems = this.merchandiseInventoryItemService.list((Wrapper)queryWrapper);
        return Result.ok((Object)merchandiseInventoryItems);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(MerchandiseInventoryHead merchandiseInventoryHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)merchandiseInventoryHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
        queryWrapper.select(new String[]{"assignment_status", "count(0) as quantity"});
        queryWrapper.groupBy((Object)"assignment_status");
        List list = ((MerchandiseInventoryHeadService)this.service).list((Wrapper)queryWrapper);
        final Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(MerchandiseInventoryHead::getAssignmentStatus, MerchandiseInventoryHead::getQuantity));
        final List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode("assignmentStatus", TenantContext.getTenant());
        ArrayList<CountVO> result = new ArrayList<CountVO>(dictDTOS.size()){
            {
                super(x0);
                CountVO countVO = new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "assignmentStatus", null, Integer.valueOf(0));
                this.add(countVO);
                Integer all = 0;
                for (DictDTO status : dictDTOS) {
                    Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : (Integer)countMap.get(status.getValue());
                    all = all + total;
                    this.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "assignmentStatus", status.getValue(), total));
                }
                countVO.setTotal(all);
            }
        };
        return Result.ok((Object)result);
    }
}

