/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.siteInspection.entity.ElsInspectionStandardHead;
import com.els.modules.siteInspection.entity.ElsInspectionStandardItem;
import com.els.modules.siteInspection.entity.ElsInspectionStandardItemDetail;
import com.els.modules.siteInspection.entity.ElsInspectionStandardItemWeight;
import com.els.modules.siteInspection.entity.ElsInspectionStandardScoreGrade;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardHeadMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemDetailMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemWeightMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardScoreGradeMapper;
import com.els.modules.siteInspection.rpc.SiteInspectBaseRpcService;
import com.els.modules.siteInspection.service.ElsInspectionStandardHeadService;
import com.els.modules.siteInspection.service.ElsInspectionStandardItemDetailService;
import com.els.modules.siteInspection.service.ElsInspectionStandardItemService;
import com.els.modules.siteInspection.service.ElsInspectionStandardItemWeightService;
import com.els.modules.siteInspection.service.ElsInspectionStandardScoreGradeService;
import com.els.modules.siteInspection.utils.BigDecimalUtil;
import com.els.modules.siteInspection.vo.ElsInspectionStandardHeadSaveVO;
import com.els.modules.siteInspection.vo.ElsInspectionStandardHeadSubmitVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ElsInspectionStandardHeadServiceImpl
extends BaseServiceImpl<ElsInspectionStandardHeadMapper, ElsInspectionStandardHead>
implements ElsInspectionStandardHeadService {
    private static final int BATCH_SIZE = 2000;
    @Resource
    private ElsInspectionStandardItemMapper itemMapper;
    @Resource
    private ElsInspectionStandardItemWeightMapper itemWeightMapper;
    @Resource
    private ElsInspectionStandardScoreGradeMapper scoreGradeMapper;
    @Resource
    private ElsInspectionStandardItemDetailMapper itemDetailMapper;
    @Autowired
    private ElsInspectionStandardItemService itemService;
    @Autowired
    private ElsInspectionStandardItemWeightService itemWeightService;
    @Autowired
    private ElsInspectionStandardScoreGradeService scoreGradeService;
    @Autowired
    private ElsInspectionStandardItemDetailService itemDetailService;
    @Autowired
    private SiteInspectBaseRpcService baseRpcService;

    private String getSerialNumber(Object businessObj) {
        return this.baseRpcService.getNextCode("inspectionStandardNumber", businessObj);
    }

    private void delByHeadId(String headId) {
        if (StringUtils.isBlank((CharSequence)headId)) {
            return;
        }
        this.itemMapper.deleteByMainId(headId);
        this.itemDetailMapper.deleteByMainId(headId);
        this.itemWeightMapper.deleteByMainId(headId);
        this.scoreGradeMapper.deleteByMainId(headId);
    }

    private void setBaseEntity(BaseEntity baseEntity) {
        Date now = new Date();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        baseEntity.setElsAccount(TenantContext.getTenant()).setCreateTime(now).setUpdateTime(now).setCreateBy(sysUser.getSubAccount()).setUpdateBy(sysUser.getSubAccount()).setDeleted(CommonConstant.DEL_FLAG_0).setId(IdWorker.getIdStr());
    }

    private void saveItemDetail(String headId, String itemId, List<ElsInspectionStandardItemDetail> itemDetailVoList) {
        if (CollectionUtils.isEmpty(itemDetailVoList)) {
            return;
        }
        List itemDetailList = itemDetailVoList.stream().map(vo -> {
            ElsInspectionStandardItemDetail itemDetail = new ElsInspectionStandardItemDetail();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)itemDetail));
            itemDetail.setHeadId(headId).setItemId(itemId);
            this.setBaseEntity(itemDetail);
            return itemDetail;
        }).collect(Collectors.toList());
        this.itemDetailService.saveBatch(itemDetailList, 2000);
    }

    private void saveItem(String headId, List<ElsInspectionStandardItem> itemVoList) {
        if (CollectionUtils.isEmpty(itemVoList)) {
            return;
        }
        List itemList = itemVoList.stream().map(itemVo -> {
            ElsInspectionStandardItem elsInspectionStandardItem = new ElsInspectionStandardItem();
            BeanUtils.copyProperties((Object)itemVo, (Object)((Object)elsInspectionStandardItem));
            elsInspectionStandardItem.setHeadId(headId);
            this.setBaseEntity(elsInspectionStandardItem);
            if (!"2".equals(itemVo.getScoringType())) {
                this.saveItemDetail(headId, elsInspectionStandardItem.getId(), itemVo.getItemDetailList());
            }
            return elsInspectionStandardItem;
        }).collect(Collectors.toList());
        this.itemService.saveBatch(itemList, 2000);
    }

    private void saveItemWeight(String headId, List<ElsInspectionStandardItemWeight> itemWeightVoList) {
        if (CollectionUtils.isEmpty(itemWeightVoList)) {
            return;
        }
        List itemWeightList = itemWeightVoList.stream().map(vo -> {
            ElsInspectionStandardItemWeight itemWeight = new ElsInspectionStandardItemWeight();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)itemWeight));
            itemWeight.setHeadId(headId);
            this.setBaseEntity(itemWeight);
            return itemWeight;
        }).collect(Collectors.toList());
        this.itemWeightService.saveBatch(itemWeightList, 2000);
    }

    private String getSaveQualifiedPoints(List<ElsInspectionStandardScoreGrade> scoreGradeVoList) {
        if (CollectionUtils.isEmpty(scoreGradeVoList)) {
            return "";
        }
        if (CollectionUtils.isEmpty(scoreGradeVoList = scoreGradeVoList.stream().filter(scoreGradeVo -> StringUtils.isNotBlank((CharSequence)scoreGradeVo.getScoreLowerLimit()) && "0".equals(scoreGradeVo.getInspectionConclusion())).collect(Collectors.toList()))) {
            return "";
        }
        scoreGradeVoList.sort((a, b) -> BigDecimalUtil.compare(a.getScoreLowerLimit(), b.getScoreLowerLimit()));
        return scoreGradeVoList.get(0).getScoreLowerLimit();
    }

    private void saveScoreGrade(String headId, List<ElsInspectionStandardScoreGrade> scoreGradeVoList) {
        if (CollectionUtils.isEmpty(scoreGradeVoList)) {
            return;
        }
        List scoreGradeList = scoreGradeVoList.stream().map(vo -> {
            ElsInspectionStandardScoreGrade scoreGrade = new ElsInspectionStandardScoreGrade();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)scoreGrade));
            this.setBaseEntity(scoreGrade);
            scoreGrade.setHeadId(headId);
            if (Objects.isNull(scoreGrade.getScoreLimit())) {
                scoreGrade.setScoreLimit(BigDecimal.ZERO.toString());
            }
            if (Objects.isNull(scoreGrade.getScoreLowerLimit())) {
                scoreGrade.setScoreLowerLimit(BigDecimal.ZERO.toString());
            }
            return scoreGrade;
        }).collect(Collectors.toList());
        this.scoreGradeService.saveBatch(scoreGradeList, 2000);
    }

    private String sumSaveTotalScore(List<ElsInspectionStandardItem> itemVoList) {
        if (CollectionUtils.isEmpty(itemVoList)) {
            return null;
        }
        BigDecimal totalScore = itemVoList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getFullMark())).map(item -> new BigDecimal(item.getFullMark())).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalScore.toString();
    }

    private String sumSubmitTotalScore(List<ElsInspectionStandardItem> itemList) {
        BigDecimal totalScore = itemList.stream().map(item -> new BigDecimal(item.getFullMark())).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalScore.toString();
    }

    private void validItemWeight(List<ElsInspectionStandardItemWeight> itemWeightList) {
        BigDecimal totalWeight = itemWeightList.stream().map(item -> new BigDecimal(item.getClassifyWeight())).reduce(BigDecimal.ZERO, BigDecimal::add);
        AssertI18nUtil.isTrue((!BigDecimalUtil.equalOneHundred(totalWeight) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.ITEM_WEIGHT_EQUAL_ONE_HUNDRED);
    }

    private void validScoreGrade(String standardFullMarks, List<ElsInspectionStandardScoreGrade> scoreGradeList) {
        for (ElsInspectionStandardScoreGrade scoreGrade : scoreGradeList) {
            if (!StringUtils.isBlank((CharSequence)scoreGrade.getScoreLimit()) && !StringUtils.isBlank((CharSequence)scoreGrade.getScoreLowerLimit())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jzEtzWXWzWIWxOLV_97dd5a9e", (String)"\u5f97\u5206\u7b49\u7ea7\u5206\u6570\u4e0a\u9650\u3001\u5206\u6570\u4e0b\u9650\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        scoreGradeList.sort((a, b) -> BigDecimalUtil.compare(a.getScoreLowerLimit(), b.getScoreLowerLimit()));
        for (int i = 0; i < scoreGradeList.size(); ++i) {
            ElsInspectionStandardScoreGrade scoreGrade = scoreGradeList.get(i);
            boolean validBool = BigDecimalUtil.bigThan(scoreGrade.getScoreLowerLimit(), scoreGrade.getScoreLimit());
            AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_MIN_MAX_ILLEGAL, (String[])new String[]{scoreGrade.getScoreGrade()});
            if (i == scoreGradeList.size() - 1) break;
            validBool = !BigDecimalUtil.beEqualTo(scoreGrade.getScoreLimit(), scoreGradeList.get(i + 1).getScoreLowerLimit());
            AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_COVER_ILLEGAL);
        }
        boolean validBool = !BigDecimalUtil.beEqualTo(scoreGradeList.get(0).getScoreLowerLimit(), "0");
        AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_MIN_GRADE_ILLEGAL);
        validBool = !BigDecimalUtil.beEqualTo(scoreGradeList.get(scoreGradeList.size() - 1).getScoreLimit(), standardFullMarks);
        AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_MAX_GRADE_ILLEGAL);
    }

    private void submitItemDetail(String headId, String itemId, List<ElsInspectionStandardItemDetail> itemDetailList) {
        if (CollectionUtils.isEmpty(itemDetailList)) {
            return;
        }
        Map<String, Long> mapGroup = itemDetailList.stream().collect(Collectors.groupingBy(ElsInspectionStandardItemDetail::getOptionType, Collectors.counting()));
        for (Map.Entry<String, Long> map : mapGroup.entrySet()) {
            AssertI18nUtil.isTrue((map.getValue() > 1L ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.ITEM_DETAIL_OPTION_TYPE_REPEAT, (String[])new String[]{map.getKey()});
        }
        itemDetailList.forEach(itemDetail -> {
            itemDetail.setHeadId(headId).setItemId(itemId);
            this.setBaseEntity((BaseEntity)itemDetail);
        });
        this.itemDetailService.saveBatch(itemDetailList, 2000);
    }

    private void submitItem(String headId, List<ElsInspectionStandardItem> itemList) {
        itemList.forEach(item -> {
            item.setHeadId(headId);
            this.setBaseEntity((BaseEntity)item);
            if (!"2".equals(item.getScoringType())) {
                this.submitItemDetail(headId, item.getId(), item.getItemDetailList());
            }
        });
        this.itemService.saveBatch(itemList, 2000);
    }

    private void submitItemWeight(String headId, List<ElsInspectionStandardItemWeight> itemWeightList) {
        itemWeightList.forEach(itemWeight -> {
            itemWeight.setHeadId(headId);
            this.setBaseEntity((BaseEntity)itemWeight);
        });
        this.itemWeightService.saveBatch(itemWeightList, 2000);
    }

    private String getSubmitQualifiedPoints(List<ElsInspectionStandardScoreGrade> scoreGradeVoList) {
        scoreGradeVoList.sort((a, b) -> BigDecimalUtil.compare(a.getScoreLowerLimit(), b.getScoreLowerLimit()));
        for (ElsInspectionStandardScoreGrade grade : scoreGradeVoList) {
            if (!"0".equals(grade.getInspectionConclusion())) continue;
            return grade.getScoreLowerLimit();
        }
        return null;
    }

    private void submitScoreGrade(String headId, List<ElsInspectionStandardScoreGrade> scoreGradeList) {
        scoreGradeList.forEach(scoreGrade -> {
            this.setBaseEntity((BaseEntity)scoreGrade);
            scoreGrade.setHeadId(headId);
        });
        this.scoreGradeService.saveBatch(scoreGradeList, 2000);
    }

    private void copyItem(String oldHeadId, String newHeadId) {
        List<ElsInspectionStandardItem> itemList = this.itemMapper.selectByMainId(oldHeadId);
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.forEach(item -> {
            List<ElsInspectionStandardItemDetail> detailList = this.itemDetailMapper.selectByItemId(item.getId());
            item.setHeadId(newHeadId).setId(IdWorker.getIdStr());
            if (!CollectionUtils.isEmpty(detailList)) {
                detailList.forEach(detail -> detail.setHeadId(newHeadId).setItemId(item.getId()).setId(IdWorker.getIdStr()));
                this.itemDetailService.saveBatch(detailList, 2000);
            }
        });
        this.itemService.saveBatch(itemList, 2000);
    }

    private void copyItemWeight(String oldHeadId, String newHeadId) {
        List<ElsInspectionStandardItemWeight> weightList = this.itemWeightMapper.selectByMainId(oldHeadId);
        if (CollectionUtils.isEmpty(weightList)) {
            return;
        }
        weightList.forEach(itemWeight -> itemWeight.setHeadId(newHeadId).setId(IdWorker.getIdStr()));
        this.itemWeightService.saveBatch(weightList, 2000);
    }

    private void copyScoreGrade(String oldHeadId, String newHeadId) {
        List<ElsInspectionStandardScoreGrade> list = this.scoreGradeMapper.selectByMainId(oldHeadId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(scoreGrade -> scoreGrade.setHeadId(newHeadId).setId(IdWorker.getIdStr()));
        this.scoreGradeService.saveBatch(list, 2000);
    }

    private String getAudiStatus(String pubishAudit) {
        return "1".equals(pubishAudit) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
    }

    private String getStatus(String pubishAudit) {
        return "1".equals(pubishAudit) ? "0" : "1";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ElsInspectionStandardHeadSaveVO createNewRecord(ElsInspectionStandardHeadSaveVO headSaveVo) {
        boolean bool = StringUtils.isNotBlank((CharSequence)headSaveVo.getInspectionStandardName()) && StringUtils.isNotBlank((CharSequence)headSaveVo.getVersionNumber()) && ((ElsInspectionStandardHeadMapper)this.baseMapper).onlyRecord(null, headSaveVo.getInspectionStandardName(), headSaveVo.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        this.validStandardNumber(headSaveVo);
        ElsInspectionStandardHead elsInspectionStandardHead = new ElsInspectionStandardHead();
        BeanUtils.copyProperties((Object)((Object)headSaveVo), (Object)((Object)elsInspectionStandardHead));
        elsInspectionStandardHead.setInspectionStandardNumber(this.getSerialNumber((Object)headSaveVo)).setStatus("0").setTotalScore(this.sumSaveTotalScore(headSaveVo.getItemList())).setQualifiedPoints(this.getSaveQualifiedPoints(headSaveVo.getScoreGradeList())).setResultAuditStatus(this.getAudiStatus(elsInspectionStandardHead.getPubishAudit())).setDataVersion(0).setId(IdWorker.getIdStr());
        ((ElsInspectionStandardHeadMapper)this.baseMapper).insert((Object)elsInspectionStandardHead);
        headSaveVo.setId(elsInspectionStandardHead.getId());
        this.saveItem(elsInspectionStandardHead.getId(), headSaveVo.getItemList());
        this.saveItemWeight(elsInspectionStandardHead.getId(), headSaveVo.getItemWeightList());
        this.saveScoreGrade(elsInspectionStandardHead.getId(), headSaveVo.getScoreGradeList());
        return headSaveVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRecord(ElsInspectionStandardHeadSaveVO headSaveVo) {
        boolean bool = StringUtils.isNotBlank((CharSequence)headSaveVo.getInspectionStandardName()) && StringUtils.isNotBlank((CharSequence)headSaveVo.getVersionNumber()) && ((ElsInspectionStandardHeadMapper)this.baseMapper).onlyRecord(headSaveVo.getId(), headSaveVo.getInspectionStandardName(), headSaveVo.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        this.validStandardNumber(headSaveVo);
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)((ElsInspectionStandardHeadMapper)this.baseMapper).selectById((Serializable)((Object)headSaveVo.getId())));
        if (head == null) {
            return;
        }
        AssertI18nUtil.isTrue((!"0".equals(head.getStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_NEW);
        AssertI18nUtil.isTrue((StringUtils.isNotBlank((CharSequence)head.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_NEW.getValue().equals(head.getResultAuditStatus()) && !AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(head.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(head.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_AUDI);
        this.delByHeadId(headSaveVo.getId());
        this.saveItem(headSaveVo.getId(), headSaveVo.getItemList());
        this.saveItemWeight(headSaveVo.getId(), headSaveVo.getItemWeightList());
        this.saveScoreGrade(headSaveVo.getId(), headSaveVo.getScoreGradeList());
        ElsInspectionStandardHead elsInspectionStandardHead = new ElsInspectionStandardHead();
        BeanUtils.copyProperties((Object)((Object)headSaveVo), (Object)((Object)elsInspectionStandardHead));
        elsInspectionStandardHead.setResultAuditStatus(this.getAudiStatus(elsInspectionStandardHead.getPubishAudit())).setTotalScore(this.sumSaveTotalScore(headSaveVo.getItemList())).setQualifiedPoints(this.getSaveQualifiedPoints(headSaveVo.getScoreGradeList()));
        int count = ((ElsInspectionStandardHeadMapper)this.baseMapper).updateById((Object)elsInspectionStandardHead);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordNoId(ElsInspectionStandardHeadSubmitVO headSubmitVO) {
        boolean bool = ((ElsInspectionStandardHeadMapper)this.baseMapper).onlyRecord(null, headSubmitVO.getInspectionStandardName(), headSubmitVO.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)headSubmitVO.getInspectionStandardName()), (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_NAME_NOT_NULL);
        this.requiredValid(headSubmitVO);
        this.validStandardNumber(headSubmitVO);
        this.validItemWeight(headSubmitVO.getItemWeightList());
        this.validScoreGrade(headSubmitVO.getStandardFullMarks(), headSubmitVO.getScoreGradeList());
        headSubmitVO.setInspectionStandardNumber(this.getSerialNumber((Object)headSubmitVO)).setTotalScore(this.sumSubmitTotalScore(headSubmitVO.getItemList())).setQualifiedPoints(this.getSubmitQualifiedPoints(headSubmitVO.getScoreGradeList())).setStatus(this.getStatus(headSubmitVO.getPubishAudit())).setResultAuditStatus(this.getAudiStatus(headSubmitVO.getPubishAudit())).setDataVersion(0).setId(IdWorker.getIdStr());
        ((ElsInspectionStandardHeadMapper)this.baseMapper).insert((Object)headSubmitVO);
        this.delByHeadId(headSubmitVO.getId());
        this.submitItem(headSubmitVO.getId(), headSubmitVO.getItemList());
        this.submitItemWeight(headSubmitVO.getId(), headSubmitVO.getItemWeightList());
        this.submitScoreGrade(headSubmitVO.getId(), headSubmitVO.getScoreGradeList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordWithId(ElsInspectionStandardHeadSubmitVO headSubmitVO) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)headSubmitVO.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        boolean bool = ((ElsInspectionStandardHeadMapper)this.baseMapper).onlyRecord(headSubmitVO.getId(), headSubmitVO.getInspectionStandardName(), headSubmitVO.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)headSubmitVO.getInspectionStandardName()), (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_NAME_NOT_NULL);
        this.requiredValid(headSubmitVO);
        this.validStandardNumber(headSubmitVO);
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)((ElsInspectionStandardHeadMapper)this.baseMapper).selectById((Serializable)((Object)headSubmitVO.getId())));
        if (head == null) {
            return;
        }
        AssertI18nUtil.isTrue((!"0".equals(head.getStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_NEW);
        AssertI18nUtil.isTrue((StringUtils.isNotBlank((CharSequence)head.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_NEW.getValue().equals(head.getResultAuditStatus()) && !AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(head.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(head.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_AUDI);
        this.validItemWeight(headSubmitVO.getItemWeightList());
        this.validScoreGrade(headSubmitVO.getStandardFullMarks(), headSubmitVO.getScoreGradeList());
        this.delByHeadId(headSubmitVO.getId());
        this.submitItem(headSubmitVO.getId(), headSubmitVO.getItemList());
        this.submitItemWeight(headSubmitVO.getId(), headSubmitVO.getItemWeightList());
        this.submitScoreGrade(headSubmitVO.getId(), headSubmitVO.getScoreGradeList());
        headSubmitVO.setTotalScore(this.sumSubmitTotalScore(headSubmitVO.getItemList())).setQualifiedPoints(this.getSubmitQualifiedPoints(headSubmitVO.getScoreGradeList())).setStatus(this.getStatus(headSubmitVO.getPubishAudit())).setResultAuditStatus(this.getAudiStatus(headSubmitVO.getPubishAudit()));
        int count = ((ElsInspectionStandardHeadMapper)this.baseMapper).updateById((Object)headSubmitVO);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        int recordNum = ((ElsInspectionStandardHeadMapper)this.baseMapper).countByIdAndStatus(id, "0");
        AssertI18nUtil.isTrue((recordNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_NEW);
        ((ElsInspectionStandardHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.delByHeadId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(String id) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)((ElsInspectionStandardHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        boolean bool = head == null || !"2".equals(head.getStatus());
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_DISABLE);
        if (head == null) {
            return;
        }
        head.setStatus("1");
        int count = ((ElsInspectionStandardHeadMapper)this.baseMapper).updateById((Object)head);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(String id) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)((ElsInspectionStandardHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        boolean bool = head == null || !"1".equals(head.getStatus());
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_ENABLE);
        if (head == null) {
            return;
        }
        head.setStatus("2");
        int count = ((ElsInspectionStandardHeadMapper)this.baseMapper).updateById((Object)head);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyInspectionStandard(String id) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)((ElsInspectionStandardHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        String serialNumber = this.baseRpcService.getNextCode("inspectionStandardNumber", (Object)head);
        head.setStatus("0").setInspectionStandardNumber(serialNumber).setResultAuditStatus(null).setResultFlowId(null).setDataVersion(0).setCreateById(SysUtil.getLoginUser().getId()).setUpdateById(SysUtil.getLoginUser().getId()).setId(IdWorker.getIdStr());
        ((ElsInspectionStandardHeadMapper)this.baseMapper).insert((Object)head);
        this.copyItem(id, head.getId());
        this.copyItemWeight(id, head.getId());
        this.copyScoreGrade(id, head.getId());
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ElsInspectionStandardHeadSubmitVO getById(String id) {
        ElsInspectionStandardHeadSubmitVO submitVO = new ElsInspectionStandardHeadSubmitVO();
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)((ElsInspectionStandardHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)submitVO));
        List<ElsInspectionStandardItem> itemList = this.itemMapper.selectByMainId(id);
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectByItemId(item.getId())));
        }
        submitVO.setItemList(itemList);
        submitVO.setItemWeightList(this.itemWeightMapper.selectByMainId(id));
        submitVO.setScoreGradeList(this.scoreGradeMapper.selectByMainId(id));
        return submitVO;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<ElsInspectionStandardItemDetail> selectWithoutElsAccountByItemId(String itemId) {
        return this.itemDetailMapper.selectWithoutElsAccountByItemId(itemId);
    }

    private void validStandardNumber(ElsInspectionStandardHead standardHead) {
        if (Objects.isNull(standardHead.getStandardFullMarks()) || Objects.isNull(standardHead.getQualifiedPoints())) {
            return;
        }
        String standDardFullMarks = standardHead.getStandardFullMarks().contains(".") ? standardHead.getStandardFullMarks().split(".")[0] : standardHead.getStandardFullMarks();
        String quanlifiedPoints = standardHead.getQualifiedPoints().contains(".") ? standardHead.getQualifiedPoints().split(".")[0] : standardHead.getQualifiedPoints();
        Integer MAX_SIZE = 12;
        AssertI18nUtil.isTrue((standDardFullMarks.length() > MAX_SIZE ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STANDARD_FULL_MARKS_MAX_LIMIT, (String[])new String[]{MAX_SIZE - 1 + ""});
        AssertI18nUtil.isTrue((quanlifiedPoints.length() > MAX_SIZE ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STANDARD_FULL_MARKS_MAX_LIMIT, (String[])new String[]{MAX_SIZE - 1 + ""});
    }

    private void requiredValid(ElsInspectionStandardHead standardHead) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)standardHead.getStandardFullMarks()), (Enum)I18nSiteInspectEnum.STANDARD_FULL_MARKS_NOT_NULL);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)standardHead.getQualifiedPoints()), (Enum)I18nSiteInspectEnum.QUALIFIED_POINTS_NOT_NULL);
        AssertI18nUtil.isTrue((!standardHead.getStandardFullMarks().matches("^[+]?\\d+(\\.\\d+)?$") ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STANDARD_FULL_MARKS_ILLEGAL);
        AssertI18nUtil.isTrue((!standardHead.getQualifiedPoints().matches("^[+]?\\d+(\\.\\d+)?$") ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.QUALIFIED_POINTS_ILLEGAL);
    }
}

