/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.calendar.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.calendar.entity.PurchaseFactoryCalendarHead;
import com.els.modules.calendar.entity.PurchaseFactoryCalendarItem;
import com.els.modules.calendar.mapper.PurchaseFactoryCalendarHeadMapper;
import com.els.modules.calendar.mapper.PurchaseFactoryCalendarItemMapper;
import com.els.modules.calendar.service.PurchaseFactoryCalendarHeadService;
import com.els.modules.calendar.service.PurchaseFactoryCalendarItemService;
import com.els.modules.calendar.vo.PurchaseFactoryCalendarHeadVO;
import com.els.modules.calendar.vo.PurchaseFactorySettingCalendarVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseFactoryCalendarHeadServiceImpl
extends ServiceImpl<PurchaseFactoryCalendarHeadMapper, PurchaseFactoryCalendarHead>
implements PurchaseFactoryCalendarHeadService {
    @Resource
    private PurchaseFactoryCalendarHeadMapper purchaseFactoryCalendarHeadMapper;
    @Resource
    private PurchaseFactoryCalendarItemMapper purchaseFactoryCalendarItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseFactoryCalendarHead purchaseFactoryCalendarHead, List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList) {
        this.purchaseFactoryCalendarHeadMapper.insert((Object)purchaseFactoryCalendarHead);
        this.insertData(purchaseFactoryCalendarHead, purchaseFactoryCalendarItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseFactoryCalendarHead purchaseFactoryCalendarHead, List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList) {
        this.purchaseFactoryCalendarHeadMapper.updateById((Object)purchaseFactoryCalendarHead);
        this.purchaseFactoryCalendarItemMapper.deleteByMainId(purchaseFactoryCalendarHead.getId());
        this.insertData(purchaseFactoryCalendarHead, purchaseFactoryCalendarItemList);
    }

    private void insertData(PurchaseFactoryCalendarHead purchaseFactoryCalendarHead, List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList) {
        if (CollectionUtils.isNotEmpty(purchaseFactoryCalendarItemList)) {
            for (PurchaseFactoryCalendarItem entity : purchaseFactoryCalendarItemList) {
                entity.setHeadId(purchaseFactoryCalendarHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseFactoryCalendarHead);
            }
            this.purchaseFactoryCalendarItemMapper.insertBatchSomeColumn(purchaseFactoryCalendarItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseFactoryCalendarItemMapper.deleteByMainId(id);
        this.purchaseFactoryCalendarHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseFactoryCalendarItemMapper.deleteByMainId(serializable.toString());
            this.purchaseFactoryCalendarHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<PurchaseFactoryCalendarHeadVO> getCalendar(String elsAccount, String factory) {
        List<PurchaseFactoryCalendarHeadVO> list = this.purchaseFactoryCalendarHeadMapper.selectCalendarList(elsAccount, factory);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (PurchaseFactoryCalendarHeadVO vo : list) {
            List<PurchaseFactoryCalendarItem> itemList = vo.getPurchaseFactoryCalendarItemList();
            List<String> dayOffList = itemList.stream().map(item -> sdf.format(item.getDayOff())).collect(Collectors.toList());
            vo.setDayOffList(dayOffList);
        }
        return list;
    }

    @Override
    public String loadHeadId(String elsAccount, String factory) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseFactoryCalendarHead::getFactory, (Object)factory)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).last(" limit 1");
        PurchaseFactoryCalendarHead purchaseFactoryCalendarHead = (PurchaseFactoryCalendarHead)((Object)((PurchaseFactoryCalendarHeadMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == purchaseFactoryCalendarHead) {
            return null;
        }
        return purchaseFactoryCalendarHead.getId();
    }

    @Override
    public void settingCalendar(PurchaseFactorySettingCalendarVO vo) {
        List<PurchaseFactoryCalendarItem> items = this.purchaseFactoryCalendarItemMapper.selectByMainId(vo.getHeadId());
        if ("1".equals(vo.getType())) {
            List existList = items.stream().filter(x -> vo.getDayOffList().contains(DateUtils.formatDate((Date)x.getDayOff()))).map(x -> DateUtils.formatDate((Date)x.getDayOff())).collect(Collectors.toList());
            List<String> dayOffList = vo.getDayOffList();
            dayOffList.removeAll(existList);
            if (dayOffList.isEmpty()) {
                return;
            }
            ArrayList<PurchaseFactoryCalendarItem> itemList = new ArrayList<PurchaseFactoryCalendarItem>();
            for (String dayOff : dayOffList) {
                PurchaseFactoryCalendarItem item = new PurchaseFactoryCalendarItem();
                item.setElsAccount(SysUtil.getLoginUser().getElsAccount());
                item.setHeadId(vo.getHeadId());
                item.setDayOff((Date)DateUtil.parse((CharSequence)dayOff, (String)"yyyy-MM-dd"));
                itemList.add(item);
            }
            ((PurchaseFactoryCalendarItemService)SpringContextUtils.getBean(PurchaseFactoryCalendarItemService.class)).saveBatch(itemList);
        } else {
            List existList = items.stream().filter(x -> vo.getDayOffList().contains(DateUtils.formatDate((Date)x.getDayOff()))).collect(Collectors.toList());
            if (!existList.isEmpty()) {
                this.purchaseFactoryCalendarItemMapper.deleteByIds(existList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
        }
    }
}

