/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.siteInspection.entity.ElsInspectionPlanHead;
import com.els.modules.siteInspection.entity.ElsInspectionPlanItem;
import com.els.modules.siteInspection.service.ElsInspectionPlanHeadService;
import com.els.modules.siteInspection.service.ElsInspectionPlanItemService;
import com.els.modules.siteInspection.vo.ElsInspectionPlanHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/other/elsInspectionPlanHead"})
@Api(tags={"\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f"})
public class ElsInspectionPlanHeadController
extends BaseController<ElsInspectionPlanHead, ElsInspectionPlanHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsInspectionPlanHeadController.class);
    @Autowired
    private ElsInspectionPlanHeadService elsInspectionPlanHeadService;
    @Autowired
    private ElsInspectionPlanItemService elsInspectionPlanItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:list"})
    public Result<?> queryPageList(ElsInspectionPlanHead elsInspectionPlanHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsInspectionPlanHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsInspectionPlanHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:add"})
    public Result<?> add(@RequestBody ElsInspectionPlanHeadVO elsInspectionPlanHeadPage) {
        ElsInspectionPlanHead elsInspectionPlanHead = new ElsInspectionPlanHead();
        BeanUtils.copyProperties((Object)((Object)elsInspectionPlanHeadPage), (Object)((Object)elsInspectionPlanHead));
        this.elsInspectionPlanHeadService.saveMain(elsInspectionPlanHead, elsInspectionPlanHeadPage.getInspectionPlanItemList(), elsInspectionPlanHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)elsInspectionPlanHead));
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:edit"})
    public Result<?> edit(@RequestBody ElsInspectionPlanHeadVO elsInspectionPlanHeadPage) {
        ElsInspectionPlanHead elsInspectionPlanHead = new ElsInspectionPlanHead();
        BeanUtils.copyProperties((Object)((Object)elsInspectionPlanHeadPage), (Object)((Object)elsInspectionPlanHead));
        this.elsInspectionPlanHeadService.updateMain(elsInspectionPlanHead, elsInspectionPlanHeadPage.getInspectionPlanItemList(), elsInspectionPlanHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsInspectionPlanHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.elsInspectionPlanHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.queryDataById(id)));
    }

    @ApiOperation(value="\u901a\u8fc7\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606fid\u67e5\u8be2\u8003\u5bdf\u8ba1\u5212\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606fid\u67e5\u8be2\u8003\u5bdf\u8ba1\u5212\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryElsInspectionPlanItemByMainId"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:queryElsInspectionPlanItemByMainId"})
    public Result<?> queryElsInspectionPlanItemListByMainId(@RequestParam(name="id") String id) {
        List<ElsInspectionPlanItem> elsInspectionPlanItemList = this.elsInspectionPlanItemService.selectByMainId(id);
        return Result.ok(elsInspectionPlanItemList);
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:submit"})
    public Result<?> submit(@RequestBody ElsInspectionPlanHeadVO headVO) {
        this.elsInspectionPlanHeadService.submit(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copy"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:copy"})
    public Result<?> copy(@RequestBody ElsInspectionPlanHead head) {
        ElsInspectionPlanHeadVO elsInspectionPlanHeadVO = this.queryDataById(head.getId());
        this.elsInspectionPlanHeadService.copy(elsInspectionPlanHeadVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:cancel"})
    public Result<?> cancel(@RequestBody ElsInspectionPlanHeadVO head) {
        head.setStatus("4");
        this.elsInspectionPlanHeadService.updateStatus(head);
        return this.commonSuccessResult(3);
    }

    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:list"})
    public Result<?> queryTabsCount(ElsInspectionPlanHead head) {
        return Result.ok(this.elsInspectionPlanHeadService.counts(head));
    }

    @AutoLog(busModule="\u8003\u5bdf\u8ba1\u5212\u5934\u4fe1\u606f", value="\u751f\u6210\u73b0\u573a\u8003\u5bdf\u5355")
    @ApiOperation(value="\u751f\u6210\u73b0\u573a\u8003\u5bdf\u5355", notes="\u751f\u6210\u73b0\u573a\u8003\u5bdf\u5355")
    @PostMapping(value={"/generate"})
    @RequiresPermissions(value={"inspectionPlan#elsInspectionPlanHead:generate"})
    public Result<?> generate(@RequestBody ElsInspectionPlanHead head) {
        return this.elsInspectionPlanHeadService.generateInspection(head);
    }

    private ElsInspectionPlanHeadVO queryDataById(String id) {
        ElsInspectionPlanHead elsInspectionPlanHead = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)id)));
        ElsInspectionPlanHeadVO elsInspectionPlanHeadVO = new ElsInspectionPlanHeadVO();
        BeanUtils.copyProperties((Object)((Object)elsInspectionPlanHead), (Object)((Object)elsInspectionPlanHeadVO));
        List<ElsInspectionPlanItem> elsInspectionPlanItemList = this.elsInspectionPlanItemService.selectByMainId(id);
        elsInspectionPlanHeadVO.setInspectionPlanItemList(elsInspectionPlanItemList);
        List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        elsInspectionPlanHeadVO.setPurchaseAttachmentList(purchaseAttachmentDTOList);
        return elsInspectionPlanHeadVO;
    }
}

