/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.spcn.entity.PurchaseSpcn;
import com.els.modules.spcn.entity.SpcnOrderDetail;
import com.els.modules.spcn.service.PurchaseSpcnService;
import com.els.modules.spcn.service.SpcnOrderDetailService;
import com.els.modules.spcn.vo.PurchaseSpcnVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SPCN"})
@RestController
@RequestMapping(value={"/spcn/purchaseSpcn"})
public class PurchaseSpcnController
extends BaseController<PurchaseSpcn, PurchaseSpcnService> {
    @Autowired
    private PurchaseSpcnService purchaseSpcnService;
    @Autowired
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Autowired
    private SpcnOrderDetailService spcnOrderDetailService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:list"})
    public Result<?> queryPageList(PurchaseSpcn purchaseSpcn, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSpcn), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSpcnService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:add"})
    public Result<?> add(@RequestBody PurchaseSpcn purchaseSpcn) {
        this.purchaseSpcnService.savePurchaseSpcn(purchaseSpcn);
        return Result.ok((Object)((Object)purchaseSpcn));
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:edit"})
    public Result<?> edit(@RequestBody PurchaseSpcn purchaseSpcn) {
        this.purchaseSpcnService.updatePurchaseSpcn(purchaseSpcn);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="SPCN-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseSpcnService.delPurchaseSpcn(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="SPCN-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseSpcnService.delBatchPurchaseSpcn(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseSpcn purchaseSpcn = (PurchaseSpcn)((Object)this.purchaseSpcnService.getById((Serializable)((Object)id)));
        PurchaseSpcnVO spcnVO = new PurchaseSpcnVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSpcn), (Object)((Object)spcnVO));
        List<SpcnOrderDetail> orderDetailList = this.spcnOrderDetailService.queryByMainId(id);
        spcnVO.setOrderDetailList(orderDetailList);
        List<PurchaseAttachmentDTO> attachments = this.ecnInvokeBaseRpcService.purcahseSelectByMainId(id);
        spcnVO.setAttachments(attachments);
        return Result.ok((Object)((Object)spcnVO));
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u786e\u8ba4")
    @ApiOperation(value="\u786e\u8ba4", notes="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:confirm"})
    public Result<?> confirm(@RequestBody PurchaseSpcnVO spcnVO) {
        PurchaseSpcn spcn = new PurchaseSpcn();
        BeanUtils.copyProperties((Object)((Object)spcnVO), (Object)((Object)spcn));
        this.purchaseSpcnService.confirmOperation(spcn, spcnVO.getAttachments());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u62d2\u7edd")
    @ApiOperation(value="\u62d2\u7edd", notes="\u62d2\u7edd")
    @PostMapping(value={"/refused"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:refused"})
    public Result<?> refused(@RequestBody PurchaseSpcnVO spcnVO) {
        PurchaseSpcn spcn = new PurchaseSpcn();
        BeanUtils.copyProperties((Object)((Object)spcnVO), (Object)((Object)spcn));
        this.purchaseSpcnService.confirmOperation(spcn, spcnVO.getAttachments());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseSpcnService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseSpcnService.pushDataToErp(ids);
        return Result.ok();
    }
}

