/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.eightReport.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.service.ElsEmailConfigRpcService;
import com.els.modules.eightReport.entity.SaleEightDisciplinesSeven;
import com.els.modules.eightReport.entity.SaleEightDisciplinesTeam;
import com.els.modules.eightReport.mapper.SaleEightDisciplinesSevenMapper;
import com.els.modules.eightReport.service.SaleEightDisciplinesSevenService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEightDisciplinesSevenServiceImpl
extends BaseServiceImpl<SaleEightDisciplinesSevenMapper, SaleEightDisciplinesSeven>
implements SaleEightDisciplinesSevenService {
    @Autowired
    private SaleEightDisciplinesSevenMapper saleEightDisciplinesSevenMapper;
    @Autowired
    private ElsEmailConfigRpcService elsEmailConfigRpcService;

    @Override
    public List<SaleEightDisciplinesSeven> selectByMainId(String mainId) {
        return this.saleEightDisciplinesSevenMapper.selectByMainId(mainId);
    }

    @Override
    public Boolean deleteByMainId(String id) {
        return this.saleEightDisciplinesSevenMapper.deleteByMainId(id);
    }

    @Override
    public Integer insert(SaleEightDisciplinesSeven saleEightDisciplinesSeven) {
        return this.saleEightDisciplinesSevenMapper.insert((Object)saleEightDisciplinesSeven);
    }

    @Override
    public void sendEmailMessage(SaleEightDisciplinesTeam team) {
        if (null == team) {
            return;
        }
        try {
            if (StrUtil.isEmpty((CharSequence)team.getSubAccount())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tF[0]jypUuLjxOLV_e0ff5363", (String)"\u5355\u636e[${0}]\u7684\u7ed3\u6848\u8bc4\u4ef7\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{team.getEightDisciplinesNumber()}));
            }
            ElsEmailConfigDTO emailConfig = this.elsEmailConfigRpcService.getEmailConfig(SysUtil.getPurchaseAccount());
            if (ObjectUtil.isEmpty((Object)emailConfig)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jIERLV_7f6daf09", (String)"\u90ae\u4ef6\u914d\u7f6e\u4e3a\u7a7a"));
            }
            ElsEmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)emailConfig, (String)team.getMail(), (String)("\u3010" + team.getEightDisciplinesNumber() + "\u3011\u4f9b\u5e94\u55468D\u6539\u8fdb\u62a5\u544a\u63d0\u4ea4\u6210\u529f"), (String)"\u4f9b\u5e94\u55468D\u6539\u8fdb\u62a5\u544a\u5df2\u63d0\u4ea4, \u53ef\u4ee5\u8fdb\u884c\u7ed3\u6848\u8bc4\u4ef7", null, (boolean)false);
        }
        catch (Exception e) {
            this.log.error("\u53d1\u9001\u90ae\u4ef6\u51fa\u9519, \u5355\u636e\u53f7: " + team.getEightDisciplinesNumber(), (Throwable)e);
        }
    }
}

