/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMouldDataAuditServiceImpl")
public class PurchaseMouldDataAuditServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        PurchaseMouldData head = (PurchaseMouldData)((Object)this.purchaseMouldDataService.getById((Serializable)((Object)auditInputParamDTO.getBusinessId())));
        head.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        head.setAuditStatus(auditOutputParamDTO.getAuditStatus());
        head.setFlowId(auditOutputParamDTO.getProcessRootId());
        head.setSubmitStatus("1");
        this.purchaseMouldDataService.updateById((Object)head);
        for (String account : auditOutputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        PurchaseMouldData head = new PurchaseMouldData();
        head.setId(auditInputParamDTO.getBusinessId());
        head.setAuditStatus(auditOutputParamDTO.getAuditStatus());
        head.setFlowId(auditOutputParamDTO.getProcessRootId());
        this.purchaseMouldDataService.updateById((Object)head);
        PurchaseMouldData dbHead = (PurchaseMouldData)((Object)this.purchaseMouldDataService.getById((Serializable)((Object)auditInputParamDTO.getBusinessId())));
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditOutputParamDTO.getAuditStatus())) {
            this.purchaseMouldDataService.publish(dbHead);
            MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, auditOutputParamDTO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : auditOutputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(auditOutputParamDTO.getBpmnType())) {
                    operataion = auditOutputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        this.updateHead(auditInputParamDTO, auditOutputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(auditInputParamDTO, auditOutputParamDTO, auditOutputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)auditInputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        this.updateHead(auditInputParamDTO, auditOutputParamDTO);
    }

    public JSONObject getDataById(String id) {
        PurchaseMouldData head = (PurchaseMouldData)((Object)this.purchaseMouldDataService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void updateHead(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseMouldData head = new PurchaseMouldData();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseMouldDataService.updateById((Object)head);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PurchaseMouldData head = (PurchaseMouldData)((Object)this.purchaseMouldDataService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

