/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.excel;

import cn.hutool.core.collection.CollUtil;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMouldDataExcelHandler")
public class PurchaseMouldDataExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("mouldData");
        ArrayList<PurchaseMouldData> entityList = new ArrayList<PurchaseMouldData>();
        for (Map data : dataList) {
            PurchaseMouldData entity2 = (PurchaseMouldData)((Object)this.transferEntity(data, PurchaseMouldData.class, excelImportDTO));
            if (null == entity2) continue;
            entity2.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity2.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity2.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity2.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity2.setElsAccount(TenantContext.getTenant());
            entityList.add(entity2);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        entityList.forEach(entity -> {
            this.purchaseMouldDataService.save(entity);
            this.purchaseMouldDataService.publish((PurchaseMouldData)((Object)entity));
        });
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

