/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.api.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.common.vo.SapCommonHeadVO;
import com.els.modules.quality.entity.PurchaseIqcApproval;
import com.els.modules.quality.vo.PurchaseIqcApprovalSapVO;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushIqcAuditToSapServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(PushIqcAuditToSapServiceImpl.class);
    private static final String PUSH_IQC_AUDIT_TO_SAP = "pushIqcAuditToSap";

    public JSONObject before(JSONObject jsonObject, Object paramCustom) {
        log.info("\u63a8\u9001IQC\u68c0\u9a8c\u5ba1\u6279\u7ed3\u679c\u5230SAP\u5165\u53c2; request : {}", (Object)JSONObject.toJSONString((Object)paramCustom));
        SapCommonHeadVO sapCommonHeadVO = new SapCommonHeadVO();
        sapCommonHeadVO.setSource("SRM");
        sapCommonHeadVO.setDestination("SAP");
        Date nowDate = new Date();
        sapCommonHeadVO.setZdate(new SimpleDateFormat("yyyy-MM-dd").format(nowDate));
        sapCommonHeadVO.setZtime(new SimpleDateFormat("HH:mm:ss").format(nowDate));
        JSONObject info = JSONObject.parseObject((String)JSONObject.toJSONString((Object)sapCommonHeadVO));
        PurchaseIqcApproval purchaseIqcApproval = (PurchaseIqcApproval)((Object)new ObjectMapper().convertValue(paramCustom, PurchaseIqcApproval.class));
        PurchaseIqcApprovalSapVO approvalSapVO = this.packageSapData(purchaseIqcApproval);
        JSONObject input = this.entityToJsonobject(approvalSapVO, new PurchaseIqcApprovalSapVO());
        JSONObject iInfo = new JSONObject();
        iInfo.put("structureName", (Object)"I_INFO");
        JSONArray structFields0 = new JSONArray();
        structFields0.add((Object)info);
        iInfo.put("structFields0", (Object)structFields0);
        JSONObject itInput = new JSONObject();
        itInput.put("tableName", (Object)"IT_INPUT");
        JSONArray tableFields1 = new JSONArray();
        tableFields1.add((Object)input);
        itInput.put("tableFields1", (Object)tableFields1);
        JSONObject body = new JSONObject();
        body.put("I_INFO", (Object)iInfo);
        body.put("IT_INPUT", (Object)itInput);
        jsonObject.put("body", (Object)body);
        log.info("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0[\u63a8\u9001IQC\u68c0\u9a8c\u5ba1\u6279\u7ed3\u679c\u5230SAP]\u63a5\u53e3\u5f00\u59cb, \u5165\u53c2-->; body : {}", (Object)jsonObject.toJSONString());
        return jsonObject;
    }

    public JSONObject after(JSONObject jsonObject, JSONObject resultObj, Object o) {
        String success = jsonObject.getString("success");
        if ("true".equals(success)) {
            JSONObject returnResult = jsonObject.getJSONObject("result");
            JSONArray array = returnResult.getJSONArray("ET_OUTPUT");
            if (array != null && array.size() > 0) {
                for (Object obj : array) {
                    JSONObject object = (JSONObject)obj;
                    String type = object.getString("TYPE");
                    if (!StrUtil.isNotBlank((CharSequence)type) || "S".equals(type)) continue;
                    String messageZh = object.getString("MESSAGE_ZH");
                    String messageEn = object.getString("MESSAGE_EN");
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SRMYdIQCIOUzyRuSAPyVKmKmjWLmessageZh[0]messageEn[1]_f2e1de1a", (String)"SRM\u63a8\u9001IQC\u68c0\u9a8c\u5ba1\u6279\u7ed3\u679c\u5230SAP\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1amessageZh[${0}]\uff0cmessageEn[${1}]", (String[])new String[]{messageZh, messageEn}));
                }
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_DjyVUEIHsNdVL_c55af0a9", (String)"\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5f02\u5e38\uff0c\u62a5\u9519\u8be6\u60c5\u4e3a\uff1a") + jsonObject.getString("message"));
        }
        log.info("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0[\u63a8\u9001IQC\u68c0\u9a8c\u5ba1\u6279\u7ed3\u679c\u5230SAP]\u63a5\u53e3\u7ed3\u675f, \u8fd4\u56de-->; result : {}", (Object)resultObj.toJSONString());
        return resultObj;
    }

    private PurchaseIqcApprovalSapVO packageSapData(PurchaseIqcApproval purchaseIqcApproval) {
        PurchaseIqcApprovalSapVO approvalSapVO = new PurchaseIqcApprovalSapVO();
        approvalSapVO.setPrueflos(purchaseIqcApproval.getPrueflos());
        approvalSapVO.setSelmatnr(purchaseIqcApproval.getSelmatnr());
        approvalSapVO.setWerk(purchaseIqcApproval.getWerk());
        approvalSapVO.setVcodegrp("IQC");
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseIqcApproval.getAuditStatus())) {
            approvalSapVO.setYesNodecision("Y");
            approvalSapVO.setVcode("A1");
            approvalSapVO.setLmenge01(purchaseIqcApproval.getLosmenge());
            approvalSapVO.setQlgoVm01("1001");
            approvalSapVO.setSgtxt01(purchaseIqcApproval.getOpinion());
            approvalSapVO.setVname(purchaseIqcApproval.getVname());
            approvalSapVO.setVdatum(purchaseIqcApproval.getVdatum() != null ? new SimpleDateFormat("yyyy-MM-dd").format(purchaseIqcApproval.getVdatum()) : "");
            approvalSapVO.setVezeiterf(purchaseIqcApproval.getVezeiterf() != null ? new SimpleDateFormat("HH:mm:ss").format(purchaseIqcApproval.getVezeiterf()) : "");
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(purchaseIqcApproval.getAuditStatus())) {
            approvalSapVO.setYesNodecision("N");
            approvalSapVO.setVcode("B1");
            approvalSapVO.setLmenge07(purchaseIqcApproval.getLosmenge());
            approvalSapVO.setSgtxt07(StrUtil.isNotBlank((CharSequence)purchaseIqcApproval.getOpinion()) ? purchaseIqcApproval.getOpinion() : "\u9000\u56de");
            approvalSapVO.setGrund("002");
            approvalSapVO.setVaename(purchaseIqcApproval.getVname());
            Date date = new Date();
            approvalSapVO.setVaedatum(new SimpleDateFormat("yyyy-MM-dd").format(date));
            approvalSapVO.setVezeitaen(new SimpleDateFormat("HH:mm:ss").format(date));
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzzEjSVIm_abe5fc99", (String)"\u5ba1\u6279\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5"));
        }
        approvalSapVO.setLosmenge(purchaseIqcApproval.getLosmenge());
        approvalSapVO.setBktxt(purchaseIqcApproval.getKurztext());
        approvalSapVO.setBldat(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        approvalSapVO.setBudat(purchaseIqcApproval.getVdatum() != null ? new SimpleDateFormat("yyyy-MM-dd").format(purchaseIqcApproval.getVdatum()) : "");
        return approvalSapVO;
    }

    private JSONObject entityToJsonobject(Object target, Object source) {
        JSONObject body = new JSONObject();
        for (Field field : target.getClass().getDeclaredFields()) {
            try {
                boolean flag = field.isAccessible();
                field.setAccessible(true);
                Object obj = field.get(target);
                if (!ObjectUtils.isEmpty((Object)obj)) {
                    Field contField = source.getClass().getDeclaredField(field.getName());
                    JsonProperty voField = contField.getAnnotation(JsonProperty.class);
                    String value = voField.value();
                    body.put(value, (Object)obj.toString());
                }
                field.setAccessible(flag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return body;
    }
}

