/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.api.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.quality.entity.PurchaseIqcDefect;
import com.els.modules.quality.entity.PurchaseIqcOperation;
import com.els.modules.quality.entity.PurchaseIqcResultDetail;
import com.els.modules.quality.entity.PurchaseIqcResultSum;
import com.els.modules.quality.rpc.service.QualityInvokeAccountRpcService;
import com.els.modules.quality.service.PurchaseIqcApprovalService;
import com.els.modules.quality.vo.PurchaseIqcApprovalVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SynSapIqcServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(SynSapIqcServiceImpl.class);
    @Autowired
    private PurchaseIqcApprovalService purchaseIqcApprovalService;
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private QualityInvokeAccountRpcService qualityInvokeAccountRpcService;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public JSONObject invoke(JSONObject jsonObject) {
        log.info("IQC\u68c0\u9a8c\u540c\u6b65\u63a5\u53e3\u5f00\u59cb\uff1a" + DateUtils.formatDateTime());
        if (jsonObject.isEmpty()) {
            log.error("IQC\u68c0\u9a8c\u540c\u6b65\u53c2\u6570\u4e3a\u7a7a;");
            return JSONObject.parseObject((String)JSONObject.toJSONString((Object)Result.error((String)"\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a\uff0c\u540c\u6b65\u5931\u8d25;")));
        }
        JSONObject object = (JSONObject)Convert.convert(JSONObject.class, (Object)jsonObject);
        String vdatum = (String)object.get((Object)"VDATUM");
        String vezeiterf = (String)object.get((Object)"VEZEITERF");
        if (StrUtil.isNotBlank((CharSequence)vdatum) && StrUtil.isNotBlank((CharSequence)vezeiterf)) {
            DateTime vezeiterfDate = DateUtil.parse((CharSequence)(vdatum + " " + vezeiterf));
            object.put("VEZEITERF", (Object)vezeiterfDate);
        }
        String vaedatum = (String)object.get((Object)"VAEDATUM");
        String vezeitaen = (String)object.get((Object)"VEZEITAEN");
        if (StrUtil.isNotBlank((CharSequence)vaedatum) && StrUtil.isNotBlank((CharSequence)vezeitaen)) {
            DateTime vezeitaenDate = DateUtil.parse((CharSequence)(vaedatum + " " + vezeitaen));
            object.put("VEZEITAEN", (Object)vezeitaenDate);
        }
        PurchaseIqcApprovalVO approvalVO = (PurchaseIqcApprovalVO)((Object)JSONObject.parseObject((String)object.toString(), PurchaseIqcApprovalVO.class));
        this.saveIqcApproval(approvalVO);
        log.info("IQC\u68c0\u9a8c\u540c\u6b65\u63a5\u53e3\u7ed3\u675f\uff1a" + DateUtils.formatDateTime());
        return null;
    }

    private void saveIqcApproval(PurchaseIqcApprovalVO approvalVO) {
        this.checkIqcApproval(approvalVO);
        List templateList = this.baseRpcService.getDefaultTemplateByType("iqcApproval");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERnRItESIr_4064e770", (String)"\u8bf7\u5148\u914d\u7f6e\u91c7\u8d2d\u8ba2\u5355\u4e1a\u52a1\u6a21\u677f"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        approvalVO.setTemplateName(templateHeadDTO.getTemplateName());
        approvalVO.setTemplateNumber(templateHeadDTO.getTemplateNumber());
        approvalVO.setTemplateVersion(templateHeadDTO.getTemplateVersion());
        approvalVO.setTemplateAccount(templateHeadDTO.getElsAccount());
        this.purchaseIqcApprovalService.saveIqcApprovalBySap(approvalVO);
    }

    private void checkIqcApproval(PurchaseIqcApprovalVO iqcApproval) {
        Assert.notNull((Object)iqcApproval.getPrueflos(), (String)"\u68c0\u9a8c\u6279\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)iqcApproval.getSelmatnr(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String materialNumber = iqcApproval.getSelmatnr().replaceAll("^(0+)", "");
        iqcApproval.setSelmatnr(materialNumber);
        Assert.hasText((String)iqcApproval.getMaktx(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)iqcApproval.getWerk(), (String)"\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)iqcApproval.getCharg(), (String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)iqcApproval.getPaendterm(), (String)"\u68c0\u9a8c\u7ed3\u675f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)iqcApproval.getLifnr(), (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        String supplierCode = iqcApproval.getLifnr().replaceAll("^(0+)", "");
        iqcApproval.setLifnr(supplierCode);
        Assert.hasText((String)iqcApproval.getName1(), (String)"\u4f9b\u5e94\u5546\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)iqcApproval.getEbeln(), (String)"\u91c7\u8d2d\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)iqcApproval.getEbelp(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)iqcApproval.getMblnr(), (String)"\u7269\u6599\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)iqcApproval.getZeile(), (String)"\u7269\u6599\u51ed\u8bc1\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)iqcApproval.getLosmenge(), (String)"\u68c0\u9a8c\u6279\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)iqcApproval.getLmengeist(), (String)"\u5b9e\u9645\u6279\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)iqcApproval.getGesstichpr(), (String)"\u91c7\u6837\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)iqcApproval.getLmengesch(), (String)"\u7f3a\u9677\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void checkIqcOperation(PurchaseIqcApprovalVO approvalVO) {
        List<PurchaseIqcOperation> iqcOperationList = approvalVO.getItIqcoperationList();
        if (CollUtil.isEmpty(iqcOperationList)) {
            return;
        }
        iqcOperationList.forEach(iqcOperation -> {
            Assert.notNull((Object)iqcOperation.getPlnkn(), (String)"\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcOperation.getVornr(), (String)"\u68c0\u9a8c\u6b65\u9aa4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcOperation.getWerks(), (String)"\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcOperation.getSteus(), (String)"\u63a7\u5236\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkIqcResultSum((PurchaseIqcOperation)((Object)iqcOperation));
        });
    }

    private void checkIqcDefect(PurchaseIqcApprovalVO approvalVO) {
        List<PurchaseIqcDefect> iqcDefectList = approvalVO.getItIqcdefectList();
        if (CollUtil.isEmpty(iqcDefectList)) {
            return;
        }
        approvalVO.getItIqcdefectList().forEach(iqcDefect -> {
            Assert.notNull((Object)iqcDefect.getPosnr(), (String)"\u7f3a\u9677\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcDefect.getFegrp(), (String)"\u7f3a\u9677\u4ee3\u7801\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcDefect.getKurztext(), (String)"\u7f3a\u9677\u4ee3\u7801\u7ec4\u77ed\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcDefect.getFecod(), (String)"\u7f3a\u9677\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    private void checkIqcResultSum(PurchaseIqcOperation iqcOperation) {
        List<PurchaseIqcResultSum> iqcResultSumList = iqcOperation.getItIqcresultsumList();
        if (CollUtil.isEmpty(iqcResultSumList)) {
            return;
        }
        iqcOperation.getItIqcresultsumList().forEach(iqcResultSum -> {
            Assert.notNull((Object)iqcResultSum.getMerknr(), (String)"\u68c0\u9a8c\u7279\u6027\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)iqcResultSum.getZaehl(), (String)"\u68c0\u9a8c\u7279\u6027\u8ba1\u6570\u5668\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultSum.getVerwmerkm(), (String)"\u68c0\u9a8c\u7279\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultSum.getWerks(), (String)"\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultSum.getMkversion(), (String)"\u68c0\u9a8c\u7279\u6027\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultSum.getKurztext(), (String)"\u68c0\u9a8c\u7279\u6027\u77ed\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultSum.getStichprver(), (String)"\u91c7\u6837\u8fc7\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultSum.getProbemgeh(), (String)"\u91c7\u6837\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)iqcResultSum.getPruefeinh(), (String)"\u91c7\u6837\u7684\u91c7\u6837\u6570\u91cf\u56e0\u5b50\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultSum.getStatusr(), (String)"\u7ed3\u679c\u8bb0\u5f55\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)iqcResultSum.getSollstpumf(), (String)"\u68c0\u9a8c\u7279\u6027\u91c7\u6837\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)iqcResultSum.getAnzwertg(), (String)"\u5df2\u68c0\u9a8c\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    private void checkIqcResultDetail(PurchaseIqcResultSum iqcResultSum) {
        List<PurchaseIqcResultDetail> iqcResultDetailList = iqcResultSum.getItIqcresultdetailList();
        if (CollUtil.isEmpty(iqcResultDetailList)) {
            return;
        }
        iqcResultSum.getItIqcresultdetailList().forEach(iqcResultDetail -> {
            Assert.notNull((Object)iqcResultDetail.getStuecknr(), (String)"\u68c0\u9a8c\u5355\u5143\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultDetail.getMbewertg(), (String)"\u68c0\u9a8c\u7ed3\u679c\u8bc4\u4f30\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)iqcResultDetail.getMesswert(), (String)"\u8ba1\u91cf\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultDetail.getOriginalInput(), (String)"\u521d\u59cb\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)iqcResultDetail.getFehlklas(), (String)"\u7f3a\u9677\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)iqcResultDetail.getKurztext(), (String)"\u7f3a\u9677\u7c7b\u522b\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }
}

