/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.modules.eightReport.service.PurchaseEightDisciplinesZeroService;
import com.els.modules.quality.entity.PurchaseIqcApproval;
import com.els.modules.quality.entity.PurchaseIqcDefect;
import com.els.modules.quality.entity.PurchaseIqcOperation;
import com.els.modules.quality.entity.PurchaseIqcResultDetail;
import com.els.modules.quality.entity.PurchaseIqcResultSum;
import com.els.modules.quality.mapper.PurchaseIqcApprovalMapper;
import com.els.modules.quality.mapper.PurchaseIqcDefectMapper;
import com.els.modules.quality.mapper.PurchaseIqcOperationMapper;
import com.els.modules.quality.mapper.PurchaseIqcResultDetailMapper;
import com.els.modules.quality.mapper.PurchaseIqcResultSumMapper;
import com.els.modules.quality.service.PurchaseIqcApprovalService;
import com.els.modules.quality.vo.PurchaseIqcApprovalVO;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseIqcApprovalServiceImpl
extends BaseServiceImpl<PurchaseIqcApprovalMapper, PurchaseIqcApproval>
implements PurchaseIqcApprovalService {
    @Autowired
    private PurchaseIqcApprovalMapper purchaseIqcApprovalMapper;
    @Autowired
    private PurchaseIqcOperationMapper purchaseIqcOperationMapper;
    @Autowired
    private PurchaseIqcDefectMapper purchaseIqcDefectMapper;
    @Autowired
    private PurchaseIqcResultSumMapper purchaseIqcResultSumMapper;
    @Autowired
    private PurchaseIqcResultDetailMapper purchaseIqcResultDetailMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PurchaseEightDisciplinesZeroService purchaseEightDisciplinesZeroService;
    @Value(value="${els.config.purchaseAccount}")
    private String purchaseAccount;
    private static final String PUSH_IQC_AUDIT_TO_SAP = "pushIqcAuditToSap";

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseIqcApproval purchaseIqcApproval, List<PurchaseIqcOperation> purchaseIqcOperationList, List<PurchaseIqcDefect> purchaseIqcDefectList) {
        this.purchaseIqcApprovalMapper.insert((Object)purchaseIqcApproval);
        super.setHeadDefaultValue((BaseEntity)purchaseIqcApproval);
        this.purchaseEightDisciplinesZeroService.saveEightDisciplinesOfIqc(purchaseIqcApproval);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseIqcApproval purchaseIqcApproval, List<PurchaseIqcOperation> purchaseIqcOperationList, List<PurchaseIqcDefect> purchaseIqcDefectList) {
        this.purchaseIqcApprovalMapper.updateById((Object)purchaseIqcApproval);
        this.purchaseIqcOperationMapper.deleteByMainId(purchaseIqcApproval.getId());
        this.purchaseIqcDefectMapper.deleteByMainId(purchaseIqcApproval.getId());
        this.insertData(purchaseIqcApproval, purchaseIqcOperationList, purchaseIqcDefectList);
    }

    private void insertData(PurchaseIqcApproval purchaseIqcApproval, List<PurchaseIqcOperation> purchaseIqcOperationList, List<PurchaseIqcDefect> purchaseIqcDefectList) {
        if (!CollectionUtils.isEmpty(purchaseIqcOperationList)) {
            for (PurchaseIqcOperation purchaseIqcOperation : purchaseIqcOperationList) {
                purchaseIqcOperation.setHeadId(purchaseIqcApproval.getId());
                purchaseIqcOperation.setPlnty(purchaseIqcApproval.getPlnty());
                purchaseIqcOperation.setPlnnr(purchaseIqcApproval.getPlnnr());
                purchaseIqcOperation.setPlnal(purchaseIqcApproval.getPlnal());
                purchaseIqcOperation.setPplverw(purchaseIqcApproval.getPplverw());
                SysUtil.setSysParam((BaseEntity)purchaseIqcOperation, (BaseEntity)purchaseIqcApproval);
            }
            if (!purchaseIqcOperationList.isEmpty()) {
                this.purchaseIqcOperationMapper.insertBatchSomeColumn(purchaseIqcOperationList);
                this.insertSubData(purchaseIqcOperationList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseIqcDefectList)) {
            for (PurchaseIqcDefect purchaseIqcDefect : purchaseIqcDefectList) {
                purchaseIqcDefect.setHeadId(purchaseIqcApproval.getId());
                purchaseIqcDefect.setQmnum(purchaseIqcApproval.getQmnum());
                SysUtil.setSysParam((BaseEntity)purchaseIqcDefect, (BaseEntity)purchaseIqcApproval);
            }
            if (!purchaseIqcDefectList.isEmpty()) {
                this.purchaseIqcDefectMapper.insertBatchSomeColumn(purchaseIqcDefectList);
            }
        }
    }

    private void insertSubData(List<PurchaseIqcOperation> purchaseIqcOperationList) {
        for (PurchaseIqcOperation iqcOperation : purchaseIqcOperationList) {
            List<PurchaseIqcResultSum> purchaseIqcResultSumList = iqcOperation.getItIqcresultsumList();
            if (CollectionUtils.isEmpty(purchaseIqcResultSumList)) continue;
            for (PurchaseIqcResultSum entity : purchaseIqcResultSumList) {
                entity.setHeadId(iqcOperation.getId());
                entity.setPlnty(iqcOperation.getPlnty());
                entity.setPlnnr(iqcOperation.getPlnnr());
                entity.setPlnkn(iqcOperation.getPlnkn());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)iqcOperation);
            }
            if (purchaseIqcResultSumList.isEmpty()) continue;
            this.purchaseIqcResultSumMapper.insertBatchSomeColumn(purchaseIqcResultSumList);
            for (PurchaseIqcResultSum iqcResultSum : purchaseIqcResultSumList) {
                List<PurchaseIqcResultDetail> purchaseIqcResultDetailList = iqcResultSum.getItIqcresultdetailList();
                if (CollectionUtils.isEmpty(purchaseIqcResultDetailList)) continue;
                for (PurchaseIqcResultDetail entity : purchaseIqcResultDetailList) {
                    entity.setHeadId(iqcResultSum.getId());
                    entity.setMerknr(iqcResultSum.getMerknr());
                    entity.setZaehl(iqcResultSum.getZaehl());
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)iqcResultSum);
                }
                if (purchaseIqcResultDetailList.isEmpty()) continue;
                this.purchaseIqcResultDetailMapper.insertBatchSomeColumn(purchaseIqcResultDetailList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseIqcOperationMapper.deleteByMainId(id);
        this.purchaseIqcDefectMapper.deleteByMainId(id);
        this.purchaseIqcResultSumMapper.deleteByMainId(id);
        this.purchaseIqcResultDetailMapper.deleteByMainId(id);
        this.purchaseIqcApprovalMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseIqcOperationMapper.deleteByMainId(serializable.toString());
            this.purchaseIqcDefectMapper.deleteByMainId(serializable.toString());
            this.purchaseIqcResultSumMapper.deleteByMainId(serializable.toString());
            this.purchaseIqcResultDetailMapper.deleteByMainId(serializable.toString());
            this.purchaseIqcApprovalMapper.deleteById(serializable);
        }
    }

    @Override
    public void syncIqcAuditToSap(String id) {
        PurchaseIqcApproval purchaseIqcApproval = (PurchaseIqcApproval)((Object)this.getById((Serializable)((Object)id)));
        if (null == purchaseIqcApproval) {
            return;
        }
        this.interfaceUtil.callInterface(this.purchaseAccount, PUSH_IQC_AUDIT_TO_SAP, (Object)purchaseIqcApproval);
        this.purchaseEightDisciplinesZeroService.saveEightDisciplinesOfIqc(purchaseIqcApproval);
    }

    @Override
    public void saveIqcApprovalBySap(PurchaseIqcApprovalVO approvalVO) {
        PurchaseIqcApproval purchaseIqcApproval = new PurchaseIqcApproval();
        BeanUtils.copyProperties((Object)((Object)approvalVO), (Object)((Object)purchaseIqcApproval));
        this.saveMain(purchaseIqcApproval, approvalVO.getItIqcoperationList(), approvalVO.getItIqcdefectList());
        approvalVO.setId(purchaseIqcApproval.getId());
    }

    @Override
    public void saveEightDisciplines(String id) {
        PurchaseIqcApproval purchaseIqcApproval = (PurchaseIqcApproval)((Object)this.getById((Serializable)((Object)id)));
        if (null == purchaseIqcApproval) {
            return;
        }
        this.purchaseEightDisciplinesZeroService.saveEightDisciplinesOfIqc(purchaseIqcApproval);
    }
}

