/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.entity.SaleSampleHead;
import com.els.modules.sample.entity.SaleSampleItem;
import com.els.modules.sample.entity.SampleSupplierList;
import com.els.modules.sample.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.sample.enumerate.PurchaseSampleCheckAvailableQuantityEnum;
import com.els.modules.sample.enumerate.PurchaseSampleStatusEnum;
import com.els.modules.sample.enumerate.PurchaseSampleStatusItemEnum;
import com.els.modules.sample.mapper.PurchaseSampleHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleItemMapper;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.mapper.SaleSampleItemMapper;
import com.els.modules.sample.mapper.SampleSupplierListMapper;
import com.els.modules.sample.rpc.service.SampleInvokeMainDataRpcService;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.service.SaleSampleHeadService;
import com.els.modules.sample.service.SaleSampleItemService;
import com.els.modules.sample.service.impl.PurchaseSampleItemServiceImpl;
import com.els.modules.sample.service.impl.SaleSampleHeadServiceImpl;
import com.els.modules.sample.service.impl.SaleSampleItemServiceImpl;
import com.els.modules.sample.vo.PurchaseSampleHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSampleHeadServiceImpl
extends BaseServiceImpl<PurchaseSampleHeadMapper, PurchaseSampleHead>
implements PurchaseSampleHeadService {
    @Resource
    private PurchaseSampleHeadMapper purchaseSampleHeadMapper;
    @Resource
    private PurchaseSampleItemMapper purchaseSampleItemMapper;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private SampleSupplierListMapper sampleSupplierListMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SampleInvokeMainDataRpcService sampleInvokeMainDataRpcService;
    @Autowired
    private SaleSampleHeadService saleSampleHeadService;
    @Autowired
    private AccountRpcService accountRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSampleHead purchaseSampleHead, List<PurchaseSampleItem> purchaseSampleItemList, List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList, List<SampleSupplierList> sampleSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (StringUtils.isBlank((CharSequence)purchaseSampleHead.getSampleNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSampleNumber", (Object)purchaseSampleHead);
            purchaseSampleHead.setSampleNumber(nextCode);
        }
        super.setHeadDefaultValue((BaseEntity)purchaseSampleHead);
        purchaseSampleHead.setApplyDate(new Date());
        purchaseSampleHead.setBusAccount(TenantContext.getTenant());
        purchaseSampleHead.setSampleStatus(PurchaseSampleStatusEnum.SAMPLE_NEW.getValue());
        if (REPERTORY_UNIT_TYPE.equals(purchaseSampleHead.getPublishAudit())) {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplicant())) {
            purchaseSampleHead.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        }
        purchaseSampleHead.setPublishUser(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        if (StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplicant()) && StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplyDept())) {
            List<PurchaseOrganizationInfoDTO> list;
            if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length == 1 && !CollectionUtils.isEmpty(list = this.sampleInvokeMainDataRpcService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
                purchaseSampleHead.setApplyDept(list.get(0).getOrgCode());
            }
        } else if (StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplyDept()) && purchaseSampleHead.getApplicant().split("_").length == 2) {
            List<PurchaseOrganizationInfoDTO> list;
            ElsSubAccountDTO accountList = this.accountRpcService.getAccount(TenantContext.getTenant(), purchaseSampleHead.getApplicant().split("_")[0]);
            if (accountList != null && StrUtil.isNotBlank((CharSequence)accountList.getOrgCode()) && !CollectionUtils.isEmpty(list = this.sampleInvokeMainDataRpcService.listByIdAndCateCode(accountList.getOrgCode().split(",")[0], accountList.getElsAccount(), "dept"))) {
                purchaseSampleHead.setApplyDept(list.get(0).getOrgCode());
            }
        } else if (StrUtil.isNotBlank((CharSequence)purchaseSampleHead.getApplyDept())) {
            purchaseSampleHead.setApplyDept(purchaseSampleHead.getApplyDept().split("_")[0]);
        }
        this.purchaseSampleHeadMapper.insert((Object)purchaseSampleHead);
        this.insertData(purchaseSampleHead, purchaseSampleItemList, purchaseSampleTrackingItemList, sampleSupplierList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSampleHead purchaseSampleHead, List<PurchaseSampleItem> purchaseSampleItemList, List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList, List<SampleSupplierList> sampleSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (REPERTORY_UNIT_TYPE.equals(purchaseSampleHead.getPublishAudit())) {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSampleHeadMapper.updateById((Object)purchaseSampleHead);
        this.purchaseSampleItemMapper.deleteByMainId(purchaseSampleHead.getId());
        this.purchaseSampleTrackingItemMapper.deleteByMainId(purchaseSampleHead.getId());
        this.sampleSupplierListMapper.deleteByMainId(purchaseSampleHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSampleHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(purchaseSampleHead.getId());
        this.insertData(purchaseSampleHead, purchaseSampleItemList, purchaseSampleTrackingItemList, sampleSupplierList, purchaseAttachmentList);
    }

    private PurchaseMaterialUnitDTO getRePertoryUnit(List<PurchaseMaterialUnitDTO> units, String purchaseUnit) {
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            if (!REPERTORY_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null || !ObjectUnit.equals(purchaseUnit)) continue;
            return unitDTO;
        }
        return new PurchaseMaterialUnitDTO();
    }

    private BigDecimal computeQuantity(PurchaseSampleItem entity) {
        BigDecimal repertoryQuantity = entity.getRepertoryQuantity();
        if (repertoryQuantity == null || repertoryQuantity.compareTo(new BigDecimal(0)) == 0) {
            return repertoryQuantity;
        }
        String purchaseUnit = entity.getPurchaseUnit();
        String repertoryUnit = entity.getRepertoryUnit();
        if (purchaseUnit != null && purchaseUnit.equals(repertoryUnit) || purchaseUnit == null || repertoryUnit == null) {
            return repertoryQuantity;
        }
        List<PurchaseMaterialUnitDTO> units = this.sampleInvokeMainDataRpcService.selectByMaterialNumber(entity.getMaterialNumber());
        ArrayList<PurchaseMaterialUnitDTO> purchaseUnits = new ArrayList<PurchaseMaterialUnitDTO>();
        for (PurchaseMaterialUnitDTO unitDTO : units) {
            String ObjectUnit = unitDTO.getObjectUnit();
            String basicUnit = unitDTO.getBasicUnit();
            if (!PURCHASE_UNIT_TYPE.equals(unitDTO.getType()) || ObjectUnit == null || !ObjectUnit.equals(purchaseUnit)) continue;
            if (basicUnit.equals(repertoryUnit)) {
                BigDecimal basicAmount = unitDTO.getBasicAmount();
                BigDecimal objectAmount = unitDTO.getObjectAmount();
                return new BigDecimal(repertoryQuantity.divide(basicAmount).multiply(objectAmount).setScale(0, 4).intValue());
            }
            purchaseUnits.add(unitDTO);
            break;
        }
        PurchaseMaterialUnitDTO repertoryUnitDto = this.getRePertoryUnit(units, repertoryUnit);
        for (PurchaseMaterialUnitDTO unitDTO : purchaseUnits) {
            if (!unitDTO.getBasicUnit().equals(repertoryUnitDto.getBasicUnit())) continue;
            return repertoryQuantity.multiply(repertoryUnitDto.getBasicAmount()).divide(repertoryUnitDto.getObjectAmount(), 4, 3).divide(unitDTO.getBasicAmount(), 4, 3).multiply(unitDTO.getObjectAmount());
        }
        return repertoryQuantity;
    }

    private void insertData(PurchaseSampleHead purchaseSampleHead, List<PurchaseSampleItem> purchaseSampleItemList, List<PurchaseSampleTrackingItem> purchaseSampleTrackingItemList, List<SampleSupplierList> sampleSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseSampleItemList)) {
            int count = 1;
            for (PurchaseSampleItem entity : purchaseSampleItemList) {
                entity.setHeadId(purchaseSampleHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleHead);
                entity.setSampleNumber(purchaseSampleHead.getSampleNumber());
                if (entity.getMaterialNumber() != null && !"".equals(entity.getMaterialNumber())) {
                    entity.setRequireQuantity(this.computeQuantity(entity));
                    entity.setPurchaseUnit(entity.getPurchaseUnit());
                } else {
                    entity.setRequireQuantity(entity.getRepertoryQuantity());
                    entity.setPurchaseUnit(entity.getRepertoryUnit());
                }
                entity.setItemNumber(count + "");
                ++count;
                entity.setPurchaseGroup(purchaseSampleHead.getPurchaseGroup());
                entity.setPurchaseOrg(purchaseSampleHead.getPurchaseOrg());
                entity.setFactory(purchaseSampleHead.getFactory());
                entity.setCompany(purchaseSampleHead.getCompany());
                entity.setStorageLocation(purchaseSampleHead.getStorageLocation());
                if (StringUtils.isBlank((CharSequence)entity.getItemStatus())) {
                    entity.setItemStatus(PurchaseSampleStatusItemEnum.SAMPLE_NEW.getValue());
                }
                this.setAvailableQuantity(entity);
            }
            if (!purchaseSampleItemList.isEmpty()) {
                this.purchaseSampleItemMapper.insertBatchSomeColumn(purchaseSampleItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseSampleTrackingItemList)) {
            for (PurchaseSampleTrackingItem purchaseSampleTrackingItem : purchaseSampleTrackingItemList) {
                purchaseSampleTrackingItem.setHeadId(purchaseSampleHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSampleTrackingItem, (BaseEntity)purchaseSampleHead);
            }
            if (!purchaseSampleTrackingItemList.isEmpty()) {
                this.purchaseSampleTrackingItemMapper.insertBatchSomeColumn(purchaseSampleTrackingItemList);
            }
        }
        if (!CollectionUtils.isEmpty(sampleSupplierList)) {
            for (SampleSupplierList sampleSupplierList2 : sampleSupplierList) {
                sampleSupplierList2.setHeadId(purchaseSampleHead.getId());
                SysUtil.setSysParam((BaseEntity)sampleSupplierList2, (BaseEntity)purchaseSampleHead);
            }
            if (!sampleSupplierList.isEmpty()) {
                this.sampleSupplierListMapper.insertBatchSomeColumn(sampleSupplierList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setHeadId(purchaseSampleHead.getId());
                purchaseAttachmentDTO.setBusinessType("sample");
                purchaseAttachmentDTO.setSendStatus(PURCHASE_UNIT_TYPE);
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchaseSampleHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    private void setAvailableQuantity(PurchaseSampleItem entity) {
        entity.setAvailableQuantityStatus(PurchaseSampleCheckAvailableQuantityEnum.ALL.getValue());
        entity.setCheckedQuantity(BigDecimal.ZERO);
        entity.setAvailableQuantity(entity.getRepertoryQuantity());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSampleItemMapper.deleteByMainId(id);
        this.purchaseSampleTrackingItemMapper.deleteByMainId(id);
        this.sampleSupplierListMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseSampleHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSampleItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSampleTrackingItemMapper.deleteByMainId(serializable.toString());
            this.sampleSupplierListMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseSampleHeadMapper.deleteById(serializable);
        }
    }

    public static void setHeadParamAndCheck(PurchaseSampleHeadVO headVO, boolean isPublish) {
        String elsAccount = TenantContext.getTenant();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setSampleStatus(isPublish ? PurchaseSampleStatusEnum.SAMPLE_NEW.getValue() : PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue());
        headVO.setAuditStatus(REPERTORY_UNIT_TYPE.equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        if (isPublish) {
            Date currentDate = new Date();
            headVO.setPublishTime(currentDate);
            LoginUser user = SysUtil.getLoginUser();
            headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
            headVO.setSampleDate(headVO.getSampleDate() == null ? currentDate : headVO.getSampleDate());
            Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"i18n_alert_jXyRKIxOLV_f2ed08a5", (String)"\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Date nowTime = new Date();
            Assert.isTrue((nowTime.getTime() < headVO.getApplyEndTime().getTime() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_MByRKIiFxOQUAPKI_b669f8d2", (String)"\u56de\u590d\u622a\u6b62\u65f6\u95f4\u9009\u62e9\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.notEmpty(headVO.getPurchaseSampleItemList(), (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
            headVO.getPurchaseSampleItemList().forEach(item -> {
                if (REPERTORY_UNIT_TYPE.equals(headVO.getMustMaterialNumber())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_field_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                Assert.notNull((Object)item.getRepertoryQuantity(), (String)I18nUtil.translate((String)"i18n_alert_TVWRxOLV_da85d2b1", (String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((item.getRepertoryQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_cTVWRlTfUW_49c8866", (String)"\u884c\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
            });
            Assert.notEmpty(headVO.getSampleSupplierList(), (String)I18nUtil.translate((String)"i18n_alert_RdXxOLV_4ed7d39d", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    private void deleteSubTable(String headId) {
        this.purchaseSampleItemMapper.deleteByMainId(headId);
        this.sampleSupplierListMapper.deleteByMainId(headId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseSampleHeadVO headVO) {
        PurchaseSampleHeadServiceImpl.setHeadParamAndCheck(headVO, true);
        PurchaseSampleHead head = new PurchaseSampleHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            List<PurchaseOrganizationInfoDTO> list;
            SysUtil.setNullCreate((BaseEntity)head);
            String enquiryNumber = this.invokeBaseRpcService.getNextCode("srmSampleNumber", (Object)head);
            head.setSampleNumber(enquiryNumber);
            super.setHeadDefaultValue((BaseEntity)head);
            head.setApplyDate(new Date());
            head.setBusAccount(TenantContext.getTenant());
            head.setSampleStatus(PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue());
            head.setAuditStatus(REPERTORY_UNIT_TYPE.equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            LoginUser loginUser = SysUtil.getLoginUser();
            head.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
            if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length == 1 && !CollectionUtils.isEmpty(list = this.sampleInvokeMainDataRpcService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
                head.setApplyDept(list.get(0).getOrgCode());
            }
            ((PurchaseSampleHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            head.setSampleStatus(PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue());
            ((PurchaseSampleHeadMapper)this.baseMapper).updateById((Object)head);
            this.deleteSubTable(head.getId());
        }
        List<PurchaseSampleItem> itemList = headVO.getPurchaseSampleItemList();
        List<SampleSupplierList> supplierList = headVO.getSampleSupplierList();
        this.insertInitTable(head.getId(), itemList);
        this.publishSample(head, itemList, supplierList, headVO.getPurchaseAttachmentList());
    }

    private void insertInitTable(String headId, List<PurchaseSampleItem> itemList) {
        int itemNumber = 1;
        for (PurchaseSampleItem item : itemList) {
            item.setItemNumber(String.valueOf(itemNumber++));
        }
        ElsInitialTableDTO elsInitialTable = new ElsInitialTableDTO();
        elsInitialTable.setRelationId(headId);
        elsInitialTable.setBusinessInfoJson(JSON.toJSONString(itemList));
        this.invokeBaseRpcService.addElsInitialTable(elsInitialTable);
    }

    @Override
    public AttachmentSendDTO publishSample(PurchaseSampleHead head, List<PurchaseSampleItem> itemList, List<SampleSupplierList> supplierList, List<PurchaseAttachmentDTO> attachmentList) {
        String headId = head.getId();
        List<String> toElsAccountList = supplierList.stream().map(SampleSupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseSampleItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.sampleInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        ArrayList<PurchaseSampleItem> insertItemList = new ArrayList<PurchaseSampleItem>();
        ArrayList<PurchaseAttachmentDTO> insertAttachList = new ArrayList<PurchaseAttachmentDTO>();
        LoginUser user = SysUtil.getLoginUser();
        int itemNumber = 1;
        for (SampleSupplierList supplier : supplierList) {
            supplier.setId(IdWorker.getIdStr());
            supplier.setHeadId(headId);
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            for (PurchaseSampleItem item2 : itemList) {
                PurchaseSampleItem insertItem = new PurchaseSampleItem();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)insertItem));
                insertItem.setId(null);
                insertItem.setHeadId(headId);
                insertItem.setSampleNumber(head.getSampleNumber());
                insertItem.setItemNumber(String.valueOf(itemNumber++));
                insertItem.setItemStatus(PurchaseSampleStatusItemEnum.WAIT_SUPPLIER_OPT.getValue());
                insertItem.setPurchaseName(user.getEnterpriseName());
                insertItem.setToElsAccount(supplier.getToElsAccount());
                insertItem.setSupplierName(supplier.getSupplierName());
                insertItem.setSupplierCode(supplier.getSupplierCode());
                insertItem.setSupplierStatus(supplier.getSupplierStatus());
                this.setAvailableQuantity(insertItem);
                if (EnquiryQuoteWayEnum.NORMAL.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setLadderPriceJson(null);
                    insertItem.setCostFormJson(null);
                }
                if (StrUtil.isNotBlank((CharSequence)item2.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(item2.getMaterialNumber() + supplier.getToElsAccount());
                    insertItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                SysUtil.setSysParam((BaseEntity)insertItem, (BaseEntity)head);
                insertItemList.add(insertItem);
            }
            for (PurchaseAttachmentDTO attachment : attachmentList) {
                PurchaseAttachmentDTO dto = new PurchaseAttachmentDTO();
                BeanUtils.copyProperties((Object)attachment, (Object)dto);
                dto.setElsAccount(supplier.getToElsAccount());
                insertAttachList.add(dto);
            }
        }
        this.purchaseSampleItemMapper.insertBatchSomeColumn(insertItemList);
        this.sampleSupplierListMapper.insertBatchSomeColumn(supplierList);
        Map<String, SaleSampleHead> supplierMap = this.saleSampleHeadService.add(head, insertItemList, supplierList, insertAttachList);
        HashMap<String, String> idMap = new HashMap<String, String>();
        supplierMap.forEach((key, value) -> idMap.put((String)key, value.getId()));
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(TenantContext.getTenant());
        sendVO.setHeadId(head.getId());
        HashMap toSend = new HashMap();
        idMap.forEach((key, value) -> toSend.put(value, key));
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        String idStr = IdWorker.getIdStr();
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)head)));
        jsonObject.put("urlParams", receiveParamMap);
        this.redisUtil.set("sys:message:" + idStr, (Object)jsonObject, 172800L);
        super.sendMessage(TenantContext.getTenant(), "sample", "publish", idStr, "publishSampleBusDataServiceImpl", toElsAccountList);
        return sendVO;
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, SaleSampleHead> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("busAccount", (Object)value.getBusAccount());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    public void publishNewSupplier(PurchaseSampleHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseSampleHead dbHead = (PurchaseSampleHead)((Object)((PurchaseSampleHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((!PURCHASE_UNIT_TYPE.equals(dbHead.getPublishNewSupplier()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APtFxqhxVRdX_dac5ea44", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        Assert.isTrue((boolean)dbHead.getApplyEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_yRKIIRWxqhxVRdX_b0725152", (String)"\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        Assert.isTrue((!PurchaseSampleStatusEnum.CLOSE.getValue().equals(dbHead.getSampleStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_IRljtFxqhxVRdX_ca9d1322", (String)"\u5df2\u5173\u95ed\u7684\u5355\u636e\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        List hadList = this.sampleSupplierListMapper.selectByMainId(headId).parallelStream().map(SampleSupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<SampleSupplierList> supplierList = headVO.getSampleSupplierList().parallelStream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List itemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseSampleItem.class);
        this.publishSample(dbHead, itemList, supplierList, headVO.getPurchaseAttachmentList());
        List toElsAccountList = supplierList.stream().map(SampleSupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMessage(TenantContext.getTenant(), "sample", "publish", dbHead.getId(), "purchaseSampleHeadBusDataServiceImpl", toElsAccountList);
    }

    @Override
    public void updateQuoteEntTime(PurchaseSampleHead dbHead, Date quoteEndTime) {
        PurchaseSampleHead updateHead = new PurchaseSampleHead();
        updateHead.setId(dbHead.getId());
        updateHead.setApplyEndTime(quoteEndTime);
        this.updateById((Object)updateHead);
        this.saleSampleHeadService.update((Wrapper)new LambdaUpdateWrapper().set(SaleSampleHead::getApplyEndTime, (Object)quoteEndTime));
    }

    @Override
    public void colse(String id) {
        List<PurchaseSampleItem> purchaseSampleItems = this.purchaseSampleItemMapper.selectByMainId(id);
        for (PurchaseSampleItem item : purchaseSampleItems) {
            if (PurchaseSampleStatusItemEnum.SAMPLE_NEW.getValue().equals(item.getItemStatus()) || PurchaseSampleStatusItemEnum.QUOTED.getValue().equals(item.getItemStatus()) || PurchaseSampleStatusItemEnum.DEMAND_RETURN.getValue().equals(item.getItemStatus()) || PurchaseSampleStatusItemEnum.NO_SAMPLES.getValue().equals(item.getItemStatus())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKEzELWVIWWWosTVuWWWTVYMWWWxOdVWRHjjcWFWShitRl_c3a4422", (String)"\u5b58\u5728\u884c\u72b6\u6001\u4e3a[\u65b0\u5efa]\u3001[\u5f85\u8f6c\u9700\u6c42\u6c60]\u3001[\u9700\u6c42\u9000\u56de]\u3001[\u4e0d\u80fd\u9001\u6837]\u4e4b\u5916\u7684\u7684\u884c\u6570\u636e\uff0c\u65e0\u6cd5\u6574\u5355\u5173\u95ed"));
        }
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadMapper.selectById((Serializable)((Object)id)));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id)).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update((Object)new PurchaseSampleHead());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleSampleHeadService.lambdaUpdate().eq(SaleSampleHead::getBusAccount, (Object)purchaseSampleHead.getElsAccount())).eq(SaleSampleHead::getSampleNumber, (Object)purchaseSampleHead.getSampleNumber())).set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update((Object)new SaleSampleHead());
        List collectPurchase = purchaseSampleItems.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectPurchase)).update((Object)new PurchaseSampleItem());
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectSale)).update((Object)new SaleSampleItem());
    }

    @Override
    public void cutOff(String id) {
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadMapper.selectById((Serializable)((Object)id)));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id)).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue())).update((Object)new PurchaseSampleHead());
        List<PurchaseSampleItem> purchaseSampleItemList = this.purchaseSampleItemMapper.selectByMainId(id);
        for (PurchaseSampleItem item : purchaseSampleItemList) {
            item.setItemStatus(PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue());
            this.purchaseSampleItemMapper.updateById((Object)item);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleSampleHeadService.lambdaUpdate().eq(SaleSampleHead::getBusAccount, (Object)purchaseSampleHead.getElsAccount())).eq(SaleSampleHead::getSampleNumber, (Object)purchaseSampleHead.getSampleNumber())).eq(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue())).set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue())).update((Object)new SaleSampleHead());
        List purSampleItemIdList = purchaseSampleItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        UpdateWrapper updateHeadWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateHeadWrapper.lambda().eq(SaleSampleHead::getRelationId, (Object)id)).set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue());
        this.saleSampleHeadService.update((Wrapper)updateHeadWrapper);
        SaleSampleItemService sampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemService.class);
        UpdateWrapper updateItemWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateItemWrapper.lambda().in(SaleSampleItem::getRelationId, purSampleItemIdList)).set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue());
        sampleItemService.update((Wrapper)updateItemWrapper);
    }

    @Override
    public void colseByItems(List<PurchaseSampleItem> purchaseSampleItemList) {
        List collectPurchase = purchaseSampleItemList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(collectPurchase);
        List<String> collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectPurchase)).update((Object)new PurchaseSampleItem());
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.CLOSE.getValue())).in(BaseEntity::getId, collectSale)).update((Object)new SaleSampleItem());
        List<PurchaseSampleItem> purchaseSampleItems1 = purchaseSampleItemService.selectByMainId(purchaseSampleItemList.get(0).getHeadId());
        if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseSampleItemList.get(0).getHeadId())).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update((Object)new PurchaseSampleHead());
        } else if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseSampleItemList.get(0).getHeadId())).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue())).update((Object)new PurchaseSampleHead());
        }
        SaleSampleItemMapper sampleItemMapper = (SaleSampleItemMapper)SpringContextUtils.getBean(SaleSampleItemMapper.class);
        List<SaleSampleItem> saleSampleItems = sampleItemMapper.selectListByIdList(collectSale);
        List collectSaleHeadId = saleSampleItems.parallelStream().map(SaleSampleItem::getHeadId).distinct().collect(Collectors.toList());
        List<SaleSampleItem> totalSaleSampleItems = saleSampleItemService.selectByMainId(purchaseSampleItemList.get(0).getHeadId());
        for (String saleHeadId : collectSaleHeadId) {
            List saleSampleItems1 = totalSaleSampleItems.parallelStream().filter(saleSampleItem -> saleSampleItem.getHeadId().equals(saleHeadId)).collect(Collectors.toList());
            List saleSampleItems2 = saleSampleItems1.parallelStream().filter(saleSampleItem -> saleSampleItem.getHeadId().equals(saleHeadId)).collect(Collectors.toList());
            if (saleSampleItems1.size() != saleSampleItems2.size()) continue;
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleSampleHeadService.lambdaUpdate().eq(BaseEntity::getId, (Object)saleHeadId)).set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.CLOSE.getValue())).update((Object)new SaleSampleHead());
        }
    }

    @Override
    public void signSample(List<PurchaseSampleItem> purchaseSampleItemList) {
        purchaseSampleItemList.forEach(item -> {
            if (!PurchaseSampleStatusItemEnum.SENDING_SAMPLES.getValue().equals(item.getItemStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IisEsMKzExLdVsncdI_bd0262d5", (String)"\u5df2\u9009\u4e2d\u884c\u4e2d\u5b58\u5728\u72b6\u6001\u4e0d\u4e3a\u9001\u6837\u4e2d\u7684\u884c\u9879\u76ee"));
            }
        });
        List collectPurchase = purchaseSampleItemList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(collectPurchase);
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, collectPurchase)).update((Object)new PurchaseSampleItem());
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, collectSale)).update((Object)new SaleSampleItem());
        List<PurchaseSampleItem> purchaseSampleItems1 = purchaseSampleItemService.selectByMainId(purchaseSampleItemList.get(0).getHeadId());
        if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseSampleItemList.get(0).getHeadId())).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue())).update((Object)new PurchaseSampleHead());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(SaleSampleHead::getRelationId, (Object)purchaseSampleItemList.get(0).getHeadId());
            updateWrapper.lambda().set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue());
            SaleSampleHeadService saleSampleheadService = (SaleSampleHeadService)SpringContextUtils.getBean(SaleSampleHeadServiceImpl.class);
            saleSampleheadService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void deliveryByOrder(List<String> sampleItemList, String headId) {
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(sampleItemList);
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, sampleItemList)).update((Object)new PurchaseSampleItem());
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).in(BaseEntity::getId, collectSale)).update((Object)new SaleSampleItem());
        List<PurchaseSampleItem> purchaseSampleItems1 = purchaseSampleItemService.selectByMainId(headId);
        if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)headId)).set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue())).update((Object)new PurchaseSampleHead());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(SaleSampleHead::getRelationId, (Object)headId);
            updateWrapper.lambda().set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue());
            SaleSampleHeadService saleSampleheadService = (SaleSampleHeadService)SpringContextUtils.getBean(SaleSampleHeadServiceImpl.class);
            saleSampleheadService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void orderByRequestItem(List<String> sampleItemList) {
        List purchaseSampleItems = this.purchaseSampleItemMapper.selectBatchIds(sampleItemList);
        List collectSale = purchaseSampleItems.parallelStream().map(PurchaseSampleItem::getRelationId).collect(Collectors.toList());
        PurchaseSampleItemService purchaseSampleItemService = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)purchaseSampleItemService.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.ORDER_TRANSFERRED.getValue())).in(BaseEntity::getId, sampleItemList)).update((Object)new PurchaseSampleItem());
        SaleSampleItemService saleSampleItemService = (SaleSampleItemService)SpringContextUtils.getBean(SaleSampleItemServiceImpl.class);
        if (CollectionUtil.isNotEmpty(collectSale)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)saleSampleItemService.lambdaUpdate().set(SaleSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.ORDER_TRANSFERRED.getValue())).in(BaseEntity::getId, collectSale)).update((Object)new SaleSampleItem());
        }
    }

    @Override
    public void copy(String id) {
        PurchaseSampleHead purchaseSampleHead;
        if (StringUtils.isNotBlank((CharSequence)id) && (purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadMapper.selectById((Serializable)((Object)id)))) != null) {
            List<SampleSupplierList> sampleSupplierLists;
            List<PurchaseSampleTrackingItem> purchaseSampleTrackingItems;
            purchaseSampleHead.setId(null);
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSampleNumber", (Object)purchaseSampleHead);
            purchaseSampleHead.setSampleNumber(nextCode);
            super.setHeadDefaultValue((BaseEntity)purchaseSampleHead);
            purchaseSampleHead.setApplyDate(new Date());
            purchaseSampleHead.setBusAccount(TenantContext.getTenant());
            purchaseSampleHead.setSampleStatus(PurchaseSampleStatusEnum.SAMPLE_NEW.getValue());
            if (REPERTORY_UNIT_TYPE.equals(purchaseSampleHead.getPublishAudit())) {
                purchaseSampleHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            } else {
                purchaseSampleHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            LoginUser loginUser = SysUtil.getLoginUser();
            if (StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplicant())) {
                purchaseSampleHead.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
            }
            purchaseSampleHead.setPublishUser(loginUser.getSubAccount() + "_" + loginUser.getRealname());
            purchaseSampleHead.setCreateTime(new Date());
            purchaseSampleHead.setUpdateTime(new Date());
            purchaseSampleHead.setCreateBy(loginUser.getSubAccount());
            purchaseSampleHead.setUpdateBy(loginUser.getSubAccount());
            purchaseSampleHead.setCreateById(loginUser.getId());
            purchaseSampleHead.setUpdateById(loginUser.getId());
            if (StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplicant()) && StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplyDept())) {
                List<PurchaseOrganizationInfoDTO> list;
                if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length == 1 && !CollectionUtils.isEmpty(list = this.sampleInvokeMainDataRpcService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
                    purchaseSampleHead.setApplyDept(list.get(0).getOrgCode());
                }
            } else if (StrUtil.isBlank((CharSequence)purchaseSampleHead.getApplyDept()) && purchaseSampleHead.getApplicant().split("_").length == 2) {
                List<PurchaseOrganizationInfoDTO> list;
                ElsSubAccountDTO accountList = this.accountRpcService.getAccount(TenantContext.getTenant(), purchaseSampleHead.getApplicant().split("_")[0]);
                if (accountList != null && StrUtil.isNotBlank((CharSequence)accountList.getOrgCode()) && !CollectionUtils.isEmpty(list = this.sampleInvokeMainDataRpcService.listByIdAndCateCode(accountList.getOrgCode().split(",")[0], accountList.getElsAccount(), "dept"))) {
                    purchaseSampleHead.setApplyDept(list.get(0).getOrgCode());
                }
            } else if (StrUtil.isNotBlank((CharSequence)purchaseSampleHead.getApplyDept())) {
                purchaseSampleHead.setApplyDept(purchaseSampleHead.getApplyDept().split("_")[0]);
            }
            this.purchaseSampleHeadMapper.insert((Object)purchaseSampleHead);
            List<PurchaseSampleItem> purchaseSampleItems = this.purchaseSampleItemMapper.selectByMainId(id);
            List toElsAccountList = purchaseSampleItems.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getToElsAccount())).map(PurchaseSampleItem::getToElsAccount).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(toElsAccountList)) {
                List items = purchaseSampleItems.stream().filter(item -> ((String)toElsAccountList.get(0)).equals(item.getToElsAccount())).collect(Collectors.toList());
                for (PurchaseSampleItem purchaseSampleItem : items) {
                    purchaseSampleItem.setToElsAccount(null);
                    purchaseSampleItem.setSupplierCode(null);
                    purchaseSampleItem.setSupplierName(null);
                }
                purchaseSampleItems = items;
            }
            if (!CollectionUtils.isEmpty(purchaseSampleItems)) {
                int count = 1;
                for (PurchaseSampleItem purchaseSampleItem : purchaseSampleItems) {
                    purchaseSampleItem.setHeadId(purchaseSampleHead.getId());
                    SysUtil.setSysParam((BaseEntity)purchaseSampleItem, (BaseEntity)purchaseSampleHead);
                    purchaseSampleItem.setSampleNumber(purchaseSampleHead.getSampleNumber());
                    if (purchaseSampleItem.getMaterialNumber() != null && !"".equals(purchaseSampleItem.getMaterialNumber())) {
                        purchaseSampleItem.setRequireQuantity(this.computeQuantity(purchaseSampleItem));
                        purchaseSampleItem.setPurchaseUnit(purchaseSampleItem.getPurchaseUnit());
                    } else {
                        purchaseSampleItem.setRequireQuantity(purchaseSampleItem.getRepertoryQuantity());
                        purchaseSampleItem.setPurchaseUnit(purchaseSampleItem.getRepertoryUnit());
                    }
                    purchaseSampleItem.setItemNumber(count + "");
                    ++count;
                    purchaseSampleItem.setPurchaseGroup(purchaseSampleHead.getPurchaseGroup());
                    purchaseSampleItem.setPurchaseOrg(purchaseSampleHead.getPurchaseOrg());
                    purchaseSampleItem.setFactory(purchaseSampleHead.getFactory());
                    purchaseSampleItem.setCompany(purchaseSampleHead.getCompany());
                    purchaseSampleItem.setStorageLocation(purchaseSampleHead.getStorageLocation());
                    purchaseSampleItem.setItemStatus(PurchaseSampleStatusItemEnum.SAMPLE_NEW.getValue());
                    purchaseSampleItem.setAvailableQuantityStatus(PurchaseSampleCheckAvailableQuantityEnum.ALL.getValue());
                    purchaseSampleItem.setCheckedQuantity(BigDecimal.ZERO);
                    purchaseSampleItem.setId(null);
                    purchaseSampleItem.setCreateTime(new Date());
                    purchaseSampleItem.setUpdateTime(new Date());
                    purchaseSampleItem.setCreateBy(loginUser.getRealname());
                    purchaseSampleItem.setUpdateBy(loginUser.getRealname());
                }
                if (!purchaseSampleItems.isEmpty()) {
                    this.purchaseSampleItemMapper.insertBatchSomeColumn(purchaseSampleItems);
                }
            }
            if (!CollectionUtils.isEmpty(purchaseSampleTrackingItems = this.purchaseSampleTrackingItemMapper.selectByMainId(id))) {
                for (PurchaseSampleTrackingItem purchaseSampleTrackingItem : purchaseSampleTrackingItems) {
                    purchaseSampleTrackingItem.setHeadId(purchaseSampleHead.getId());
                    purchaseSampleTrackingItem.setId(null);
                    purchaseSampleTrackingItem.setCreateTime(new Date());
                    purchaseSampleTrackingItem.setUpdateTime(new Date());
                    purchaseSampleTrackingItem.setCreateBy(loginUser.getRealname());
                    purchaseSampleTrackingItem.setUpdateBy(loginUser.getRealname());
                    SysUtil.setSysParam((BaseEntity)purchaseSampleTrackingItem, (BaseEntity)purchaseSampleHead);
                }
                if (!purchaseSampleTrackingItems.isEmpty()) {
                    this.purchaseSampleTrackingItemMapper.insertBatchSomeColumn(purchaseSampleTrackingItems);
                }
            }
            if (!CollectionUtils.isEmpty(sampleSupplierLists = this.sampleSupplierListMapper.selectByMainId(id))) {
                for (SampleSupplierList entity : sampleSupplierLists) {
                    entity.setHeadId(purchaseSampleHead.getId());
                    entity.setId(null);
                    entity.setCreateTime(new Date());
                    entity.setUpdateTime(new Date());
                    entity.setCreateBy(loginUser.getRealname());
                    entity.setUpdateBy(loginUser.getRealname());
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleHead);
                }
                if (!sampleSupplierLists.isEmpty()) {
                    this.sampleSupplierListMapper.insertBatchSomeColumn(sampleSupplierLists);
                }
            }
        }
    }

    @Override
    public JSONObject getPurchaseSampleDataById(String id) {
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)purchaseSampleHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }
}

