/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.PurchaseMouldScrapped;
import com.els.modules.mould.entity.SaleMouldData;
import com.els.modules.mould.entity.SaleMouldScrapped;
import com.els.modules.mould.enumerate.MouldStatusEnum;
import com.els.modules.mould.enumerate.ScrappedStatusEnum;
import com.els.modules.mould.mapper.PurchaseMouldScrappedMapper;
import com.els.modules.mould.mapper.SaleMouldScrappedMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.PurchaseMouldScrappedService;
import com.els.modules.mould.service.SaleMouldDataService;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMouldScrappedServiceImpl
extends BaseServiceImpl<PurchaseMouldScrappedMapper, PurchaseMouldScrapped>
implements PurchaseMouldScrappedService {
    @Resource
    private SaleMouldScrappedMapper saleMouldScrappedMapper;
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;
    @Autowired
    private SaleMouldDataService saleMouldDataService;

    @Override
    public void finish(PurchaseMouldScrapped scrapped) {
        scrapped.setScrappedStatus(ScrappedStatusEnum.FINISH.getValue());
        ((PurchaseMouldScrappedMapper)this.baseMapper).updateById((Object)scrapped);
        SaleMouldScrapped saleScrapped = new SaleMouldScrapped();
        saleScrapped.setId(scrapped.getRelationId());
        saleScrapped.setScrappedStatus(ScrappedStatusEnum.FINISH.getValue());
        saleScrapped.setRelationId(scrapped.getId());
        saleScrapped.setPurchaseRemark(scrapped.getPurchaseRemark());
        this.saleMouldScrappedMapper.updateById((Object)saleScrapped);
    }

    @Override
    public void confirm(PurchaseMouldScrapped scrapped) {
        Date now = new Date();
        scrapped.setScrappedStatus(ScrappedStatusEnum.CONFIRM.getValue());
        scrapped.setConfirmTime(now);
        scrapped.setScrappedTime(now);
        ((PurchaseMouldScrappedMapper)this.baseMapper).updateById((Object)scrapped);
        this.updateSale(scrapped);
        SaleMouldData saleMouldData = new SaleMouldData();
        saleMouldData.setId(scrapped.getMouldDataId());
        saleMouldData.setMouldStatus(MouldStatusEnum.SCRAPPED.getValue());
        this.saleMouldDataService.updateById((Object)saleMouldData);
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(PurchaseMouldData::getMouldStatus, (Object)MouldStatusEnum.SCRAPPED.getValue())).eq(PurchaseMouldData::getRelationId, (Object)scrapped.getMouldDataId()));
    }

    @Override
    public void refuse(PurchaseMouldScrapped scrapped) {
        scrapped.setScrappedStatus(ScrappedStatusEnum.REFUSE.getValue());
        ((PurchaseMouldScrappedMapper)this.baseMapper).updateById((Object)scrapped);
        this.updateSale(scrapped);
        this.saleMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)scrapped.getMouldDataId())).set(SaleMouldData::getTargetStatus, null));
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseMouldData::getRelationId, (Object)scrapped.getMouldDataId())).set(PurchaseMouldData::getTargetStatus, null));
    }

    private void updateSale(PurchaseMouldScrapped scrapped) {
        SaleMouldScrapped saleScrapped = new SaleMouldScrapped();
        BeanUtils.copyProperties((Object)((Object)scrapped), (Object)((Object)saleScrapped));
        saleScrapped.setId(scrapped.getRelationId());
        saleScrapped.setRelationId(scrapped.getId());
        saleScrapped.setElsAccount(scrapped.getToElsAccount());
        saleScrapped.setToElsAccount(scrapped.getElsAccount());
        saleScrapped.setPurchaseRemark(scrapped.getPurchaseRemark());
        this.saleMouldScrappedMapper.updateById((Object)saleScrapped);
    }
}

