/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.advice.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.advice.entity.ComplaintAdviceHead;
import com.els.modules.advice.entity.ComplaintAdviceOperateRecord;
import com.els.modules.advice.entity.ComplaintAdviceRecord;
import com.els.modules.advice.enumerate.AdviceOperationTypeEnum;
import com.els.modules.advice.enumerate.AdviceStatusEnum;
import com.els.modules.advice.mapper.ComplaintAdviceHeadMapper;
import com.els.modules.advice.service.ComplaintAdviceHeadService;
import com.els.modules.advice.service.ComplaintAdviceOperateRecordService;
import com.els.modules.advice.service.ComplaintAdviceRecordService;
import com.els.modules.advice.vo.OperateVO;
import com.els.modules.workorder.enumerate.ContentTypeEnum;
import com.els.modules.workorder.enumerate.RecordSendStatusEnum;
import com.els.modules.workorder.util.PanshiUtil;
import com.els.modules.workorder.vo.ScoreResultVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ComplaintAdviceHeadServiceImpl
extends BaseServiceImpl<ComplaintAdviceHeadMapper, ComplaintAdviceHead>
implements ComplaintAdviceHeadService {
    @Autowired
    private ComplaintAdviceRecordService complaintAdviceRecordService;
    @Autowired
    private ComplaintAdviceOperateRecordService complaintAdviceOperateRecordService;
    @Autowired
    private PanshiUtil panshiUtil;
    private String version = this.getClass().getPackage().getImplementationVersion();

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ComplaintAdviceHead complaintAdviceHead, List<ComplaintAdviceRecord> complaintAdviceRecordList) {
        complaintAdviceHead.setAdviceStatus(AdviceStatusEnum.NEW.getValue());
        ((ComplaintAdviceHeadMapper)this.baseMapper).insert((Object)complaintAdviceHead);
        this.insertData(complaintAdviceHead, complaintAdviceRecordList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ComplaintAdviceHead complaintAdviceHead, List<ComplaintAdviceRecord> complaintAdviceRecordList) {
        int count = ((ComplaintAdviceHeadMapper)this.baseMapper).updateById((Object)complaintAdviceHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.complaintAdviceRecordService.deleteByMainId(complaintAdviceHead.getId());
        this.insertData(complaintAdviceHead, complaintAdviceRecordList);
    }

    private void insertData(ComplaintAdviceHead complaintAdviceHead, List<ComplaintAdviceRecord> complaintAdviceRecordList) {
        if (!CollectionUtils.isEmpty(complaintAdviceRecordList)) {
            for (ComplaintAdviceRecord entity : complaintAdviceRecordList) {
                entity.setHeadId(complaintAdviceHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)complaintAdviceHead);
            }
            this.complaintAdviceRecordService.saveBatch(complaintAdviceRecordList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.complaintAdviceRecordService.deleteByMainId(id);
        ((ComplaintAdviceHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submit(ComplaintAdviceHead complaintAdviceHead) {
        complaintAdviceHead.setElsAccount(TenantContext.getTenant());
        complaintAdviceHead.setCompanyName(SysUtil.getLoginUser().getEnterpriseName());
        complaintAdviceHead.setSubmitAccount(TenantContext.getTenant());
        complaintAdviceHead.setSubmitSubAccount(this.getLoginSubAndName());
        complaintAdviceHead.setSubmitTime(new Date());
        complaintAdviceHead.setAppVersion(this.version);
        complaintAdviceHead.setAdviceStatus(AdviceStatusEnum.IN_PROGRESS.getValue());
        if (StrUtil.isBlank((CharSequence)complaintAdviceHead.getId())) {
            ((ComplaintAdviceHeadMapper)this.baseMapper).insert((Object)complaintAdviceHead);
        }
        this.saveOperationRecord(complaintAdviceHead, AdviceOperationTypeEnum.SUBMIT.getValue(), "\u63d0\u4ea4\u5355\u636e", null);
        JSONObject body = SysUtil.objectToJSON((Object)((Object)complaintAdviceHead));
        JSONObject resultObj = this.panshiUtil.callPanshi("createAdvice", body);
        if (!resultObj.getBooleanValue("success")) {
            throw new ELSBootException("\u63d0\u4ea4\u5355\u636e\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        ((ComplaintAdviceHeadMapper)this.baseMapper).updateById(JSON.parseObject((String)resultObj.getJSONObject("result").toString(), ComplaintAdviceHead.class));
    }

    private void saveOperationRecord(ComplaintAdviceHead complaintAdviceHead, String optType, String content, String recipient) {
        ComplaintAdviceOperateRecord record = new ComplaintAdviceOperateRecord();
        record.setOperationPerson(this.getLoginSubAndName());
        record.setOperationTime(new Date());
        record.setOperationType(optType);
        record.setProjectName(complaintAdviceHead.getProjectName());
        record.setAdviceId(complaintAdviceHead.getId());
        record.setAdviceNumber(complaintAdviceHead.getAdviceNumber());
        record.setTitle(complaintAdviceHead.getTitle());
        record.setRemark(content);
        record.setRecipient(recipient);
        this.complaintAdviceOperateRecordService.save((Object)record);
    }

    private ComplaintAdviceRecord buidRecord(String headId, String content) {
        ComplaintAdviceRecord record = new ComplaintAdviceRecord();
        record.setId(IdWorker.getIdStr());
        record.setHeadId(headId);
        record.setContentType(ContentTypeEnum.OUR.getValue());
        record.setContent(content);
        record.setElsAccount(TenantContext.getTenant());
        record.setCreateBy(this.getLoginSubAndName());
        record.setCreateTime(new Date());
        return record;
    }

    private void callInterface(String interfaceCode, String adviceStatus, String projectId, ComplaintAdviceRecord record) {
        JSONObject body = this.getRecordBody(adviceStatus, record);
        JSONObject resultObj = this.panshiUtil.callPanshi(interfaceCode, body);
        if (!resultObj.getBooleanValue("success")) {
            this.log.error("confirmWorkOrder_failed:" + resultObj.getString("message"));
            record.setSendStatus(RecordSendStatusEnum.SEND_FAILED.getValue());
            record.setErrorMsg(resultObj.getString("message"));
        } else {
            record.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        }
    }

    private JSONObject getRecordBody(String currentStatus, ComplaintAdviceRecord record) {
        JSONObject body = new JSONObject();
        body.put("id", (Object)record.getHeadId());
        body.put("currentStatus", (Object)currentStatus);
        JSONObject recordObj = SysUtil.objectToJSON((Object)((Object)record));
        body.put("record", (Object)recordObj);
        return body;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public ComplaintAdviceRecord sendMsg(OperateVO operateVO) {
        ComplaintAdviceHead adviceHead = (ComplaintAdviceHead)((Object)((ComplaintAdviceHeadMapper)this.baseMapper).selectById((Serializable)((Object)operateVO.getId())));
        if (adviceHead == null) {
            throw new ELSBootException("ID \u4e0d\u5b58\u5728\uff01");
        }
        ComplaintAdviceRecord record = this.buidRecord(adviceHead.getId(), operateVO.getContent());
        record.setHeadId(operateVO.getId());
        record.setContentType(ContentTypeEnum.OUR.getValue());
        record.setContent(operateVO.getContent());
        this.callInterface("sendAdviceRecord", adviceHead.getAdviceStatus(), adviceHead.getProjectId(), record);
        this.complaintAdviceRecordService.save((Object)record);
        return record;
    }

    @Override
    public ComplaintAdviceRecord retryRecord(ComplaintAdviceRecord record) {
        ComplaintAdviceHead adviceHead = (ComplaintAdviceHead)((Object)((ComplaintAdviceHeadMapper)this.baseMapper).selectById((Serializable)((Object)record.getHeadId())));
        if (adviceHead == null) {
            throw new ELSBootException("ID \u4e0d\u5b58\u5728\uff01");
        }
        this.callInterface("sendAdviceRecord", adviceHead.getAdviceStatus(), adviceHead.getProjectId(), record);
        this.complaintAdviceRecordService.updateById((Object)record);
        return record;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void close(OperateVO operateVO) {
        ComplaintAdviceHead adviceHead = (ComplaintAdviceHead)((Object)((ComplaintAdviceHeadMapper)this.baseMapper).selectById((Serializable)((Object)operateVO.getId())));
        if (adviceHead == null) {
            throw new ELSBootException("ID \u4e0d\u5b58\u5728\uff01");
        }
        ComplaintAdviceHead update = new ComplaintAdviceHead();
        update.setId(operateVO.getId());
        update.setAdviceStatus(AdviceStatusEnum.CLOSE.getValue());
        ((ComplaintAdviceHeadMapper)this.baseMapper).updateById((Object)update);
        this.saveOperationRecord(adviceHead, AdviceOperationTypeEnum.CLOSE.getValue(), operateVO.getContent(), null);
        ComplaintAdviceRecord record = this.buidRecord(adviceHead.getId(), this.getLoginSubAndName() + " \u5df2\u5c06\u5355\u636e\u5173\u95ed\uff01\u5982\u6709\u7591\u95ee\u8bf7\u518d\u6b21\u63d0\u4ea4\u3002<br>\u5173\u5355\u5907\u6ce8\uff1a" + operateVO.getContent());
        JSONObject body = this.getRecordBody(adviceHead.getAdviceStatus(), record);
        JSONObject resultObj = this.panshiUtil.callPanshi("closeAdvice", body);
        if (!resultObj.getBooleanValue("success")) {
            this.log.error("callInterface_failed:" + resultObj.getString("message"));
            throw new ELSBootException("\u5173\u95ed\u5de5\u5355\u5931\u8d25\uff01" + resultObj.getString("message"));
        }
        record.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.complaintAdviceRecordService.save((Object)record);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void score(ScoreResultVO resultVO) {
        ComplaintAdviceHead adviceHead = (ComplaintAdviceHead)((Object)((ComplaintAdviceHeadMapper)this.baseMapper).selectById((Serializable)((Object)resultVO.getId())));
        if (adviceHead == null) {
            throw new ELSBootException("ID \u4e0d\u5b58\u5728\uff01");
        }
        ComplaintAdviceHead update = new ComplaintAdviceHead();
        BeanUtils.copyProperties((Object)resultVO, (Object)((Object)update));
        update.setContent(null);
        update.setScore("1");
        ((ComplaintAdviceHeadMapper)this.baseMapper).updateById((Object)update);
        StringBuilder builder = new StringBuilder();
        builder.append("\u5904\u7406\u901f\u5ea6\uff1a").append(resultVO.getProcessSpeed()).append(" \u5206<br>");
        builder.append("\u670d\u52a1\u8d28\u91cf\uff1a").append(resultVO.getServiceQuality()).append(" \u5206<br>");
        builder.append("\u670d\u52a1\u6001\u5ea6\uff1a").append(resultVO.getServiceAttitude()).append(" \u5206<br>");
        builder.append("\u5907\u6ce8\uff1a").append(resultVO.getContent());
        ComplaintAdviceRecord record = this.buidRecord(adviceHead.getId(), builder.toString());
        record.setHeadId(resultVO.getId());
        record.setContentType(ContentTypeEnum.OUR.getValue());
        if ("1".equals(adviceHead.getSend())) {
            this.callInterface("sendAdviceRecord", adviceHead.getAdviceStatus(), adviceHead.getProjectId(), record);
        }
        this.complaintAdviceRecordService.save((Object)record);
    }
}

