/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.workorder.entity.WorkOrderHead;
import com.els.modules.workorder.entity.WorkOrderRecord;
import com.els.modules.workorder.service.WorkOrderHeadService;
import com.els.modules.workorder.service.WorkOrderRecordService;
import com.els.modules.workorder.vo.CheckResultVO;
import com.els.modules.workorder.vo.ReplyVO;
import com.els.modules.workorder.vo.ScoreResultVO;
import com.els.modules.workorder.vo.WorkOrderHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/other/workOrderHead"})
@Api(tags={"\u5de5\u5355\u7ba1\u7406"})
public class WorkOrderHeadController
extends BaseController<WorkOrderHead, WorkOrderHeadService> {
    @Autowired
    private WorkOrderHeadService workOrderHeadService;
    @Autowired
    private WorkOrderRecordService workOrderRecordService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(WorkOrderHead workOrderHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)workOrderHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.workOrderHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    public Result<?> queryTabsCount(WorkOrderHead head, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"order_status", "count(0) as participateQuantity"}).lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"order_status");
        List list = ((WorkOrderHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(WorkOrderHead::getOrderStatus, WorkOrderHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "orderStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("workOrderStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "orderStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody WorkOrderHeadVO workOrderHeadPage) {
        WorkOrderHead workOrderHead = new WorkOrderHead();
        BeanUtils.copyProperties((Object)((Object)workOrderHeadPage), (Object)((Object)workOrderHead));
        this.workOrderHeadService.saveMain(workOrderHead, workOrderHeadPage.getWorkOrderRecordList());
        return Result.ok((Object)((Object)workOrderHead));
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody WorkOrderHeadVO workOrderHeadPage) {
        WorkOrderHead workOrderHead = new WorkOrderHead();
        BeanUtils.copyProperties((Object)((Object)workOrderHeadPage), (Object)((Object)workOrderHead));
        this.workOrderHeadService.updateMain(workOrderHead, workOrderHeadPage.getWorkOrderRecordList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.workOrderHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        WorkOrderHead workOrderHead = (WorkOrderHead)((Object)this.workOrderHeadService.getById((Serializable)((Object)id)));
        WorkOrderHeadVO workOrderHeadVO = new WorkOrderHeadVO();
        BeanUtils.copyProperties((Object)((Object)workOrderHead), (Object)((Object)workOrderHeadVO));
        List<WorkOrderRecord> workOrderRecordList = this.workOrderRecordService.selectByMainId(id);
        workOrderHeadVO.setWorkOrderRecordList(workOrderRecordList);
        return Result.ok((Object)((Object)workOrderHeadVO));
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u63d0\u4ea4\u5de5\u5355")
    @ApiOperation(value="\u63d0\u4ea4\u5de5\u5355", notes="\u63d0\u4ea4\u5de5\u5355")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody WorkOrderHead workOrderHead) {
        this.workOrderHeadService.submit(workOrderHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u7b54\u590d\u5de5\u5355")
    @ApiOperation(value="\u7b54\u590d\u5de5\u5355", notes="\u7b54\u590d\u5de5\u5355")
    @PostMapping(value={"/reply"})
    public Result<?> reply(@RequestBody ReplyVO replyVO) {
        WorkOrderRecord record = this.workOrderHeadService.reply(replyVO);
        return Result.ok((Object)((Object)record));
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5173\u95ed\u5de5\u5355")
    @ApiOperation(value="\u5173\u95ed\u5de5\u5355", notes="\u5173\u95ed\u5de5\u5355")
    @PostMapping(value={"/close"})
    public Result<?> close(@RequestBody ReplyVO replyVO) {
        this.workOrderHeadService.close(replyVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5de5\u5355\u9a8c\u8bc1")
    @ApiOperation(value="\u5de5\u5355\u9a8c\u8bc1", notes="\u5de5\u5355\u9a8c\u8bc1")
    @PostMapping(value={"/check"})
    public Result<?> check(@RequestBody CheckResultVO resultVO) {
        this.workOrderHeadService.check(resultVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5de5\u5355\u50ac\u529e")
    @ApiOperation(value="\u5de5\u5355\u50ac\u529e", notes="\u5de5\u5355\u50ac\u529e")
    @PostMapping(value={"/urgent"})
    public Result<?> urgent(@RequestBody ReplyVO replyVO) {
        this.workOrderHeadService.urgent(replyVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5de5\u5355\u8bc4\u5206")
    @ApiOperation(value="\u5de5\u5355\u8bc4\u5206", notes="\u5de5\u5355\u8bc4\u5206")
    @PostMapping(value={"/score"})
    public Result<?> score(@RequestBody ScoreResultVO resultVO) {
        this.workOrderHeadService.score(resultVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u91cd\u53d1\u8bb0\u5f55")
    @ApiOperation(value="\u91cd\u53d1\u8bb0\u5f55", notes="\u91cd\u53d1\u8bb0\u5f55")
    @PostMapping(value={"/retryRecord"})
    public Result<?> retryRecord(@RequestBody WorkOrderRecord record) {
        this.workOrderHeadService.retryRecord(record);
        return this.commonSuccessResult(3);
    }

    @GetMapping(value={"/noToken/test"})
    public Result<?> test() {
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        JSONObject object = new JSONObject();
        object.put("id", (Object)"1531181648429105154");
        object.put("content", (Object)"\u4eca\u665a\u6253\u8001\u864e\uff0c\u4e00\u8d77\u53bb\u597d\u5417\uff01\u597d\u597d\u597d");
        object.put("createBy", (Object)"admin");
        object.put("createTime", (Object)"2022-05-30 17:41:22");
        redisUtil.publish("order-record-topic", (Object)object.toJSONString());
        return Result.ok();
    }
}

