/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.PurchaseMouldMaintain;
import com.els.modules.mould.entity.SaleMouldData;
import com.els.modules.mould.entity.SaleMouldMaintain;
import com.els.modules.mould.enumerate.MaintainStatusEnum;
import com.els.modules.mould.enumerate.MouldStatusEnum;
import com.els.modules.mould.enumerate.TargetStatusEnum;
import com.els.modules.mould.mapper.SaleMouldMaintainMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.PurchaseMouldMaintainService;
import com.els.modules.mould.service.SaleMouldDataService;
import com.els.modules.mould.service.SaleMouldMaintainService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleMouldMaintainServiceImpl
extends BaseServiceImpl<SaleMouldMaintainMapper, SaleMouldMaintain>
implements SaleMouldMaintainService {
    @Autowired
    private PurchaseMouldMaintainService purchaseMouldMaintainService;
    @Autowired
    private SaleMouldDataService saleMouldDataService;
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction
    public void add(SaleMouldMaintain maintain) {
        maintain.setElsAccount(TenantContext.getTenant());
        maintain.setMaintainStatus(MaintainStatusEnum.NEW.getValue());
        String maintainNumber = this.invokeBaseRpcService.getNextCode("mouldMaintain", (Object)maintain);
        maintain.setMaintainNumber(maintainNumber);
        ((SaleMouldMaintainMapper)this.baseMapper).insert((Object)maintain);
        SaleMouldData mouldData = new SaleMouldData();
        mouldData.setId(maintain.getMouldDataId());
        mouldData.setTargetStatus(TargetStatusEnum.MAINTAIN.getValue());
        this.saleMouldDataService.updateById((Object)mouldData);
    }

    @Override
    public void edit(SaleMouldMaintain maintain) {
        maintain.setElsAccount(TenantContext.getTenant());
        maintain.setMaintainStatus(MaintainStatusEnum.NEW.getValue());
        ((SaleMouldMaintainMapper)this.baseMapper).updateById((Object)maintain);
    }

    @Override
    @SrmTransaction
    public void send(SaleMouldMaintain maintain) {
        this.check(maintain);
        maintain.setRelationId(IdWorker.getIdStr());
        maintain.setMaintainStatus(MaintainStatusEnum.SEND.getValue());
        maintain.setSendTime(new Date());
        ((SaleMouldMaintainMapper)this.baseMapper).updateById((Object)maintain);
        this.purchaseMouldMaintainService.add(maintain);
    }

    private void check(SaleMouldMaintain maintain) {
        Assert.isNull((Object)maintain.getSendTime(), (String)I18nUtil.translate((String)"i18n_alert_IhdjtFxqKmhd_fed7f401", (String)"\u5df2\u53d1\u9001\u7684\u5355\u636e\u4e0d\u53ef\u518d\u6b21\u53d1\u9001"));
        Date planStartTime = maintain.getPlanStartTime();
        Assert.notNull((Object)planStartTime, (String)I18nUtil.translate((String)"i18n_field_UtvKKIxOLV_e8edd0f6", (String)"\u9884\u8ba1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        Date planFinishTime = maintain.getPlanFinishTime();
        Assert.notNull((Object)planFinishTime, (String)I18nUtil.translate((String)"i18n_field_UtMLKIxOLV_a746df6f", (String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((boolean)planFinishTime.after(planStartTime), (String)I18nUtil.translate((String)"i18n_alert_UtMLKIlTfUUtvKKI_523b4c62", (String)"\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u9884\u8ba1\u5f00\u59cb\u65f6\u95f4"));
        Assert.hasText((String)maintain.getMaintainWay(), (String)I18nUtil.translate((String)"i18n_alert_LcCKxOLV_7253580", (String)"\u7ef4\u4fee\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)maintain.getMaintainReason(), (String)I18nUtil.translate((String)"i18n_alert_LcCKxOLV_7253580", (String)"\u7ef4\u4fee\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    @Override
    @SrmTransaction
    public void finish(SaleMouldMaintain maintain) {
        Date finishTime = new Date();
        maintain.setMaintainStatus(MaintainStatusEnum.FINISH.getValue());
        maintain.setFinishTime(finishTime);
        ((SaleMouldMaintainMapper)this.baseMapper).updateById((Object)maintain);
        PurchaseMouldMaintain purchaseMaintain = new PurchaseMouldMaintain();
        purchaseMaintain.setId(maintain.getRelationId());
        purchaseMaintain.setMaintainStatus(MaintainStatusEnum.FINISH.getValue());
        purchaseMaintain.setFinishTime(finishTime);
        this.purchaseMouldMaintainService.updateById((Object)purchaseMaintain);
        this.saleMouldDataService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)maintain.getMouldDataId())).set(SaleMouldData::getMouldStatus, (Object)MouldStatusEnum.AVAILABLE.getValue())).set(SaleMouldData::getTargetStatus, null));
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseMouldData::getRelationId, (Object)maintain.getMouldDataId())).set(PurchaseMouldData::getMouldStatus, (Object)MouldStatusEnum.AVAILABLE.getValue())).set(PurchaseMouldData::getTargetStatus, null));
    }

    @Override
    @SrmTransaction
    public void delete(String id) {
        SaleMouldMaintain dbMaintain = (SaleMouldMaintain)((Object)((SaleMouldMaintainMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)MaintainStatusEnum.NEW.getValue().equals(dbMaintain.getMaintainStatus()), (String)I18nUtil.translate((String)"i18n_title_onlyDocumentsNewStatusDeleted", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u5220\u9664"));
        ((SaleMouldMaintainMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.saleMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)dbMaintain.getMouldDataId())).set(SaleMouldData::getTargetStatus, null));
    }
}

