/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.quality.entity.SaleQualityCheckHead;
import com.els.modules.quality.entity.SaleQualityCheckItem;
import com.els.modules.quality.service.SaleQualityCheckHeadService;
import com.els.modules.quality.service.SaleQualityCheckItemService;
import com.els.modules.quality.vo.SaleQualityCheckHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/quality/saleQualityCheckHead"})
@Api(tags={"\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355"})
public class SaleQualityCheckHeadController
extends BaseController<SaleQualityCheckHead, SaleQualityCheckHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleQualityCheckHeadController.class);
    @Autowired
    private SaleQualityCheckHeadService saleQualityCheckHeadService;
    @Autowired
    private SaleQualityCheckItemService saleQualityCheckItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleQualityCheckHead saleQualityCheckHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleQualityCheckHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleQualityCheckHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355-\u6dfb\u52a0", logType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SaleQualityCheckHeadVO saleQualityCheckHeadPage) {
        SaleQualityCheckHead saleQualityCheckHead = new SaleQualityCheckHead();
        BeanUtils.copyProperties((Object)((Object)saleQualityCheckHeadPage), (Object)((Object)saleQualityCheckHead));
        this.saleQualityCheckHeadService.saveMain(saleQualityCheckHead, saleQualityCheckHeadPage.getSaleQualityCheckItemList());
        return Result.ok((Object)((Object)saleQualityCheckHead));
    }

    @AutoLog(value="\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SaleQualityCheckHeadVO saleQualityCheckHeadPage) {
        SaleQualityCheckHead saleQualityCheckHead = new SaleQualityCheckHead();
        BeanUtils.copyProperties((Object)((Object)saleQualityCheckHeadPage), (Object)((Object)saleQualityCheckHead));
        this.saleQualityCheckHeadService.updateMain(saleQualityCheckHead, saleQualityCheckHeadPage.getSaleQualityCheckItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.saleQualityCheckHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.saleQualityCheckHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleQualityCheckHead saleQualityCheckHead = (SaleQualityCheckHead)((Object)this.saleQualityCheckHeadService.getById((Serializable)((Object)id)));
        SaleQualityCheckHeadVO saleQualityCheckHeadVO = new SaleQualityCheckHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleQualityCheckHead), (Object)((Object)saleQualityCheckHeadVO));
        List<SaleQualityCheckItem> saleQualityCheckItemList = this.saleQualityCheckItemService.selectByMainId(id);
        saleQualityCheckHeadVO.setSaleQualityCheckItemList(saleQualityCheckItemList);
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleQualityCheckHeadVO.setSaleAttachmentList(saleAttachmentList);
        return Result.ok((Object)((Object)saleQualityCheckHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355id\u67e5\u8be2\u9500\u552e\u6765\u6599\u68c0\u6d4b\u884c", notes="\u901a\u8fc7\u9500\u552e\u6765\u6599\u68c0\u6d4b\u5355id\u67e5\u8be2\u9500\u552e\u6765\u6599\u68c0\u6d4b\u884c")
    @GetMapping(value={"/querySaleQualityCheckItemByMainId"})
    public Result<?> querySaleQualityCheckItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleQualityCheckItem> saleQualityCheckItemList = this.saleQualityCheckItemService.selectByMainId(id);
        return Result.ok(saleQualityCheckItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(SaleQualityCheckHead saleQualityCheckHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleQualityCheckHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"check_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"check_status");
        List list = ((SaleQualityCheckHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleQualityCheckHead::getCheckStatus, SaleQualityCheckHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "checkStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmCheckStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "checkStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

