/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.workorder.entity.WorkOrderHead;
import com.els.modules.workorder.entity.WorkOrderRecord;
import com.els.modules.workorder.enumerate.ContentTypeEnum;
import com.els.modules.workorder.enumerate.RecordSendStatusEnum;
import com.els.modules.workorder.enumerate.WorkOrderStatusEnum;
import com.els.modules.workorder.service.WorkOrderApiService;
import com.els.modules.workorder.service.WorkOrderHeadService;
import com.els.modules.workorder.service.WorkOrderRecordService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="optWorkOrder")
public class WorkOrderOptServiceImpl
implements WorkOrderApiService {
    @Autowired
    private WorkOrderRecordService workOrderRecordService;
    @Autowired
    private WorkOrderHeadService workOrderHeadService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public String invoke(JSONObject param) {
        String id = param.getString("id");
        String currentStatus = param.getString("currentStatus");
        WorkOrderHead updateHead = new WorkOrderHead();
        updateHead.setId(id);
        updateHead.setOrderStatus(currentStatus);
        updateHead.setOrderHandler(param.getString("recipient"));
        updateHead.setProcessSpeed(param.getBigDecimal("processSpeed"));
        updateHead.setServiceAttitude(param.getBigDecimal("serviceAttitude"));
        updateHead.setServiceQuality(param.getBigDecimal("serviceQuality"));
        updateHead.setOrderSolution(param.getString("orderSolution"));
        if (currentStatus.equals(WorkOrderStatusEnum.FINISHED.getValue()) && param.getBigDecimal("processSpeed") == null) {
            updateHead.setCompleteTime(new Date());
        }
        this.workOrderHeadService.updateById((Object)updateHead);
        WorkOrderRecord orderRecord = (WorkOrderRecord)((Object)JSON.parseObject((String)param.getJSONObject("record").toString(), WorkOrderRecord.class));
        orderRecord.setContentType(ContentTypeEnum.OTHER.getValue());
        orderRecord.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.workOrderRecordService.save((Object)orderRecord);
        JSONObject msgBody = SysUtil.objectToJSON((Object)((Object)orderRecord));
        msgBody.put("id", (Object)orderRecord.getHeadId());
        this.redisUtil.publish("order-record-topic", (Object)msgBody.toJSONString());
        return "SUCCESS";
    }
}

