/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.trial.entity.PurchaseTrialProductionHead;
import com.els.modules.trial.entity.PurchaseTrialProductionItem;
import com.els.modules.trial.entity.SaleTrialProductionHead;
import com.els.modules.trial.entity.SaleTrialProductionItem;
import com.els.modules.trial.enumerate.PurchaseTrialProductionHeadEnum;
import com.els.modules.trial.mapper.PurchaseTrialProductionHeadMapper;
import com.els.modules.trial.mapper.PurchaseTrialProductionItemMapper;
import com.els.modules.trial.mapper.SaleTrialProductionHeadMapper;
import com.els.modules.trial.mapper.SaleTrialProductionItemMapper;
import com.els.modules.trial.service.SaleTrialProductionHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleTrialProductionHeadServiceImpl
extends BaseServiceImpl<SaleTrialProductionHeadMapper, SaleTrialProductionHead>
implements SaleTrialProductionHeadService {
    @Autowired
    private SaleTrialProductionHeadMapper saleTrialProductionHeadMapper;
    @Autowired
    private SaleTrialProductionItemMapper saleTrialProductionItemMapper;
    @Autowired
    private PurchaseTrialProductionHeadMapper purchaseTrialProductionHeadMapper;
    @Autowired
    private PurchaseTrialProductionItemMapper purchaseTrialProductionItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleTrialProductionHead saleTrialProductionHead, List<SaleTrialProductionItem> saleTrialProductionItemList) {
        this.saleTrialProductionHeadMapper.insert((Object)saleTrialProductionHead);
        this.insertData(saleTrialProductionHead, saleTrialProductionItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleTrialProductionHead saleTrialProductionHead, List<SaleTrialProductionItem> saleTrialProductionItemList, List<SaleAttachmentDTO> attachments, Integer type) {
        if (type != null && 2 == type) {
            saleTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.TRIAL_END.getValue());
        }
        this.saleTrialProductionHeadMapper.updateById((Object)saleTrialProductionHead);
        if (saleTrialProductionItemList != null) {
            for (SaleTrialProductionItem entity : saleTrialProductionItemList) {
                this.saleTrialProductionItemMapper.updateById((Object)entity);
            }
        }
        if (attachments != null) {
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleTrialProductionHead.getId());
            for (SaleAttachmentDTO saleAttachment : attachments) {
                this.invokeBaseRpcService.insertSaleAttachment(saleAttachment);
            }
        }
        if (type != null && 2 == type) {
            PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
            purchaseTrialProductionHead.setId(saleTrialProductionHead.getRelationId());
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.TRIAL_END.getValue());
            this.purchaseTrialProductionHeadMapper.updateById((Object)purchaseTrialProductionHead);
            for (SaleTrialProductionItem entity : saleTrialProductionItemList) {
                PurchaseTrialProductionItem purchaseTrialProductionItem = new PurchaseTrialProductionItem();
                purchaseTrialProductionItem.setId(entity.getRelationId());
                purchaseTrialProductionItem.setCheckType(entity.getCheckType());
                purchaseTrialProductionItem.setCheckStandard(entity.getCheckStandard());
                purchaseTrialProductionItem.setCheckMethod(entity.getCheckMethod());
                purchaseTrialProductionItem.setDefectLevel(entity.getDefectLevel());
                purchaseTrialProductionItem.setCheckQuantity(entity.getCheckQuantity());
                purchaseTrialProductionItem.setQualifiedQuantity(entity.getQualifiedQuantity());
                purchaseTrialProductionItem.setDefectiveQuantity(entity.getDefectiveQuantity());
                purchaseTrialProductionItem.setQualified(entity.getQualified());
                purchaseTrialProductionItem.setDefectiveType(entity.getDefectiveType());
                purchaseTrialProductionItem.setDefectiveDesc(entity.getDefectiveDesc());
                purchaseTrialProductionItem.setPrincipal(entity.getPrincipal());
                this.purchaseTrialProductionItemMapper.updateById((Object)purchaseTrialProductionItem);
            }
            if (attachments != null) {
                this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(saleTrialProductionHead.getRelationId());
                for (SaleAttachmentDTO saleAttachment : attachments) {
                    PurchaseAttachmentDTO attachment = (PurchaseAttachmentDTO)SysUtil.copyProperties((Object)saleAttachment, PurchaseAttachmentDTO.class);
                    attachment.setId(null);
                    attachment.setElsAccount(saleTrialProductionHead.getToElsAccount());
                    attachment.setHeadId(saleTrialProductionHead.getRelationId());
                    attachment.setRelationId(saleAttachment.getId());
                    this.invokeBaseRpcService.insertPurchaseAttachment(attachment);
                    saleAttachment.setSendStatus("1");
                    this.invokeBaseRpcService.updateSaleAttachment(saleAttachment);
                }
            }
            super.sendMessage(saleTrialProductionHead.getToElsAccount(), "trialProduction", "recordSupplier", saleTrialProductionHead.getId(), "saleTrialProductionHeadBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{saleTrialProductionHead.getToElsAccount()}));
        }
    }

    private void insertData(SaleTrialProductionHead saleTrialProductionHead, List<SaleTrialProductionItem> saleTrialProductionItemList) {
        for (SaleTrialProductionItem entity : saleTrialProductionItemList) {
            entity.setHeadId(saleTrialProductionHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleTrialProductionHead);
        }
        if (!saleTrialProductionItemList.isEmpty()) {
            this.saleTrialProductionItemMapper.insertBatchSomeColumn(saleTrialProductionItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleTrialProductionItemMapper.deleteByMainId(id);
        this.saleTrialProductionHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleTrialProductionItemMapper.deleteByMainId(serializable.toString());
            this.saleTrialProductionHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public String addByPurchase(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList) {
        String elsAccount = purchaseTrialProductionHead.getElsAccount();
        SaleTrialProductionHead saleTrialHead = new SaleTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHead), (Object)((Object)saleTrialHead));
        saleTrialHead.setRelationId(purchaseTrialProductionHead.getId());
        saleTrialHead.setElsAccount(purchaseTrialProductionHead.getToElsAccount());
        saleTrialHead.setToElsAccount(elsAccount);
        saleTrialHead.setSupplierName(purchaseTrialProductionHead.getSupplierName());
        saleTrialHead.setSupplierCode(purchaseTrialProductionHead.getSupplierCode());
        saleTrialHead.setId(null);
        this.saleTrialProductionHeadMapper.insert((Object)saleTrialHead);
        ArrayList<SaleTrialProductionItem> saleTrialProductionItemList = new ArrayList<SaleTrialProductionItem>();
        for (PurchaseTrialProductionItem purchaseEntity : purchaseTrialProductionItemList) {
            SaleTrialProductionItem saleTrialItem = new SaleTrialProductionItem();
            BeanUtils.copyProperties((Object)((Object)purchaseEntity), (Object)((Object)saleTrialItem));
            saleTrialItem.setHeadId(saleTrialHead.getId());
            saleTrialItem.setRelationId(purchaseEntity.getId());
            saleTrialItem.setElsAccount(purchaseTrialProductionHead.getToElsAccount());
            saleTrialItem.setToElsAccount(elsAccount);
            saleTrialItem.setId(null);
            SysUtil.setSysParam((BaseEntity)saleTrialItem, (BaseEntity)saleTrialHead);
            saleTrialProductionItemList.add(saleTrialItem);
        }
        if (!saleTrialProductionItemList.isEmpty()) {
            this.saleTrialProductionItemMapper.insertBatchSomeColumn(saleTrialProductionItemList);
        }
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseTrialProductionHead.getId());
        ArrayList<SaleAttachmentDTO> saleAttachmentDTOList = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO attachment : attachmentList) {
            SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)attachment, (Object)saleAttachmentDTO);
            saleAttachmentDTO.setRelationId(attachment.getId());
            saleAttachmentDTO.setElsAccount(purchaseTrialProductionHead.getToElsAccount());
            saleAttachmentDTO.setHeadId(saleTrialHead.getId());
            saleAttachmentDTO.setId(null);
            saleAttachmentDTOList.add(saleAttachmentDTO);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
        return saleTrialHead.getId();
    }

    @Override
    public JSONObject getTrialProductionDataById(String id) {
        SaleTrialProductionHead saleTrialProductionHead = (SaleTrialProductionHead)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)saleTrialProductionHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }
}

