/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.minerals.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.minerals.entity.PurchaseMineralsCollect;
import com.els.modules.minerals.entity.PurchaseMineralsDetail;
import com.els.modules.minerals.entity.PurchaseMineralsMetal;
import com.els.modules.minerals.entity.PurchaseMineralsSupplier;
import com.els.modules.minerals.entity.SaleMineralsCollect;
import com.els.modules.minerals.entity.SaleMineralsDetail;
import com.els.modules.minerals.entity.SaleMineralsMetal;
import com.els.modules.minerals.enumerate.MineralsCollectStatusEnum;
import com.els.modules.minerals.enumerate.SmelterStatusEnum;
import com.els.modules.minerals.mapper.PurchaseMineralsCollectMapper;
import com.els.modules.minerals.service.PurchaseMineralsCollectService;
import com.els.modules.minerals.service.PurchaseMineralsDetailService;
import com.els.modules.minerals.service.PurchaseMineralsMetalService;
import com.els.modules.minerals.service.PurchaseMineralsSupplierService;
import com.els.modules.minerals.service.SaleMineralsCollectService;
import com.els.modules.minerals.service.SaleMineralsDetailService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.util.Asserts;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseMineralsCollectServiceImpl
extends BaseServiceImpl<PurchaseMineralsCollectMapper, PurchaseMineralsCollect>
implements PurchaseMineralsCollectService {
    @Resource
    private PurchaseMineralsMetalService purchaseMineralsMetalService;
    @Resource
    private PurchaseMineralsDetailService purchaseMineralsDetailService;
    @Resource
    private SaleMineralsDetailService saleMineralsDetailService;
    @Resource
    private PurchaseMineralsSupplierService purchaseMineralsSupplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleMineralsCollectService saleMineralsCollectService;
    @Resource
    private CoreInvokeSupplierRpcService coreInvokeSupplierRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseMineralsCollect purchaseMineralsCollect, List<PurchaseMineralsMetal> purchaseMineralsMetalList, List<PurchaseMineralsDetail> purchaseMineralsDetailList, List<PurchaseMineralsSupplier> purchaseMineralsSupplierList, List<PurchaseAttachmentDTO> attachmentList) {
        purchaseMineralsCollect.setCollectStatus(MineralsCollectStatusEnum.NEW.getValue()).setBatchNumber(this.invokeBaseRpcService.getNextCode("mineralsBatch", (Object)purchaseMineralsCollect)).setDataVersion(0);
        super.setHeadDefaultValue((BaseEntity)purchaseMineralsCollect);
        purchaseMineralsCollect.setBusAccount(purchaseMineralsCollect.getElsAccount());
        ((PurchaseMineralsCollectMapper)this.baseMapper).insert((Object)purchaseMineralsCollect);
        this.insertData(purchaseMineralsCollect, purchaseMineralsMetalList, purchaseMineralsDetailList, purchaseMineralsSupplierList, attachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMineralsCollect purchaseMineralsCollect, List<PurchaseMineralsMetal> purchaseMineralsMetalList, List<PurchaseMineralsDetail> purchaseMineralsDetailList, List<PurchaseMineralsSupplier> purchaseMineralsSupplierList, List<PurchaseAttachmentDTO> attachmentList) {
        int count = ((PurchaseMineralsCollectMapper)this.baseMapper).updateById((Object)purchaseMineralsCollect);
        this.purchaseMineralsMetalService.deleteByMainId(purchaseMineralsCollect.getId());
        this.purchaseMineralsDetailService.deleteByMainId(purchaseMineralsCollect.getId());
        this.purchaseMineralsSupplierService.deleteByMainId(purchaseMineralsCollect.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseMineralsCollect.getId());
        this.insertData(purchaseMineralsCollect, purchaseMineralsMetalList, purchaseMineralsDetailList, purchaseMineralsSupplierList, attachmentList);
    }

    private void insertData(PurchaseMineralsCollect purchaseMineralsCollect, List<PurchaseMineralsMetal> purchaseMineralsMetalList, List<PurchaseMineralsDetail> purchaseMineralsDetailList, List<PurchaseMineralsSupplier> purchaseMineralsSupplierList, List<PurchaseAttachmentDTO> attachmentList) {
        String busAccount = purchaseMineralsCollect.getElsAccount();
        if (!CollectionUtils.isEmpty(purchaseMineralsMetalList)) {
            for (PurchaseMineralsMetal purchaseMineralsMetal : purchaseMineralsMetalList) {
                purchaseMineralsMetal.setHeadId(purchaseMineralsCollect.getId());
                purchaseMineralsMetal.setBusAccount(busAccount);
                SysUtil.setSysParam((BaseEntity)purchaseMineralsMetal, (BaseEntity)purchaseMineralsCollect);
            }
            this.purchaseMineralsMetalService.saveBatch(purchaseMineralsMetalList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseMineralsDetailList)) {
            for (PurchaseMineralsDetail purchaseMineralsDetail : purchaseMineralsDetailList) {
                purchaseMineralsDetail.setHeadId(purchaseMineralsCollect.getId());
                purchaseMineralsDetail.setBusAccount(busAccount);
                SysUtil.setSysParam((BaseEntity)purchaseMineralsDetail, (BaseEntity)purchaseMineralsCollect);
            }
            this.purchaseMineralsDetailService.saveBatch(purchaseMineralsDetailList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseMineralsSupplierList)) {
            List supplierElsAccounts = purchaseMineralsSupplierList.stream().map(PurchaseMineralsSupplier::getToElsAccount).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(supplierElsAccounts)) {
                throw new ELSBootException("\u4f9b\u5e94\u5546\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            this.log.debug("insertData......\u67e5\u8be2\u4f9b\u5e94\u5546\u72b6\u6001\u53ca\u4fe1\u606f\u5217\u8868\uff0c[supplierElsAccounts]:" + supplierElsAccounts.toString());
            List list = this.coreInvokeSupplierRpcService.selectSupplerList(purchaseMineralsCollect.getElsAccount(), supplierElsAccounts);
            if (CollectionUtils.isEmpty((Collection)list)) {
                this.log.error("insertData......\u67e5\u8be2\u4f9b\u5e94\u5546\u72b6\u6001\u53ca\u4fe1\u606f\u5217\u8868\u7ed3\u679c\u4e3a\u7a7a\uff0c[supplierElsAccounts]:" + supplierElsAccounts.toString());
            }
            Map<String, List<SupplierMasterDataDTO>> supplerMasterDataCusMap = list.stream().collect(Collectors.groupingBy(SupplierMasterDataDTO::getToElsAccount));
            for (PurchaseMineralsSupplier entity : purchaseMineralsSupplierList) {
                List<SupplierMasterDataDTO> smdList = supplerMasterDataCusMap.get(entity.getToElsAccount());
                if (CollectionUtils.isEmpty(smdList)) {
                    throw new ELSBootException("\u4f9b\u5e94\u5546[" + entity.getToElsAccount() + "]\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                SupplierMasterDataDTO supplierMasterDataDTO = smdList.get(0);
                entity.setHeadId(purchaseMineralsCollect.getId());
                entity.setBusAccount(busAccount);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseMineralsCollect);
                this.log.debug("insertData......\u4f9b\u5e94\u5546[" + entity.getToElsAccount() + "]\uff0c[fbk1]:" + entity.getFbk1());
            }
            this.purchaseMineralsSupplierService.saveBatch(purchaseMineralsSupplierList, 2000);
        }
        if (!CollectionUtils.isEmpty(attachmentList)) {
            LoginUser loginUser = SysUtil.getLoginUser();
            for (PurchaseAttachmentDTO entity : attachmentList) {
                entity.setHeadId(purchaseMineralsCollect.getId());
                if (!StringUtils.hasText((String)entity.getFbk10())) {
                    entity.setFbk10(loginUser.getRealname());
                }
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseMineralsCollect);
            }
            String string = JSON.toJSONString(attachmentList);
            List attachments = JSON.parseArray((String)string, PurchaseAttachmentDTO.class);
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachments);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseMineralsMetalService.deleteByMainId(id);
        this.purchaseMineralsDetailService.deleteByMainId(id);
        this.purchaseMineralsSupplierService.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        ((PurchaseMineralsCollectMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseMineralsMetalService.deleteByMainId(serializable.toString());
            this.purchaseMineralsDetailService.deleteByMainId(serializable.toString());
            this.purchaseMineralsSupplierService.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            ((PurchaseMineralsCollectMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void checkBeforePublish(PurchaseMineralsCollect purchaseMineralsCollect, List<PurchaseMineralsSupplier> mineralsSupplierList, List<PurchaseMineralsMetal> mineralsMetalList, List<PurchaseAttachmentDTO> attachmentList) {
        Assert.isNotEmpty(mineralsSupplierList, (String)I18nUtil.translate((String)"i18n_title_selectSupplierInfoTips", (String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\u4fe1\u606f\uff01"));
        Assert.isNotEmpty(mineralsMetalList, (String)I18nUtil.translate((String)"i18n_alert_VSuHWAB_88df96da", (String)"\u8bf7\u6dfb\u52a0\u91d1\u5c5e\u5217\u8868"));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseMineralsCollect purchaseMineralsCollect, List<PurchaseMineralsSupplier> mineralsSupplierList, List<PurchaseMineralsMetal> mineralsMetalList, List<PurchaseAttachmentDTO> attachmentList) {
        purchaseMineralsCollect.setCollectStatus(MineralsCollectStatusEnum.PUBLISH.getValue());
        purchaseMineralsCollect.setDataVersion(null);
        String elsAccount = purchaseMineralsCollect.getElsAccount();
        mineralsSupplierList.forEach(mineralsSupplier -> {
            SaleMineralsCollect saleMineralsCollect = new SaleMineralsCollect();
            String toElsAccount = mineralsSupplier.getToElsAccount();
            String supplierCode = mineralsSupplier.getSupplierCode();
            String supplierName = mineralsSupplier.getSupplierName();
            BeanUtils.copyProperties((Object)((Object)purchaseMineralsCollect), (Object)((Object)saleMineralsCollect));
            saleMineralsCollect.setId(IdWorker.getIdStr());
            saleMineralsCollect.setRelationId(purchaseMineralsCollect.getId());
            saleMineralsCollect.setElsAccount(toElsAccount);
            saleMineralsCollect.setToElsAccount(elsAccount);
            saleMineralsCollect.setSupplierCode(supplierCode);
            saleMineralsCollect.setSupplierName(supplierName);
            saleMineralsCollect.setBatchNumber(purchaseMineralsCollect.getBatchNumber());
            String collectNumber = this.invokeBaseRpcService.getNextCode("mineralsCollect", (Object)saleMineralsCollect);
            saleMineralsCollect.setCollectNumber(collectNumber);
            mineralsSupplier.setCollectNumber(collectNumber);
            ArrayList<SaleMineralsMetal> saleMineralsMetalList = new ArrayList<SaleMineralsMetal>();
            mineralsMetalList.forEach(mineralsMetal -> {
                SaleMineralsMetal saleMineralsMetal = new SaleMineralsMetal();
                BeanUtils.copyProperties((Object)mineralsMetal, (Object)((Object)saleMineralsMetal));
                saleMineralsMetal.setId(IdWorker.getIdStr());
                saleMineralsMetal.setHeadId(saleMineralsCollect.getId());
                saleMineralsMetal.setRelationId(mineralsMetal.getId());
                saleMineralsMetal.setElsAccount(toElsAccount);
                saleMineralsMetal.setToElsAccount(elsAccount);
                saleMineralsMetal.setSupplierCode(supplierCode);
                saleMineralsMetal.setSupplierName(supplierName);
                saleMineralsMetalList.add(saleMineralsMetal);
            });
            ArrayList<SaleAttachmentDTO> saleAttachmentList = new ArrayList<SaleAttachmentDTO>();
            attachmentList.forEach(attachmentDTO -> {
                SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
                BeanUtils.copyProperties((Object)attachmentDTO, (Object)saleAttachmentDTO);
                saleAttachmentDTO.setId(IdWorker.getIdStr());
                saleAttachmentDTO.setHeadId(saleMineralsCollect.getId());
                saleAttachmentList.add(saleAttachmentDTO);
            });
            this.saleMineralsCollectService.saveMain(saleMineralsCollect, saleMineralsMetalList, null, saleAttachmentList);
        });
        this.purchaseMineralsSupplierService.updateBatchById(mineralsSupplierList, 2000);
        this.updateById((Object)purchaseMineralsCollect);
        List toElsAccounts = mineralsSupplierList.stream().map(x -> x.getToElsAccount()).distinct().collect(Collectors.toList());
        super.sendMessage(purchaseMineralsCollect.getElsAccount(), "minerals", "publish", purchaseMineralsCollect.getId(), "mineralsCollectBusDataServiceImpl", toElsAccounts);
    }

    @Override
    public void confirmBatch(List<String> idList) {
        List list = this.purchaseMineralsDetailService.listByIds(idList);
        ArrayList saleList = new ArrayList();
        list.forEach(item -> {
            Asserts.check((boolean)MineralsCollectStatusEnum.SUBMIT.getValue().equals(item.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_xztFjzEIOhbrAWVXVWF_320614a4", (String)"\u90e8\u5206\u5355\u636e\u7684\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u6570\u636e"));
            item.setItemStatus(MineralsCollectStatusEnum.CONFIRM.getValue());
            SaleMineralsDetail saleItem = new SaleMineralsDetail();
            saleItem.setId(item.getRelationId());
            saleItem.setItemStatus(MineralsCollectStatusEnum.CONFIRM.getValue());
            saleList.add(saleItem);
        });
        this.purchaseMineralsDetailService.updateBatchById(list);
        this.saleMineralsDetailService.updateBatchById(saleList);
    }

    @Override
    public void rejectBatch(List<String> idList, String rejectDesc) {
        List purchaseDetailList = this.purchaseMineralsDetailService.listByIds(idList);
        List saleIds = purchaseDetailList.stream().map(PurchaseMineralsDetail::getRelationId).collect(Collectors.toList());
        List saleDetailList = this.saleMineralsDetailService.listByIds(saleIds);
        if (CollectionUtils.isEmpty((Collection)purchaseDetailList) || CollectionUtils.isEmpty((Collection)saleDetailList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        ArrayList saleList = new ArrayList();
        purchaseDetailList.forEach(item -> {
            Asserts.check((MineralsCollectStatusEnum.SUBMIT.getValue().equals(item.getItemStatus()) || MineralsCollectStatusEnum.CONFIRM.getValue().equals(item.getItemStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_xztFjzEIOhbrAWVXVWF_320614a4", (String)"\u90e8\u5206\u5355\u636e\u7684\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u6570\u636e"));
            item.setRejectDesc(rejectDesc);
            item.setItemStatus(MineralsCollectStatusEnum.CANCEL.getValue());
            SaleMineralsDetail saleItem = new SaleMineralsDetail();
            saleItem.setId(item.getRelationId());
            saleItem.setRejectDesc(rejectDesc);
            saleItem.setItemStatus(MineralsCollectStatusEnum.CANCEL.getValue());
            saleList.add(saleItem);
        });
        this.purchaseMineralsDetailService.updateBatchById(purchaseDetailList);
        this.saleMineralsDetailService.updateBatchById(saleList);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleMineralsCollectService.lambdaUpdate().eq(BaseEntity::getId, (Object)((SaleMineralsDetail)((Object)saleDetailList.get(0))).getHeadId())).set(SaleMineralsCollect::getCollectStatus, (Object)MineralsCollectStatusEnum.CANCEL.getValue())).update();
        for (PurchaseMineralsDetail item2 : purchaseDetailList) {
            super.sendMsg(TenantContext.getTenant(), item2.getToElsAccount(), (Object)item2, "", "com/els/modules/minerals", "reject");
        }
    }

    @Override
    public void invalid(String smelterIdentificationCo, String rejectDesc) {
        List saleDetailList;
        List purchaseDetailList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.purchaseMineralsDetailService.lambdaQuery().eq(PurchaseMineralsDetail::getSmelterIdentificationCo, (Object)smelterIdentificationCo)).ne(PurchaseMineralsDetail::getItemStatus, (Object)MineralsCollectStatusEnum.INVALID_LOCAL.getValue())).list();
        if (CollectionUtils.isEmpty((Collection)purchaseDetailList)) {
            return;
        }
        ArrayList saleList = new ArrayList();
        purchaseDetailList.forEach(item -> {
            item.setSmelterStatus(SmelterStatusEnum.INVALID.getValue());
            item.setItemStatus(MineralsCollectStatusEnum.INVALID_LOCAL.getValue());
            item.setRejectDesc(rejectDesc);
            SaleMineralsDetail saleMineralsDetail = new SaleMineralsDetail();
            saleMineralsDetail.setId(item.getRelationId());
            saleMineralsDetail.setSmelterStatus(SmelterStatusEnum.INVALID.getValue());
            saleMineralsDetail.setItemStatus(MineralsCollectStatusEnum.INVALID_LOCAL.getValue());
            saleMineralsDetail.setRejectDesc(rejectDesc);
            saleList.add(saleMineralsDetail);
        });
        this.purchaseMineralsDetailService.saveOrUpdateBatch(purchaseDetailList);
        this.saleMineralsDetailService.saveOrUpdateBatch(saleList);
        List saleDetailIds = purchaseDetailList.stream().map(PurchaseMineralsDetail::getRelationId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(saleDetailIds) && !CollectionUtils.isEmpty((Collection)(saleDetailList = this.saleMineralsDetailService.listByIds(saleDetailIds)))) {
            List saleHeadIds = saleDetailList.stream().map(SaleMineralsDetail::getHeadId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleMineralsCollectService.lambdaUpdate().in(BaseEntity::getId, saleHeadIds)).set(SaleMineralsCollect::getInvalidLocal, (Object)"1")).update();
        }
    }

    @Override
    public void invalids(List<String> collectItemIds, String smelterIdentificationCo, String rejectDesc) {
        List saleDetailList;
        this.log.debug("PurchaseMineralsCollectServiceImpl.invalids......\u5165\u53c2\uff1a[collectItemIds]:" + collectItemIds.toString() + ",[smelterIdentificationCo]:" + smelterIdentificationCo + ",[rejectDesc]:" + rejectDesc);
        List purchaseDetailList = this.purchaseMineralsDetailService.listByIds(collectItemIds);
        if (CollectionUtils.isEmpty((Collection)purchaseDetailList)) {
            throw new ELSBootException("\u52fe\u9009\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6e05\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u5b9e\uff01\uff01");
        }
        Map<String, List<PurchaseMineralsDetail>> collectDetailMap = purchaseDetailList.stream().collect(Collectors.groupingBy(PurchaseMineralsDetail::getSmelterIdentificationCo));
        if (collectDetailMap.size() > 1) {
            throw new ELSBootException("\u8bf7\u4ec5\u52fe\u9009\u51b6\u70bc\u5382ID\u4e3a[" + smelterIdentificationCo + "]\u7684\u6570\u636e");
        }
        for (String key : collectDetailMap.keySet()) {
            if (key.equals(smelterIdentificationCo)) continue;
            throw new ELSBootException("\u8bf7\u52fe\u9009\u51b6\u70bc\u5382ID\u4e3a[" + smelterIdentificationCo + "]\u7684\u6570\u636e");
        }
        ArrayList saleList = new ArrayList();
        purchaseDetailList.forEach(item -> {
            item.setSmelterStatus(SmelterStatusEnum.INVALID.getValue());
            item.setItemStatus(MineralsCollectStatusEnum.INVALID_LOCAL.getValue());
            item.setRejectDesc(rejectDesc);
            SaleMineralsDetail saleMineralsDetail = new SaleMineralsDetail();
            saleMineralsDetail.setId(item.getRelationId());
            saleMineralsDetail.setSmelterStatus(SmelterStatusEnum.INVALID.getValue());
            saleMineralsDetail.setItemStatus(MineralsCollectStatusEnum.INVALID_LOCAL.getValue());
            saleMineralsDetail.setRejectDesc(rejectDesc);
            saleList.add(saleMineralsDetail);
        });
        this.purchaseMineralsDetailService.saveOrUpdateBatch(purchaseDetailList);
        this.saleMineralsDetailService.saveOrUpdateBatch(saleList);
        List saleDetailIds = purchaseDetailList.stream().map(PurchaseMineralsDetail::getRelationId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(saleDetailIds) && !CollectionUtils.isEmpty((Collection)(saleDetailList = this.saleMineralsDetailService.listByIds(saleDetailIds)))) {
            List saleHeadIds = saleDetailList.stream().map(SaleMineralsDetail::getHeadId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleMineralsCollectService.lambdaUpdate().in(BaseEntity::getId, saleHeadIds)).set(SaleMineralsCollect::getInvalidLocal, (Object)"1")).update();
        }
        this.log.debug("PurchaseMineralsCollectServiceImpl.invalids......\u51b6\u70bc\u5382\u4f5c\u5e9f\u7ed3\u675f\uff01[smelterIdentificationCo]:" + smelterIdentificationCo);
    }

    @Override
    @Transactional
    public void updateEndDate(List<String> idList, String endDate) {
        if (!CollectionUtils.isEmpty(idList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchaseMineralsCollect::getEndDate, (Object)endDate)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleMineralsCollectService.lambdaUpdate().in(SaleMineralsCollect::getRelationId, idList)).set(SaleMineralsCollect::getEndDate, (Object)endDate)).update();
        }
    }

    @Override
    @Transactional
    public void toInvalid(List<String> idList, String cancelReason) {
        List list = this.listByIds(idList);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<PurchaseMineralsSupplier> purchaseMineralsSupplierList = this.purchaseMineralsSupplierService.selectByMainId(idList.get(0));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchaseMineralsCollect::getCollectStatus, (Object)MineralsCollectStatusEnum.INVALID.getValue())).set(PurchaseMineralsCollect::getCancelReason, (Object)cancelReason)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseMineralsDetailService.lambdaUpdate().in(PurchaseMineralsDetail::getHeadId, idList)).set(PurchaseMineralsDetail::getItemStatus, (Object)MineralsCollectStatusEnum.INVALID.getValue())).update();
            List batchNumberList = list.stream().map(PurchaseMineralsCollect::getBatchNumber).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(batchNumberList)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleMineralsCollectService.lambdaUpdate().in(SaleMineralsCollect::getBatchNumber, batchNumberList)).set(SaleMineralsCollect::getCollectStatus, (Object)MineralsCollectStatusEnum.INVALID.getValue())).set(SaleMineralsCollect::getCancelReason, (Object)cancelReason)).update();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleMineralsDetailService.lambdaUpdate().in(SaleMineralsDetail::getBatchNumber, batchNumberList)).set(SaleMineralsDetail::getItemStatus, (Object)MineralsCollectStatusEnum.INVALID.getValue())).update();
            }
            for (PurchaseMineralsSupplier item : purchaseMineralsSupplierList) {
                item.setCancelReason(cancelReason);
                super.sendMsg(TenantContext.getTenant(), item.getToElsAccount(), (Object)item, "", "com/els/modules/minerals", "cancel");
            }
        }
    }

    @Override
    public void completeOrderRejectBatch(String collectNumber, String rejectDesc) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(PurchaseMineralsDetail::getCollectNumber, (Object)collectNumber);
        lambdaQueryWrapper.in(PurchaseMineralsDetail::getItemStatus, new Object[]{MineralsCollectStatusEnum.SUBMIT.getValue(), MineralsCollectStatusEnum.CONFIRM.getValue()});
        List purchaseDetailList = this.purchaseMineralsDetailService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)purchaseDetailList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        List saleIds = purchaseDetailList.stream().map(PurchaseMineralsDetail::getRelationId).collect(Collectors.toList());
        List saleDetailList = this.saleMineralsDetailService.listByIds(saleIds);
        if (CollectionUtils.isEmpty((Collection)purchaseDetailList) || CollectionUtils.isEmpty((Collection)saleDetailList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        ArrayList saleList = new ArrayList();
        purchaseDetailList.forEach(item -> {
            Asserts.check((MineralsCollectStatusEnum.SUBMIT.getValue().equals(item.getItemStatus()) || MineralsCollectStatusEnum.CONFIRM.getValue().equals(item.getItemStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_xztFjzEIOhbrAWVXVWF_320614a4", (String)"\u90e8\u5206\u5355\u636e\u7684\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u6570\u636e"));
            item.setRejectDesc(rejectDesc);
            item.setItemStatus(MineralsCollectStatusEnum.CANCEL.getValue());
            SaleMineralsDetail saleItem = new SaleMineralsDetail();
            saleItem.setId(item.getRelationId());
            saleItem.setRejectDesc(rejectDesc);
            saleItem.setItemStatus(MineralsCollectStatusEnum.CANCEL.getValue());
            saleList.add(saleItem);
        });
        this.purchaseMineralsDetailService.updateBatchById(purchaseDetailList);
        this.saleMineralsDetailService.updateBatchById(saleList);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleMineralsCollectService.lambdaUpdate().eq(BaseEntity::getId, (Object)((SaleMineralsDetail)((Object)saleDetailList.get(0))).getHeadId())).set(SaleMineralsCollect::getCollectStatus, (Object)MineralsCollectStatusEnum.CANCEL.getValue())).update();
        super.sendMsg(TenantContext.getTenant(), ((PurchaseMineralsDetail)((Object)purchaseDetailList.get(0))).getToElsAccount(), purchaseDetailList.get(0), "", "com/els/modules/minerals", "reject");
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseMineralsCollect purchaseMineralsCollect = (PurchaseMineralsCollect)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)purchaseMineralsCollect));
        if (ObjectUtil.isEmpty((Object)((Object)purchaseMineralsCollect))) {
            SaleMineralsCollect saleMineralsCollect = (SaleMineralsCollect)((Object)this.saleMineralsCollectService.getById((Serializable)((Object)id)));
            result = Result.ok((Object)((Object)saleMineralsCollect));
        }
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }
}

