/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rohs.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.rohs.entity.PurchaseRohsCollect;
import com.els.modules.rohs.entity.SaleRohsCollect;
import com.els.modules.rohs.service.PurchaseRohsCollectService;
import com.els.modules.rohs.service.SaleRohsCollectService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service(value="rohsReportExpDataJob")
public class RohsReportExpDataJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(RohsReportExpDataJob.class);
    @Autowired
    private SaleRohsCollectService saleRohsCollectService;
    @Autowired
    private PurchaseRohsCollectService purchaseRohsCollectService;

    public void execute(String parameter) {
        StopWatch sw = new StopWatch();
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String tenantId = StrUtil.isBlank((CharSequence)paramObj.getString("elsAccount")) ? "100000" : paramObj.getString("elsAccount");
        TenantContext.setTenant((String)tenantId);
        sw.start("\u66f4\u65b0\u6536\u96c6\u5355\u6709\u6548\u671f\u5f00\u59cb");
        this.saleRohsCollectService.updateMaterialDesc();
        sw.stop();
        sw.start("\u66f4\u65b0\u8fd1\u6548\u671f\u68c0\u6d4b\u62a5\u544a\u7684\u6536\u96c6\u5355");
        List<SaleRohsCollect> recentlyExpList = this.saleRohsCollectService.selectRecentlyExpList();
        this.updateMethod(recentlyExpList, "5");
        sw.stop();
        sw.start("\u66f4\u65b0\u5931\u6548\u68c0\u6d4b\u62a5\u544a\u7684\u6536\u96c6\u5355");
        List<SaleRohsCollect> hasExpList = this.saleRohsCollectService.selectHasExpList();
        this.updateMethod(hasExpList, "6");
        sw.stop();
        log.info(sw.prettyPrint());
    }

    private void updateMethod(List<SaleRohsCollect> updateList, String collectStateExpire) {
        ArrayList<SaleRohsCollect> saleUpdateList = new ArrayList<SaleRohsCollect>();
        ArrayList<PurchaseRohsCollect> purchaseUpdateList = new ArrayList<PurchaseRohsCollect>();
        for (SaleRohsCollect e : updateList) {
            SaleRohsCollect up = new SaleRohsCollect();
            up.setId(e.getId());
            up.setCollectStatus(collectStateExpire);
            saleUpdateList.add(up);
            PurchaseRohsCollect up2 = new PurchaseRohsCollect();
            up2.setId(e.getRelationid());
            up2.setCollectStatus(collectStateExpire);
            purchaseUpdateList.add(up2);
        }
        if (saleUpdateList.size() > 0) {
            this.saleRohsCollectService.updateBatchById(saleUpdateList);
            this.purchaseRohsCollectService.updateBatchById(purchaseUpdateList);
        }
    }
}

