/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.minerals.excel;

import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="mineralsSupplierExcelServiceImpl")
public class MineralsSupplierExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SupplierMasterDataRpcService supplierMasterDataRpcService;

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        return null;
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ExcelByConfigDTO excelByConfigDTO = excelImportDTO.getExcelByConfigDTO();
        List configItemList = this.getTemplate(excelByConfigDTO).getTemplateConfigItemList();
        for (Map data : dataList) {
            List finalEditColumn = configItemList.stream().map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
            data.forEach((key, value) -> {
                if (!finalEditColumn.contains(key)) {
                    data.put(key, null);
                }
            });
            String toElsAccount = (String)data.get("toElsAccount");
            if (!StringUtils.isNotBlank((CharSequence)toElsAccount)) continue;
            TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
            List supplierList = this.supplierMasterDataRpcService.listByElsAccount(Collections.singletonList(toElsAccount));
            if (null == supplierList || supplierList.isEmpty()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXWWWWWWWxMK_378a90d2", (String)"\u4f9b\u5e94\u5546\uff1a[${0}]\u4e0d\u5b58\u5728;", (String[])new String[]{toElsAccount}));
            }
            data.put("supplierCode", ((SupplierMasterDataDTO)supplierList.get(0)).getSupplierCode());
            data.put("supplierName", ((SupplierMasterDataDTO)supplierList.get(0)).getSupplierName());
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

