/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.modules.report.entity.ElsQuantityToleranceSetting;
import com.els.modules.report.mapper.ElsQuantityToleranceSettingMapper;
import com.els.modules.report.service.ElsQuantityToleranceSettingService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsQuantityToleranceSettingServiceImpl
extends ServiceImpl<ElsQuantityToleranceSettingMapper, ElsQuantityToleranceSetting>
implements ElsQuantityToleranceSettingService {
    @Autowired
    private ElsQuantityToleranceSettingMapper elsQuantityToleranceSettingMapper;

    @Override
    public void saveElsQuantityToleranceSetting(ElsQuantityToleranceSetting elsQuantityToleranceSetting) {
        this.checkQuantityToleranceSetting(elsQuantityToleranceSetting);
        ((ElsQuantityToleranceSettingMapper)this.baseMapper).insert((Object)elsQuantityToleranceSetting);
    }

    @Override
    public void updateElsQuantityToleranceSetting(ElsQuantityToleranceSetting elsQuantityToleranceSetting) {
        this.checkQuantityToleranceSetting(elsQuantityToleranceSetting);
        int count = ((ElsQuantityToleranceSettingMapper)this.baseMapper).updateById((Object)elsQuantityToleranceSetting);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delElsQuantityToleranceSetting(String id) {
        ((ElsQuantityToleranceSettingMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsQuantityToleranceSetting(List<String> idList) {
        ((ElsQuantityToleranceSettingMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private void checkQuantityToleranceSetting(ElsQuantityToleranceSetting elsQuantityToleranceSetting) {
        String toElsAccount = elsQuantityToleranceSetting.getToElsAccount();
        LambdaQueryWrapper elsQuantityToleranceSettingLambdaQueryWrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)toElsAccount)) {
            elsQuantityToleranceSettingLambdaQueryWrapper.eq(ElsQuantityToleranceSetting::getToElsAccount, (Object)toElsAccount);
            if (StrUtil.isNotBlank((CharSequence)elsQuantityToleranceSetting.getId())) {
                elsQuantityToleranceSettingLambdaQueryWrapper.ne(BaseEntity::getId, (Object)elsQuantityToleranceSetting.getId());
            } else {
                elsQuantityToleranceSettingLambdaQueryWrapper.last("and( id is not null )");
            }
            List elsTimeToleranceSettings = this.elsQuantityToleranceSettingMapper.selectList((Wrapper)elsQuantityToleranceSettingLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)elsTimeToleranceSettings)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXWWWWWIOGRrWRcmWxOVBGRW_e5f3af71", (String)"\u4f9b\u5e94\u5546:${0}\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u6570\u91cf\u5bb9\u5dee\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e!", (String[])new String[]{toElsAccount}));
            }
        } else if (StrUtil.isBlank((CharSequence)toElsAccount) && StrUtil.isNotBlank((CharSequence)elsQuantityToleranceSetting.getAccountGroup())) {
            elsQuantityToleranceSettingLambdaQueryWrapper.eq(ElsQuantityToleranceSetting::getAccountGroup, (Object)elsQuantityToleranceSetting.getAccountGroup());
            if (StrUtil.isNotBlank((CharSequence)elsQuantityToleranceSetting.getId())) {
                elsQuantityToleranceSettingLambdaQueryWrapper.ne(BaseEntity::getId, (Object)elsQuantityToleranceSetting.getId());
            } else {
                elsQuantityToleranceSettingLambdaQueryWrapper.last("and( id is not null )");
            }
            elsQuantityToleranceSettingLambdaQueryWrapper.last("and (to_els_account is null or to_els_account='' )");
            List elsTimeToleranceSettings = this.elsQuantityToleranceSettingMapper.selectList((Wrapper)elsQuantityToleranceSettingLambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)elsTimeToleranceSettings)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eDVWWWWWIOGRrWRcmWxOVBGRW_1e2627f7", (String)"\u8d26\u6237\u7ec4:${0}\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u6570\u91cf\u5bb9\u5dee\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e!", (String[])new String[]{elsQuantityToleranceSetting.getAccountGroup()}));
            }
        }
    }
}

