/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rohsreport.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.SaleAttachmentRpcService;
import com.els.modules.rohs.entity.SaleRohsCollectAttachment;
import com.els.modules.rohs.mapper.SaleRohsCollectAttachmentMapper;
import com.els.modules.rohsreport.entity.SaleRohsReportHead;
import com.els.modules.rohsreport.entity.SaleRohsReportItem;
import com.els.modules.rohsreport.mapper.SaleRohsReportHeadMapper;
import com.els.modules.rohsreport.mapper.SaleRohsReportItemMapper;
import com.els.modules.rohsreport.service.SaleRohsReportHeadService;
import com.els.modules.rohsreport.service.SaleRohsReportItemService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleRohsReportHeadServiceImpl
extends BaseServiceImpl<SaleRohsReportHeadMapper, SaleRohsReportHead>
implements SaleRohsReportHeadService {
    @Autowired
    private SaleRohsReportHeadMapper saleRohsReportHeadMapper;
    @Autowired
    private SaleRohsReportItemMapper saleRohsReportItemMapper;
    @Autowired
    private SaleRohsReportItemService saleRohsReportItemService;
    @Autowired
    private SaleAttachmentRpcService saleAttachmentRpcService;
    @Autowired
    private SaleRohsCollectAttachmentMapper saleRohsCollectAttachmentMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleRohsReportHead saleRohsReportHead, List<SaleRohsReportItem> saleRohsReportItemList, List<SaleAttachmentDTO> saleRohsReportAttachmentList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SaleRohsReportHead::getJcNumber, (Object)saleRohsReportHead.getJcNumber())).ne(SaleRohsReportHead::getJcState, (Object)"9");
        List saleRohsReportHeads = this.saleRohsReportHeadMapper.selectList((Wrapper)queryWrapper);
        if (saleRohsReportHeads.size() > 0) {
            throw new ELSBootException("\u68c0\u6d4b\u62a5\u544a\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        super.setHeadDefaultValue((BaseEntity)saleRohsReportHead);
        saleRohsReportHead.setDeleted(CommonConstant.DEL_FLAG_0);
        saleRohsReportHead.setJcState("0");
        if (saleRohsReportAttachmentList.size() > 0) {
            SaleAttachmentDTO saleAttachmentDTO = saleRohsReportAttachmentList.get(0);
            saleRohsReportHead.setJcFileName(saleAttachmentDTO.getFileName());
            saleRohsReportHead.setJcFileId(saleAttachmentDTO.getId());
            saleRohsReportHead.setJcFilePath(saleAttachmentDTO.getFilePath());
        }
        this.saleRohsReportHeadMapper.insert((Object)saleRohsReportHead);
        this.insertData(saleRohsReportHead, saleRohsReportItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleRohsReportHead saleRohsReportHead, List<SaleRohsReportItem> saleRohsReportItemList, List<SaleAttachmentDTO> saleRohsReportAttachmentList, List<SaleAttachmentDTO> smAttachmentList) {
        if (saleRohsReportAttachmentList.size() > 0) {
            SaleAttachmentDTO saleAttachmentDTO = saleRohsReportAttachmentList.get(0);
            saleRohsReportHead.setJcFileName(saleAttachmentDTO.getFileName());
            saleRohsReportHead.setJcFileId(saleAttachmentDTO.getId());
            saleRohsReportHead.setJcFilePath(saleAttachmentDTO.getFilePath());
        }
        this.saleRohsReportHeadMapper.updateById((Object)saleRohsReportHead);
        this.saleRohsReportItemMapper.deleteByMainId(saleRohsReportHead.getId());
        this.insertData(saleRohsReportHead, saleRohsReportItemList);
        this.saleAttachmentRpcService.deleteByMainId(saleRohsReportHead.getId());
        if (CollUtil.isNotEmpty(smAttachmentList)) {
            this.saleAttachmentRpcService.insertBatchSomeColumn(smAttachmentList);
        }
        if (CollUtil.isNotEmpty(saleRohsReportAttachmentList)) {
            this.saleAttachmentRpcService.insertBatchSomeColumn(saleRohsReportAttachmentList);
        }
    }

    private void insertData(SaleRohsReportHead saleRohsReportHead, List<SaleRohsReportItem> saleRohsReportItemList) {
        if (!CollectionUtils.isEmpty(saleRohsReportItemList)) {
            for (SaleRohsReportItem entity : saleRohsReportItemList) {
                entity.setId(IdWorker.getIdStr());
                entity.setHeadId(saleRohsReportHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleRohsReportHead);
            }
            if (!saleRohsReportItemList.isEmpty()) {
                this.saleRohsReportItemService.saveBatch(saleRohsReportItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleAttachmentRpcService.deleteByMainId(id);
        this.saleRohsReportItemMapper.deleteByMainId(id);
        this.saleRohsReportHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleAttachmentRpcService.deleteByMainId(serializable.toString());
            this.saleRohsReportItemMapper.deleteByMainId(serializable.toString());
            this.saleRohsReportHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void invalid(String id) {
        List<SaleRohsCollectAttachment> saleRohsCollectAttachmentList;
        SaleRohsReportHead saleRohsReportHead = (SaleRohsReportHead)((Object)this.saleRohsReportHeadMapper.selectById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)saleRohsReportHead.getJcNumber()) && (saleRohsCollectAttachmentList = this.saleRohsCollectAttachmentMapper.selectByJcNumber(saleRohsReportHead.getJcNumber())).size() > 0 && saleRohsCollectAttachmentList.stream().filter(x -> !"\u62a5\u544a\u5df2\u5728\u6536\u96c6\u5355\u4e2d\u9000\u56de".equals(x.getFbk4())).collect(Collectors.toList()).size() > 0) {
            throw new ELSBootException("\u68c0\u6d4b\u62a5\u544a\u5df2\u5728\u5176\u4ed6\u6536\u96c6\u5355\u4e2d\u88ab\u5f15\u7528\uff0c\u7981\u6b62\u5e9f\u6b62\uff01");
        }
        saleRohsReportHead.setJcState("9");
        this.saleRohsReportHeadMapper.updateById((Object)saleRohsReportHead);
    }

    @Override
    public void publish(SaleRohsReportHead saleRohsReportHead, List<SaleRohsReportItem> saleRohsReportItemList, List<SaleAttachmentDTO> saleRohsReportAttachmentList, List<SaleAttachmentDTO> smAttachmentList) {
        if (saleRohsReportAttachmentList.size() > 0) {
            SaleAttachmentDTO saleAttachmentDTO = saleRohsReportAttachmentList.get(0);
            saleRohsReportHead.setJcFileName(saleAttachmentDTO.getFileName());
            saleRohsReportHead.setJcFileId(saleAttachmentDTO.getId());
            saleRohsReportHead.setJcFilePath(saleAttachmentDTO.getFilePath());
        }
        saleRohsReportHead.setJcState("1");
        this.saleRohsReportHeadMapper.updateById((Object)saleRohsReportHead);
        this.saleRohsReportItemMapper.deleteByMainId(saleRohsReportHead.getId());
        this.insertData(saleRohsReportHead, saleRohsReportItemList);
        this.saleAttachmentRpcService.deleteByMainId(saleRohsReportHead.getId());
        if (CollUtil.isNotEmpty(smAttachmentList)) {
            this.saleAttachmentRpcService.insertBatchSomeColumn(smAttachmentList);
        }
        if (CollUtil.isNotEmpty(saleRohsReportAttachmentList)) {
            this.saleAttachmentRpcService.insertBatchSomeColumn(saleRohsReportAttachmentList);
        }
    }
}

