/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.Html2Text;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.trial.entity.PurchaseTrialProductionHead;
import com.els.modules.trial.entity.PurchaseTrialProductionItem;
import com.els.modules.trial.enumerate.PurchaseTrialProductionHeadEnum;
import com.els.modules.trial.service.PurchaseTrialProductionHeadService;
import com.els.modules.trial.service.PurchaseTrialProductionItemService;
import com.els.modules.trial.vo.PurchaseTrialProductionHeadRecordVO;
import com.els.modules.trial.vo.PurchaseTrialProductionHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trial/purchaseTrialProductionHead"})
@Api(tags={"\u91c7\u8d2d\u8bd5\u5236\u5934\u4fe1\u606f"})
@BusinessModule(module="trialProduction")
public class PurchaseTrialProductionHeadController
extends BaseController<PurchaseTrialProductionHead, PurchaseTrialProductionHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTrialProductionHeadController.class);
    @Autowired
    private PurchaseTrialProductionHeadService purchaseTrialProductionHeadService;
    @Autowired
    private PurchaseTrialProductionItemService purchaseTrialProductionItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="trialProduction")
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:list"})
    public Result<?> queryPageList(PurchaseTrialProductionHead purchaseTrialProductionHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTrialProductionHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseTrialProductionHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6279\u91cf\u8bd5\u5236-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:add"})
    public Result<?> add(@RequestBody PurchaseTrialProductionHeadVO purchaseTrialProductionHeadPage) {
        Assert.hasText((String)purchaseTrialProductionHeadPage.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)purchaseTrialProductionHeadPage.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHeadPage), (Object)((Object)purchaseTrialProductionHead));
        this.purchaseTrialProductionHeadService.saveMain(purchaseTrialProductionHead, purchaseTrialProductionHeadPage.getPurchaseTrialProductionItemList(), purchaseTrialProductionHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseTrialProductionHead));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6279\u91cf\u8bd5\u5236-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:edit"})
    public Result<?> edit(@RequestBody PurchaseTrialProductionHeadVO purchaseTrialProductionHeadPage) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHeadPage), (Object)((Object)purchaseTrialProductionHead));
        this.purchaseTrialProductionHeadService.updateMain(purchaseTrialProductionHead, purchaseTrialProductionHeadPage.getPurchaseTrialProductionItemList(), purchaseTrialProductionHeadPage.getPurchaseAttachmentList(), 1);
        return this.queryById(purchaseTrialProductionHead.getId(), null);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6279\u91cf\u8bd5\u5236-\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:submit"})
    public Result<?> submit(@RequestBody PurchaseTrialProductionHeadVO purchaseTrialProductionHeadPage) {
        purchaseTrialProductionHeadPage.setTrialStatus(PurchaseTrialProductionHeadEnum.TRIAL_ING.getValue());
        PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHeadPage), (Object)((Object)purchaseTrialProductionHead));
        this.purchaseTrialProductionHeadService.updateMain(purchaseTrialProductionHead, purchaseTrialProductionHeadPage.getPurchaseTrialProductionItemList(), purchaseTrialProductionHeadPage.getPurchaseAttachmentList(), 2);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6279\u91cf\u8bd5\u5236-\u8bd5\u5236\u603b\u7ed3\u4fdd\u5b58")
    @ApiOperation(value="\u7ed3\u679c\u5f55\u5165", notes="\u8bd5\u5236\u603b\u7ed3-\u4fdd\u5b58")
    @PostMapping(value={"/record"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:record"})
    public Result<?> record(@RequestBody PurchaseTrialProductionHeadVO purchaseTrialProductionHeadPage) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHeadPage), (Object)((Object)purchaseTrialProductionHead));
        purchaseTrialProductionHead.setSampleQuantity(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getSampleQuantity());
        purchaseTrialProductionHead.setQualifiedQuantity(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getQualifiedQuantity());
        purchaseTrialProductionHead.setDefectiveQuantity(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getDefectiveQuantity());
        purchaseTrialProductionHead.setQualifiedRate(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getQualifiedRate());
        purchaseTrialProductionHead.setQualified(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getQualified());
        purchaseTrialProductionHead.setTrialResult(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getTrialResult());
        purchaseTrialProductionHead.setResultAudit(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getResultAudit());
        purchaseTrialProductionHead.setTrialResultDesc(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getTrialResultDesc());
        purchaseTrialProductionHead.setTrialResultNumber(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getTrialResultNumber());
        this.purchaseTrialProductionHeadService.record(purchaseTrialProductionHead, purchaseTrialProductionHeadPage.getPurchaseTrialProductionItemList(), purchaseTrialProductionHeadPage.getPurchaseAttachmentList(), 1);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6279\u91cf\u8bd5\u5236-\u8bd5\u5236\u603b\u7ed3\u63d0\u4ea4")
    @ApiOperation(value="\u7ed3\u679c\u5f55\u5165", notes="\u8bd5\u5236\u603b\u7ed3\u63d0\u4ea4")
    @PostMapping(value={"/recordSubmit"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:recordSubmit"})
    public Result<?> recordSubmit(@RequestBody PurchaseTrialProductionHeadVO purchaseTrialProductionHeadPage) {
        purchaseTrialProductionHeadPage.setTrialStatus(PurchaseTrialProductionHeadEnum.TRIAL_END.getValue());
        PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHeadPage), (Object)((Object)purchaseTrialProductionHead));
        purchaseTrialProductionHead.setSampleQuantity(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getSampleQuantity());
        purchaseTrialProductionHead.setQualifiedQuantity(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getQualifiedQuantity());
        purchaseTrialProductionHead.setDefectiveQuantity(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getDefectiveQuantity());
        purchaseTrialProductionHead.setQualifiedRate(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getQualifiedRate());
        purchaseTrialProductionHead.setQualified(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getQualified());
        purchaseTrialProductionHead.setTrialResult(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getTrialResult());
        purchaseTrialProductionHead.setResultAudit(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getResultAudit());
        purchaseTrialProductionHead.setTrialResultDesc(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getTrialResultDesc());
        purchaseTrialProductionHead.setTrialResultNumber(purchaseTrialProductionHeadPage.getPurchaseTrialProductionRecord().getTrialResultNumber());
        this.purchaseTrialProductionHeadService.record(purchaseTrialProductionHead, purchaseTrialProductionHeadPage.getPurchaseTrialProductionItemList(), purchaseTrialProductionHeadPage.getPurchaseAttachmentList(), 2);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6279\u91cf\u8bd5\u5236-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseTrialProductionHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6279\u91cf\u8bd5\u5236-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseTrialProductionHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:query"})
    @PermissionDataView(businessType="trialProduction")
    public Result<?> queryById(@RequestParam(name="id") String id, @RequestParam(name="type", required=false) String type) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)id)));
        if (!StrUtil.isBlank((CharSequence)type) && "view".equals(type)) {
            purchaseTrialProductionHead.setSampleStatus(Html2Text.getContent((String)purchaseTrialProductionHead.getSampleStatus()));
        }
        PurchaseTrialProductionHeadVO purchaseTrialProductionHeadVO = new PurchaseTrialProductionHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseTrialProductionHead), (Object)((Object)purchaseTrialProductionHeadVO));
        List<PurchaseTrialProductionItem> purchaseTrialProductionItemList = this.purchaseTrialProductionItemService.selectByMainId(id);
        purchaseTrialProductionHeadVO.setPurchaseTrialProductionItemList(purchaseTrialProductionItemList);
        PurchaseTrialProductionHeadRecordVO trialProductionHeadRecordVO = new PurchaseTrialProductionHeadRecordVO();
        trialProductionHeadRecordVO.setSampleQuantity(purchaseTrialProductionHead.getSampleQuantity());
        trialProductionHeadRecordVO.setQualifiedQuantity(purchaseTrialProductionHead.getQualifiedQuantity());
        trialProductionHeadRecordVO.setDefectiveQuantity(purchaseTrialProductionHead.getDefectiveQuantity());
        trialProductionHeadRecordVO.setQualifiedRate(purchaseTrialProductionHead.getQualifiedRate());
        trialProductionHeadRecordVO.setQualified(purchaseTrialProductionHead.getQualified());
        trialProductionHeadRecordVO.setTrialResult(purchaseTrialProductionHead.getTrialResult());
        trialProductionHeadRecordVO.setResultAudit(purchaseTrialProductionHead.getResultAudit());
        trialProductionHeadRecordVO.setTrialResultDesc(purchaseTrialProductionHead.getTrialResultDesc());
        trialProductionHeadRecordVO.setTrialResultNumber(purchaseTrialProductionHeadVO.getTrialResultNumber());
        trialProductionHeadRecordVO.setTrialStartDate(purchaseTrialProductionHeadVO.getTrialStartDate());
        trialProductionHeadRecordVO.setTrialEndDate(purchaseTrialProductionHead.getTrialEndDate());
        purchaseTrialProductionHeadVO.setPurchaseTrialProductionRecord(trialProductionHeadRecordVO);
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseTrialProductionHeadVO.setPurchaseAttachmentList(attachmentList);
        return Result.ok((Object)((Object)purchaseTrialProductionHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u8bd5\u5236\u5934\u4fe1\u606fid\u67e5\u8be2\u91c7\u8d2d\u8bd5\u5236\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u91c7\u8d2d\u8bd5\u5236\u5934\u4fe1\u606fid\u67e5\u8be2\u91c7\u8d2d\u8bd5\u5236\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseTrialProductionItemByMainId"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:query"})
    public Result<?> queryPurchaseTrialProductionItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseTrialProductionItem> purchaseTrialProductionItemList = this.purchaseTrialProductionItemService.selectByMainId(id);
        return Result.ok(purchaseTrialProductionItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="trialProduction")
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:list"})
    public Result<?> queryTabsCount(PurchaseTrialProductionHead purchaseTrialProductionHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"trial_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"trial_status");
        List list = ((PurchaseTrialProductionHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseTrialProductionHead::getTrialStatus, PurchaseTrialProductionHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "trialStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("trialStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"1", "2", "3", "4"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "trialStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copy/{id}"})
    @RequiresPermissions(value={"trialProduction#purchaseTrialProductionHead:copy"})
    public Result<?> copy(@PathVariable String id) {
        this.purchaseTrialProductionHeadService.copy(id);
        return Result.ok();
    }
}

