/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.workorder.entity.WorkOrderRecord;
import com.els.modules.workorder.enumerate.ContentTypeEnum;
import com.els.modules.workorder.enumerate.RecordSendStatusEnum;
import com.els.modules.workorder.service.WorkOrderApiService;
import com.els.modules.workorder.service.WorkOrderRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sendRecord")
public class WorkOrderRecordServiceImpl
implements WorkOrderApiService {
    @Autowired
    private WorkOrderRecordService workOrderRecordService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public String invoke(JSONObject param) {
        WorkOrderRecord orderRecord = (WorkOrderRecord)((Object)JSON.parseObject((String)param.getJSONObject("record").toString(), WorkOrderRecord.class));
        orderRecord.setContentType(ContentTypeEnum.OTHER.getValue());
        orderRecord.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.workOrderRecordService.save((Object)orderRecord);
        JSONObject msgBody = SysUtil.objectToJSON((Object)((Object)orderRecord));
        msgBody.put("id", (Object)orderRecord.getHeadId());
        this.redisUtil.publish("order-record-topic", (Object)msgBody.toJSONString());
        return "SUCCESS";
    }
}

