/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.massProduction.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.massProduction.entity.PurchaseMassProdHead;
import com.els.modules.massProduction.entity.PurchaseMassProdPpapItem;
import com.els.modules.massProduction.entity.PurchaseMassProdSampleItem;
import com.els.modules.massProduction.entity.SaleMassProdHead;
import com.els.modules.massProduction.entity.SaleMassProdPpapItem;
import com.els.modules.massProduction.enums.I18nMassProdMsgEnum;
import com.els.modules.massProduction.enums.MassProdEnum;
import com.els.modules.massProduction.mapper.PurchaseMassProdHeadMapper;
import com.els.modules.massProduction.mapper.PurchaseMassProdPpapItemMapper;
import com.els.modules.massProduction.mapper.PurchaseMassProdSampleItemMapper;
import com.els.modules.massProduction.mapper.SaleMassProdHeadMapper;
import com.els.modules.massProduction.mapper.SaleMassProdPpapItemMapper;
import com.els.modules.massProduction.rpc.service.MassProductBaseRpcService;
import com.els.modules.massProduction.rpc.service.PurcMaterSourRpcService;
import com.els.modules.massProduction.service.PurchaseMassProdHeadService;
import com.els.modules.massProduction.service.PurchaseMassProdPpapItemService;
import com.els.modules.massProduction.service.PurchaseMassProdSampleItemService;
import com.els.modules.massProduction.service.SaleMassProdPpapItemService;
import com.els.modules.massProduction.vo.PurchaseMassProdConfirmVo;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.api.enumerate.MaterialSourceTypeApiEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseMassProdHeadServiceImpl
extends BaseServiceImpl<PurchaseMassProdHeadMapper, PurchaseMassProdHead>
implements PurchaseMassProdHeadService {
    @Resource
    private PurchaseMassProdHeadMapper purchaseMassProdHeadMapper;
    @Resource
    private PurchaseMassProdPpapItemMapper ppapItemMapper;
    @Resource
    private PurchaseMassProdPpapItemService purchaseMassProdPpapItemService;
    @Resource
    private PurchaseMassProdSampleItemMapper purchaseMassProdSampleItemMapper;
    @Resource
    private PurchaseMassProdSampleItemService purchaseMassProdSampleItemService;
    @Resource
    private SaleMassProdHeadMapper saleMassProdHeadMapper;
    @Resource
    private PurcMaterSourRpcService sourRpcService;
    @Resource
    private SaleMassProdPpapItemMapper saleMassProdPpapItemMapper;
    @Resource
    private SaleMassProdPpapItemService saleMassProdPpapItemService;
    @Autowired
    private MassProductBaseRpcService baseRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    private void delMassProdItem(String headId) {
        this.ppapItemMapper.deleteByMainId(headId);
        this.purchaseMassProdSampleItemMapper.deleteByMainId(headId);
    }

    private void insertData(PurchaseMassProdHead purchaseMassProdHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        if (!CollectionUtils.isEmpty(purchaseMassMassProdPpapItemList)) {
            for (PurchaseMassProdPpapItem purchaseMassProdPpapItem : purchaseMassMassProdPpapItemList) {
                purchaseMassProdPpapItem.setDocumentsSerialNumber(purchaseMassProdHead.getDocumentsSerialNumber());
                purchaseMassProdPpapItem.setItemNumber(this.baseRpcService.getNextCode("srmMassProdPpapNumber", (Object)purchaseMassProdPpapItem));
                purchaseMassProdPpapItem.setHeadId(purchaseMassProdHead.getId());
                purchaseMassProdPpapItem.setRelationId(purchaseMassProdHead.getRelationId());
                SysUtil.setSysParam((BaseEntity)purchaseMassProdPpapItem, (BaseEntity)purchaseMassProdHead);
            }
            this.purchaseMassProdPpapItemService.saveBatch(purchaseMassMassProdPpapItemList);
        }
        if (!CollectionUtils.isEmpty(purchaseMassProdSampleItemList)) {
            for (PurchaseMassProdSampleItem purchaseMassProdSampleItem : purchaseMassProdSampleItemList) {
                purchaseMassProdSampleItem.setDocumentsSerialNumber(purchaseMassProdHead.getDocumentsSerialNumber());
                purchaseMassProdSampleItem.setItemNumber(this.baseRpcService.getNextCode("srmMassProdSampleCheckNumber", (Object)purchaseMassProdSampleItem));
                purchaseMassProdSampleItem.setHeadId(purchaseMassProdHead.getId());
                purchaseMassProdSampleItem.setRelationId(purchaseMassProdHead.getRelationId());
                SysUtil.setSysParam((BaseEntity)purchaseMassProdSampleItem, (BaseEntity)purchaseMassProdHead);
            }
            this.purchaseMassProdSampleItemService.saveBatch(purchaseMassProdSampleItemList);
        }
    }

    private void publishPpapItem(String relationId, String headId, String supplierElsAccount, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList) {
        ArrayList<SaleMassProdPpapItem> saleMassProdPpapItemList = new ArrayList<SaleMassProdPpapItem>();
        for (PurchaseMassProdPpapItem entity : purchaseMassMassProdPpapItemList) {
            SaleMassProdPpapItem saleMassProdPpapItem = new SaleMassProdPpapItem();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)saleMassProdPpapItem));
            saleMassProdPpapItem.setRelationId(relationId);
            saleMassProdPpapItem.setSourceId(entity.getId());
            saleMassProdPpapItem.setHeadId(headId);
            saleMassProdPpapItem.setElsAccount(supplierElsAccount);
            saleMassProdPpapItem.setId(null);
            saleMassProdPpapItemList.add(saleMassProdPpapItem);
        }
        this.saleMassProdPpapItemService.saveBatch(saleMassProdPpapItemList);
    }

    private void pushToSource(PurchaseMassProdHead purchaseMassProdHead) {
        PurchaseMaterialSourceDTO purchaseMaterialSource = new PurchaseMaterialSourceDTO();
        Date now = new Date();
        List<TemplateHeadDTO> templateList = this.baseRpcService.getDefaultTemplateByType("materialSource");
        purchaseMaterialSource.setTemplateNumber(templateList.get(0).getTemplateNumber());
        purchaseMaterialSource.setTemplateName(templateList.get(0).getTemplateName());
        purchaseMaterialSource.setTemplateVersion(templateList.get(0).getTemplateVersion().toString());
        purchaseMaterialSource.setTemplateAccount(templateList.get(0).getElsAccount());
        purchaseMaterialSource.setBusAccount(purchaseMassProdHead.getElsAccount());
        purchaseMaterialSource.setSourceId(this.baseRpcService.getNextCode("materialSourceNumber", purchaseMaterialSource));
        purchaseMaterialSource.setMaterialSourceType(MaterialSourceTypeApiEnum.MASS_PRODUCT.value());
        purchaseMaterialSource.setSourceType(null);
        purchaseMaterialSource.setMaterialNumber(purchaseMassProdHead.getMaterialCode());
        purchaseMaterialSource.setMaterialDesc(purchaseMassProdHead.getMaterialDesc());
        purchaseMaterialSource.setSaleMaterialNumber(purchaseMassProdHead.getSupplierErpCode());
        purchaseMaterialSource.setFactory(purchaseMassProdHead.getFactory());
        purchaseMaterialSource.setFactoryName(purchaseMassProdHead.getFactoryName());
        purchaseMaterialSource.setToElsAccount(purchaseMassProdHead.getSupplierElsAccount());
        purchaseMaterialSource.setToElsDesc(purchaseMassProdHead.getSupplierName());
        purchaseMaterialSource.setMaterialCategory(purchaseMassProdHead.getMaterialType());
        purchaseMaterialSource.setPurchaseOrg(purchaseMassProdHead.getPurchaseOrg());
        purchaseMaterialSource.setPurchaseOrgName(purchaseMassProdHead.getPurchaseOrgName());
        purchaseMaterialSource.setCompany(purchaseMassProdHead.getCompany());
        purchaseMaterialSource.setCompanyName(purchaseMassProdHead.getCompanyName());
        purchaseMaterialSource.setEffectiveDate(purchaseMassProdHead.getSourceValidBeginTime());
        purchaseMaterialSource.setExpiryDate(purchaseMassProdHead.getSourceValidEndTime());
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
        purchaseMaterialSource.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        purchaseMaterialSource.setElsAccount(purchaseMassProdHead.getElsAccount());
        purchaseMaterialSource.setCreateBy(purchaseMassProdHead.getCreateBy());
        purchaseMaterialSource.setUpdateBy(purchaseMassProdHead.getCreateBy());
        purchaseMaterialSource.setCreateTime(now);
        purchaseMaterialSource.setUpdateTime(now);
        this.sourRpcService.savePurchaseMaterialSource(purchaseMaterialSource);
    }

    private void sendFile(String purchaseHeadId, String saleHeadId, String elsAccount, String toElsAccount) {
        AttachmentSendDTO attachmentSendVO = new AttachmentSendDTO();
        attachmentSendVO.setHeadId(purchaseHeadId);
        attachmentSendVO.setElsAccount(elsAccount);
        HashMap toSend = Maps.newHashMap();
        toSend.put(saleHeadId, toElsAccount);
        attachmentSendVO.setToSend((Map)toSend);
        this.baseRpcService.sendPurchaseFile(attachmentSendVO);
    }

    private String getAudiStatus(String pubishAudit) {
        return "1".equals(pubishAudit) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(PurchaseMassProdHead purchaseMassProdHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        purchaseMassProdHead.setDocumentsSerialNumber(this.baseRpcService.getNextCode("srmMassProdDocNumber", (Object)purchaseMassProdHead));
        purchaseMassProdHead.setResultAuditStatus(this.getAudiStatus(purchaseMassProdHead.getPubishAudit()));
        purchaseMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_NEW.value());
        this.purchaseMassProdHeadMapper.insert((Object)purchaseMassProdHead);
        this.insertData(purchaseMassProdHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
    }

    private void validStartTimeAndEndTime(Date startTime, Date endTime) {
        boolean bool = startTime != null && endTime != null && startTime.getTime() > endTime.getTime();
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nMassProdMsgEnum.STARTTIME_GT_ENDTIME);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMassProdHead prodHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        this.validStartTimeAndEndTime(prodHead.getSourceValidBeginTime(), prodHead.getSourceValidEndTime());
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)prodHead.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
        prodHead.setDocumentsStatus(oldRecord.getDocumentsStatus());
        prodHead.setDocumentsSerialNumber(oldRecord.getDocumentsSerialNumber());
        prodHead.setResultAuditStatus(this.getAudiStatus(prodHead.getPubishAudit()));
        int updateCount = this.purchaseMassProdHeadMapper.updateById((Object)prodHead);
        AssertI18nUtil.isTrue((updateCount <= 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        this.delMassProdItem(prodHead.getId());
        this.insertData(prodHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void newSubmit(PurchaseMassProdHead prodHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        this.validStartTimeAndEndTime(prodHead.getSourceValidBeginTime(), prodHead.getSourceValidEndTime());
        prodHead.setDocumentsSerialNumber(this.baseRpcService.getNextCode("srmMassProdDocNumber", (Object)prodHead));
        prodHead.setResultAuditStatus(this.getAudiStatus(prodHead.getPubishAudit()));
        prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value());
        String relationId = null;
        if ("1".equals(prodHead.getSupplierPpapFile())) {
            AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)prodHead.getSupplierElsAccount()), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_SALE);
            AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(purchaseMassMassProdPpapItemList), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_PPAP);
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value());
            prodHead.setId(IdWorker.getIdStr());
            SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
            BeanUtils.copyProperties((Object)((Object)prodHead), (Object)((Object)saleMassProdHead));
            saleMassProdHead.setRelationId(prodHead.getId());
            saleMassProdHead.setBusAccount(TenantContext.getTenant());
            saleMassProdHead.setUploadPpap("0");
            saleMassProdHead.setElsAccount(prodHead.getSupplierElsAccount());
            saleMassProdHead.setId(null);
            this.saleMassProdHeadMapper.insert((Object)saleMassProdHead);
            relationId = saleMassProdHead.getId();
            prodHead.setRelationId(relationId);
            this.sendMsg(TenantContext.getTenant(), prodHead.getSupplierElsAccount(), (Object)prodHead, "", "massProdHead", "publish");
        }
        if (!"1".equals(prodHead.getSupplierPpapFile()) && !"1".equals(prodHead.getPubishAudit())) {
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
        }
        ((PurchaseMassProdHeadMapper)this.baseMapper).insert((Object)prodHead);
        this.insertData(prodHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
        if (Objects.equals("1", prodHead.getSupplierPpapFile())) {
            this.publishPpapItem(prodHead.getId(), relationId, prodHead.getSupplierElsAccount(), purchaseMassMassProdPpapItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSubmit(PurchaseMassProdHead prodHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        int updateCount;
        this.validStartTimeAndEndTime(prodHead.getSourceValidBeginTime(), prodHead.getSourceValidEndTime());
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)prodHead.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
        prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value());
        prodHead.setDocumentsSerialNumber(oldRecord.getDocumentsSerialNumber());
        prodHead.setResultAuditStatus(this.getAudiStatus(prodHead.getPubishAudit()));
        String relationId = null;
        if ("1".equals(prodHead.getSupplierPpapFile())) {
            AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)prodHead.getSupplierElsAccount()), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_SALE);
            AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(purchaseMassMassProdPpapItemList), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_PPAP);
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value());
            SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
            BeanUtils.copyProperties((Object)((Object)prodHead), (Object)((Object)saleMassProdHead));
            saleMassProdHead.setRelationId(prodHead.getId());
            saleMassProdHead.setBusAccount(oldRecord.getElsAccount());
            saleMassProdHead.setUploadPpap("0");
            saleMassProdHead.setElsAccount(prodHead.getSupplierElsAccount());
            saleMassProdHead.setId(null);
            this.saleMassProdHeadMapper.insert((Object)saleMassProdHead);
            relationId = saleMassProdHead.getId();
            prodHead.setRelationId(relationId);
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)prodHead)));
            String elsAccount = prodHead.getElsAccount();
            ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.invokeAccountRpcService.getByElsAccount(elsAccount);
            if (ObjectUtil.isNotEmpty((Object)elsEnterpriseInfoDTO)) {
                jsonObject.put("purchaseName", (Object)elsEnterpriseInfoDTO.getName());
            } else {
                LoginUserDTO loginUser = SysUtil.getLoginUser();
                if (ObjectUtil.isNotEmpty((Object)loginUser)) {
                    jsonObject.put("purchaseName", (Object)loginUser.getCompanyName());
                }
            }
            this.sendMsg(TenantContext.getTenant(), prodHead.getSupplierElsAccount(), jsonObject, "", "massProdHead", "publish");
        }
        if (!"1".equals(prodHead.getSupplierPpapFile()) && !"1".equals(prodHead.getPubishAudit())) {
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
        }
        AssertI18nUtil.isTrue(((updateCount = ((PurchaseMassProdHeadMapper)this.baseMapper).updateById((Object)prodHead)) <= 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        this.delMassProdItem(prodHead.getId());
        this.insertData(prodHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
        if (Objects.equals("1", prodHead.getSupplierPpapFile())) {
            this.publishPpapItem(prodHead.getId(), relationId, prodHead.getSupplierElsAccount(), purchaseMassMassProdPpapItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(oldRecord.getResultAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(oldRecord.getResultAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u53ef\u5220\u9664"));
        }
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        boolean bool = MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) || MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) && AuditStatusEnum.AUDIT_NEW.getValue().equals(oldRecord.getResultAuditStatus());
        AssertI18nUtil.isTrue((!bool ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
        this.delMassProdItem(id);
        this.purchaseMassProdHeadMapper.deleteById((Serializable)((Object)id));
        this.saleMassProdHeadMapper.deleteById((Serializable)((Object)oldRecord.getRelationId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById(serializable));
            AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
            boolean bool = MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) || MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) && AuditStatusEnum.AUDIT_NEW.getValue().equals(oldRecord.getResultAuditStatus());
            AssertI18nUtil.isTrue((!bool ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
            this.delMassProdItem(serializable.toString());
            this.purchaseMassProdHeadMapper.deleteById(serializable);
            this.saleMassProdHeadMapper.deleteById((Serializable)((Object)oldRecord.getRelationId()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWaitConfirm(PurchaseMassProdConfirmVo purchaseMassProdConfirmVo) {
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseMassProdConfirmVo.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_WAIT_CONFIRM);
        AssertI18nUtil.isTrue((StrUtil.isNotBlank((CharSequence)oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_NEW.getValue().equals(oldRecord.getResultAuditStatus()) && !AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(oldRecord.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_AUDI_STATUS_NOT_NULL);
        oldRecord.setResultAuditStatus(this.getAudiStatus(oldRecord.getPubishAudit()));
        int updateCount = ((PurchaseMassProdHeadMapper)this.baseMapper).updateById((Object)oldRecord);
        AssertI18nUtil.isTrue((updateCount <= 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        this.purchaseMassProdSampleItemMapper.deleteByMainId(oldRecord.getId());
        this.insertData(oldRecord, null, purchaseMassProdConfirmVo.getPurchaseMassProdSampleItemList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirm(PurchaseMassProdConfirmVo purchaseMassProdConfirmVo) {
        int updateCount;
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseMassProdConfirmVo.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_WAIT_CONFIRM);
        AssertI18nUtil.isTrue((StrUtil.isNotBlank((CharSequence)oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_NEW.getValue().equals(oldRecord.getResultAuditStatus()) && !AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(oldRecord.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_AUDI_STATUS_NOT_NULL);
        if (!Objects.equals(oldRecord.getPubishAudit(), "1")) {
            oldRecord.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
        }
        AssertI18nUtil.isTrue(((updateCount = ((PurchaseMassProdHeadMapper)this.baseMapper).updateById((Object)oldRecord)) <= 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        if (StrUtil.isNotBlank((CharSequence)oldRecord.getRelationId())) {
            SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
            saleMassProdHead.setDocumentsStatus(oldRecord.getDocumentsStatus());
            saleMassProdHead.setId(oldRecord.getRelationId());
            this.saleMassProdHeadMapper.updateById((Object)saleMassProdHead);
        }
        if (Objects.equals("1", oldRecord.getPushToSource())) {
            this.pushToSource(oldRecord);
        }
        this.purchaseMassProdSampleItemMapper.deleteByMainId(oldRecord.getId());
        this.insertData(oldRecord, null, purchaseMassProdConfirmVo.getPurchaseMassProdSampleItemList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sendBackToSale(String id) {
        AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!"1".equals(oldRecord.getSupplierPpapFile()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_NOT_SEND_TO_SALE);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_WAIT_CONFIRM);
        AssertI18nUtil.isTrue((StrUtil.isNotBlank((CharSequence)oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_NEW.getValue().equals(oldRecord.getResultAuditStatus()) && !AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(oldRecord.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_AUDI_STATUS_NOT_NULL);
        oldRecord.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value());
        oldRecord.setResultAuditStatus(this.getAudiStatus(oldRecord.getPubishAudit()));
        int updateCount = ((PurchaseMassProdHeadMapper)this.baseMapper).updateById((Object)oldRecord);
        AssertI18nUtil.isTrue((updateCount <= 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
        saleMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value());
        saleMassProdHead.setUploadPpap("0");
        saleMassProdHead.setId(oldRecord.getRelationId());
        this.saleMassProdHeadMapper.updateById((Object)saleMassProdHead);
    }

    @Override
    public void copy(String id) {
        PurchaseMassProdHead prodHead;
        if (StrUtil.isNotBlank((CharSequence)id) && (prodHead = (PurchaseMassProdHead)((Object)this.getById((Serializable)((Object)id)))) != null) {
            List<PurchaseMassProdSampleItem> sampleItemList;
            prodHead.setDocumentsSerialNumber(this.baseRpcService.getNextCode("srmMassProdDocNumber", (Object)prodHead));
            prodHead.setResultAuditStatus(this.getAudiStatus(prodHead.getPubishAudit()));
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_NEW.value());
            prodHead.setId(null);
            prodHead.setRelationId(IdWorker.getIdStr());
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            prodHead.setCreateTime(new Date());
            prodHead.setCreateBy(loginUser.getSubAccount());
            prodHead.setCreateById(loginUser.getId());
            prodHead.setUpdateTime(new Date());
            prodHead.setUpdateBy(loginUser.getSubAccount());
            prodHead.setUpdateById(loginUser.getId());
            this.purchaseMassProdHeadMapper.insert((Object)prodHead);
            List<PurchaseMassProdPpapItem> purchaseMassProdPpapItems = this.ppapItemMapper.selectByMainId(id);
            if (!CollectionUtils.isEmpty(purchaseMassProdPpapItems)) {
                for (PurchaseMassProdPpapItem entity : purchaseMassProdPpapItems) {
                    entity.setId(null);
                    entity.setDocumentsSerialNumber(prodHead.getDocumentsSerialNumber());
                    entity.setHeadId(prodHead.getId());
                    entity.setRelationId(prodHead.getRelationId());
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)prodHead);
                }
                this.purchaseMassProdPpapItemService.saveBatch(purchaseMassProdPpapItems);
            }
            if (!CollectionUtils.isEmpty(sampleItemList = this.purchaseMassProdSampleItemMapper.selectByMainId(id))) {
                for (PurchaseMassProdSampleItem entity : sampleItemList) {
                    entity.setId(null);
                    entity.setDocumentsSerialNumber(prodHead.getDocumentsSerialNumber());
                    entity.setHeadId(prodHead.getId());
                    entity.setRelationId(prodHead.getRelationId());
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)prodHead);
                }
                this.purchaseMassProdSampleItemService.saveBatch(sampleItemList);
            }
        }
    }
}

