/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.report.entity.PurchasePerformanceDetailReport;
import com.els.modules.report.entity.SalePerformanceDetailReport;
import com.els.modules.report.enumerate.AppealStatusEnum;
import com.els.modules.report.mapper.PurchasePerformanceDetailReportMapper;
import com.els.modules.report.mapper.SalePerformanceDetailReportMapper;
import com.els.modules.report.service.PurchasePerformanceDetailReportService;
import com.els.modules.report.service.SalePerformanceDetailReportService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SalePerformanceDetailReportServiceImpl
extends ServiceImpl<SalePerformanceDetailReportMapper, SalePerformanceDetailReport>
implements SalePerformanceDetailReportService {
    @Resource
    private PurchasePerformanceDetailReportMapper purchasePerformanceDetailReportMapper;
    @Resource
    private SalePerformanceDetailReportMapper salePerformanceDetailReportMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    public void saveSalePerformanceDetailReport(SalePerformanceDetailReport salePerformanceDetailReport) {
        ((SalePerformanceDetailReportMapper)this.baseMapper).insert((Object)salePerformanceDetailReport);
    }

    @Override
    public void updateSalePerformanceDetailReport(SalePerformanceDetailReport salePerformanceDetailReport) {
        int count = ((SalePerformanceDetailReportMapper)this.baseMapper).updateById((Object)salePerformanceDetailReport);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delSalePerformanceDetailReport(String id) {
        ((SalePerformanceDetailReportMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSalePerformanceDetailReport(List<String> idList) {
        ((SalePerformanceDetailReportMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction
    public void startAppeal(List<SalePerformanceDetailReport> salePerformanceDetailReports) {
        ArrayList<SalePerformanceDetailReport> salePerformanceDetailReportList = new ArrayList<SalePerformanceDetailReport>();
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList = new ArrayList<PurchasePerformanceDetailReport>();
        List ids = salePerformanceDetailReports.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List dbSalePerformanceList = this.salePerformanceDetailReportMapper.selectBatchIds(ids);
        Map SalePerformanceDetailReportMap = dbSalePerformanceList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        LoginUserDTO sysUser = SysUtil.getLoginUser();
        for (SalePerformanceDetailReport salePerformanceDetailReport : salePerformanceDetailReports) {
            SalePerformanceDetailReport dbSalePerformanceDetailReport = (SalePerformanceDetailReport)((Object)SalePerformanceDetailReportMap.get(salePerformanceDetailReport.getId()));
            Assert.notNull((Object)((Object)dbSalePerformanceDetailReport), (String)I18nUtil.translate((String)"i18n_alert_eRtyWWWWWWWKHexMKrRHcW_74b130b6", (String)"\u901a\u77e5\u5355\u53f7:[${0}]\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u660e\u7ec6\u884c!", (String[])new String[]{salePerformanceDetailReport.getNoticeNumber()}));
            Assert.isTrue((boolean)AppealStatusEnum.NEW.getValue().equals(salePerformanceDetailReport.getAppealStatus()), (String)I18nUtil.translate((String)"i18n_alert_eRtyWWWWWWWjzEIOhbrAWVXVWF_f4b60ef0", (String)"\u901a\u77e5\u5355\u53f7:[${0}]\u7684\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u6570\u636e", (String[])new String[]{salePerformanceDetailReport.getNoticeNumber()}));
            Date appealDeadTime = salePerformanceDetailReport.getAppealDeadTime();
            Assert.notNull((Object)appealDeadTime, (String)I18nUtil.translate((String)"i18n_alert_UWyRKIxOLVW_b6c1401e", (String)"\u7533\u8bc9\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            if (new Date().compareTo(appealDeadTime) > 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eRtyWWWWWAPKIIOBRUWyRKIWPKxORcrtkW_ab02b647", (String)"\u901a\u77e5\u5355\u53f7:${0}\u5f53\u524d\u65f6\u95f4\u5df2\u7ecf\u8d85\u8fc7\u7533\u8bc9\u622a\u6b62\u65f6\u95f4,\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!", (String[])new String[]{salePerformanceDetailReport.getNoticeNumber()}));
            }
            SalePerformanceDetailReport salePerformanceDetailReportTemp = new SalePerformanceDetailReport();
            PurchasePerformanceDetailReport purchasePerformanceDetailReportTemp = new PurchasePerformanceDetailReport();
            salePerformanceDetailReportTemp.setId(salePerformanceDetailReport.getId());
            salePerformanceDetailReportTemp.setAppealStatus(AppealStatusEnum.APPEALING.getValue());
            salePerformanceDetailReportTemp.setAppealTime(new Date());
            salePerformanceDetailReportTemp.setAppealUser(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            salePerformanceDetailReportTemp.setAppealReason(salePerformanceDetailReport.getAppealReason());
            String replyWindow = salePerformanceDetailReport.getReplyWindow();
            salePerformanceDetailReportTemp.setReplyDeadTime((Date)DateUtil.offsetDay((Date)new Date(), (int)Integer.parseInt(replyWindow)));
            purchasePerformanceDetailReportTemp.setId(salePerformanceDetailReport.getRelationId());
            purchasePerformanceDetailReportTemp.setAppealStatus(AppealStatusEnum.APPEALING.getValue());
            purchasePerformanceDetailReportTemp.setAppealTime(new Date());
            purchasePerformanceDetailReportTemp.setAppealUser(sysUser.getSubAccount() + "_" + sysUser.getRealname());
            purchasePerformanceDetailReportTemp.setAppealReason(salePerformanceDetailReport.getAppealReason());
            purchasePerformanceDetailReportTemp.setReplyDeadTime((Date)DateUtil.offsetDay((Date)new Date(), (int)Integer.parseInt(replyWindow)));
            salePerformanceDetailReportList.add(salePerformanceDetailReportTemp);
            purchasePerformanceDetailReportList.add(purchasePerformanceDetailReportTemp);
        }
        this.updateBatchById(salePerformanceDetailReportList);
        ((PurchasePerformanceDetailReportService)SpringContextUtils.getBean(PurchasePerformanceDetailReportService.class)).updateBatchById(purchasePerformanceDetailReportList);
        this.sendMsg(salePerformanceDetailReports);
    }

    private void sendMsg(List<SalePerformanceDetailReport> salePerformanceDetailReports) {
    }

    private List<ElsSubAccountDTO> getPurchasePricipleAccount(SalePerformanceDetailReport salePerformanceDetailReport) {
        ArrayList<ElsSubAccountDTO> subAccounts = new ArrayList<ElsSubAccountDTO>();
        if (StrUtil.isNotBlank((CharSequence)salePerformanceDetailReport.getPurchasePrincipal()) && StrUtil.isNotBlank((CharSequence)salePerformanceDetailReport.getPurchasePrincipal())) {
            String purchaseSubAccount = salePerformanceDetailReport.getPurchasePrincipal().split("_")[0];
            String toElsAccount = salePerformanceDetailReport.getToElsAccount();
            ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(toElsAccount, purchaseSubAccount);
            subAccounts.add(elsSubAccount);
        }
        return subAccounts;
    }
}

