/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.adapter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleCheckItem;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.enumerate.PurchaseSampleCheckProjectSyncEnum;
import com.els.modules.sample.mapper.PurchaseSampleCheckItemMapper;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.vo.PurchaseSampleCheckHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseSampleCheckAuditOptCallBackAdapter")
public class PurchaseSampleCheckAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseSampleCheckHeadService purchaseSampleCheckHeadService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSampleItemService purchaseSampleItemService;
    @Resource
    private PurchaseSampleHeadService purchaseSampleHeadService;
    @Resource
    private PurchaseSampleCheckItemMapper purchaseSampleCheckItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StrUtil.isBlank((CharSequence)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseSampleCheckHeadVO purchaseSampleCheckHeadVO = (PurchaseSampleCheckHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseSampleCheckHeadVO.class));
        PurchaseSampleCheckHead purchaseStandardHead = new PurchaseSampleCheckHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckHeadVO), (Object)((Object)purchaseStandardHead));
        purchaseStandardHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseStandardHead.setFlowId(outputParamVO.getProcessRootId());
        purchaseStandardHead.setWorkFlowType(outputParamVO.getBpmnType());
        purchaseStandardHead.setQualified(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getQualified());
        purchaseStandardHead.setCheckResult(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getCheckResult());
        purchaseStandardHead.setSampleQuantity(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getSampleQuantity());
        purchaseStandardHead.setQualifiedQuantity(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getQualifiedQuantity());
        purchaseStandardHead.setDefectiveQuantity(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getDefectiveQuantity());
        purchaseStandardHead.setQualifiedRate(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getQualifiedRate());
        purchaseStandardHead.setResultAudit(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getResultAudit());
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseStandardHead);
        PurchaseSampleItem sampleItem = (PurchaseSampleItem)((Object)this.purchaseSampleItemService.getById((Serializable)((Object)purchaseStandardHead.getSampleItemId())));
        BigDecimal newCheckedQuantity = sampleItem.getCheckedQuantity().add(purchaseSampleCheckHeadVO.getPurchaseSampleRecord().getSampleQuantity());
        UpdateWrapper sampleItemQueryWrapper = new UpdateWrapper();
        sampleItemQueryWrapper.lambda().eq(BaseEntity::getId, (Object)purchaseStandardHead.getSampleItemId());
        sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getCheckedQuantity, (Object)newCheckedQuantity);
        sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getAvailableQuantity, (Object)sampleItem.getRepertoryQuantity().subtract(newCheckedQuantity));
        this.purchaseSampleItemService.update((Wrapper)sampleItemQueryWrapper);
        Object operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseSampleCheckHead.setId(inputParamVO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseSampleCheckHead.setResultSync(PurchaseSampleCheckProjectSyncEnum.SYNC.getValue());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseSampleCheckHead.setCheckStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
            Date now = new Date();
            purchaseSampleCheckHead.setCheckEndDate(now);
            if ("1".equals(purchaseSampleCheckHead.getResultSync())) {
                List<PurchaseSampleCheckItem> purchaseSampleCheckItems = this.purchaseSampleCheckItemMapper.selectByMainId(purchaseSampleCheckHead.getId());
                List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseSampleCheckHead.getId());
                this.purchaseSampleCheckHeadService.syncSimpleCheckToSale(purchaseSampleCheckHead, purchaseSampleCheckItems, attachmentList);
            }
        }
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
        trackingItem.setSampleId(purchaseSampleCheckHead.getId());
        trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
        trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
        Date now = new Date();
        trackingItem.setActualEndTime(new Date());
        trackingItem.setActualEndTime(now);
        if (purchaseSampleCheckHead.getCheckStartDate() != null) {
            trackingItem.setEstimatedTimePeriod("" + (now.getTime() - purchaseSampleCheckHead.getCheckStartDate().getTime()) / 86400000L);
        }
        this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        purchaseSampleCheckHead.setId(inputParamVO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        PurchaseSampleCheckHead selectSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        this.deductCheckedQuantity(inputParamVO.getBusinessId());
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseSampleCheckHead purchaseSampleCheckHead = new PurchaseSampleCheckHead();
        purchaseSampleCheckHead.setId(inputParamVO.getBusinessId());
        purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        PurchaseSampleCheckHead selectSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        this.purchaseSampleCheckHeadService.updateById((Object)purchaseSampleCheckHead);
        if (!selectSampleCheckHead.getAuditStatus().equals(purchaseSampleCheckHead.getAuditStatus())) {
            this.deductCheckedQuantity(inputParamVO.getBusinessId());
        }
    }

    public JSONObject getDataById(String id) {
        PurchaseSampleCheckHead head = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"sampleCheck", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"sampleCheck", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)purchaseSampleCheckHead));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchaseSampleCheckHead, new DictTranslateAspectParam());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void deductCheckedQuantity(String sampleCheckId) {
        PurchaseSampleCheckHead sampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadService.getById((Serializable)((Object)sampleCheckId)));
        PurchaseSampleItem sampleItem = (PurchaseSampleItem)((Object)this.purchaseSampleItemService.getById((Serializable)((Object)sampleCheckHead.getSampleItemId())));
        BigDecimal checkedQuantity = sampleItem.getCheckedQuantity().subtract(sampleCheckHead.getSampleQuantity());
        UpdateWrapper sampleItemUpdateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)sampleItemUpdateWrapper.lambda().set(PurchaseSampleItem::getCheckedQuantity, (Object)checkedQuantity)).set(PurchaseSampleItem::getAvailableQuantity, (Object)sampleItem.getRepertoryQuantity().subtract(checkedQuantity))).eq(BaseEntity::getId, (Object)sampleItem.getId());
        this.purchaseSampleItemService.update((Wrapper)sampleItemUpdateWrapper);
    }
}

