/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.massProduction.adapter;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.massProduction.entity.PurchaseMassProdHead;
import com.els.modules.massProduction.entity.PurchaseMassProdPpapItem;
import com.els.modules.massProduction.entity.PurchaseMassProdSampleItem;
import com.els.modules.massProduction.entity.SaleMassProdHead;
import com.els.modules.massProduction.enums.MassProdEnum;
import com.els.modules.massProduction.service.PurchaseMassProdHeadService;
import com.els.modules.massProduction.service.PurchaseMassProdPpapItemService;
import com.els.modules.massProduction.service.PurchaseMassProdSampleItemService;
import com.els.modules.massProduction.service.SaleMassProdHeadService;
import com.els.modules.massProduction.vo.PurchaseMassProdHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseMassProdRpcAdapter")
public class PurchaseMassProdAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseMassProdHeadService massProdHeadService;
    @Autowired
    private SaleMassProdHeadService saleMassProdHeadService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMassProdSampleItemService purchaseMassProdSampleItemService;
    @Autowired
    private PurchaseMassProdPpapItemService purchaseMassProdPpapItemService;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId, String bpmnType) {
        PurchaseMassProdHead purchaseMassProdHead = (PurchaseMassProdHead)((Object)this.massProdHeadService.getById((Serializable)((Object)businessId)));
        if (StrUtil.isNotEmpty((CharSequence)bpmnType)) {
            purchaseMassProdHead.setWorkFlowType(bpmnType);
        }
        purchaseMassProdHead.setResultAuditStatus(auditStatus);
        purchaseMassProdHead.setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            SaleMassProdHead saleMassProdHead;
            purchaseMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
            if (StrUtil.isNotBlank((CharSequence)purchaseMassProdHead.getRelationId()) && (saleMassProdHead = (SaleMassProdHead)((Object)this.saleMassProdHeadService.getById((Serializable)((Object)purchaseMassProdHead.getRelationId())))) != null) {
                saleMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
                this.saleMassProdHeadService.updateById((Object)saleMassProdHead);
            }
        }
        this.massProdHeadService.updateById((Object)purchaseMassProdHead);
    }

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public Map<String, Object> getById(String id) {
        PurchaseMassProdHead head = (PurchaseMassProdHead)((Object)this.massProdHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseMassProdHeadVO headVO = new PurchaseMassProdHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseMassProdPpapItem> purchaseMassProdPpapItemList = this.purchaseMassProdPpapItemService.selectByMainId(id);
            headVO.setMassProdPpapItemList(purchaseMassProdPpapItemList);
            List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList = this.purchaseMassProdSampleItemService.selectByMainId(id);
            headVO.setPurchaseMassProdSampleItemList(purchaseMassProdSampleItemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }
}

