/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcd.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.mcd.entity.GpSystemReach;
import com.els.modules.mcd.service.GpSystemReachService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="systemReachRpcImportImpl")
public class SystemReachImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemReachImportImpl.class);
    @Autowired
    private GpSystemReachService gpSystemReachService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<String> casCode = new ArrayList<String>();
        ArrayList gpSystemReaches = Lists.newArrayList();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String msg;
            Map data = (Map)iterator.next();
            GpSystemReach entity = (GpSystemReach)((Object)this.transferEntity(data, GpSystemReach.class, excelImportDTO));
            if (ObjectUtil.isEmpty((Object)((Object)entity))) {
                String msg2 = I18nUtil.translate((String)"i18n_field_WFsSKm_d46d1308", (String)"\u6570\u636e\u8f6c\u6362\u5931\u8d25");
                this.errorAdd(excelImportDTO, msg2, data);
                iterator.remove();
                continue;
            }
            String casno = entity.getCasno();
            if (CharSequenceUtil.isEmpty((CharSequence)casno)) {
                msg = I18nUtil.translate((String)"i18n_field_EYSRAoxOLV_c62631ea", (String)"\u5316\u5b66\u7269\u8d28\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            if (casCode.contains(casno)) {
                msg = I18nUtil.translate((String)"i18n_field_EYSRAoIMK_ccd424d9", (String)"\u5316\u5b66\u7269\u8d28\u7f16\u7801\u5df2\u5b58\u5728");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            GpSystemReach gpSystemReach = this.gpSystemReachService.selectOneByCasno(casno);
            if (ObjectUtil.isNotEmpty((Object)((Object)gpSystemReach))) {
                String msg3 = I18nUtil.translate((String)"i18n_field_EYSRAoIMK_ccd424d9", (String)"\u5316\u5b66\u7269\u8d28\u7f16\u7801\u5df2\u5b58\u5728");
                this.errorAdd(excelImportDTO, msg3, data);
                iterator.remove();
                continue;
            }
            String casName = entity.getCasName();
            if (CharSequenceUtil.isEmpty((CharSequence)casName)) {
                String msg4 = I18nUtil.translate((String)"i18n_field_EYSRRLxOLV_71a751c2", (String)"\u5316\u5b66\u7269\u8d28\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg4, data);
                iterator.remove();
                continue;
            }
            String casClassCode = entity.getCasClassCode();
            if (CharSequenceUtil.isEmpty((CharSequence)casClassCode)) {
                String msg5 = I18nUtil.translate((String)"i18n_field_EYSRzAAoxOLV_bf55719f", (String)"\u5316\u5b66\u7269\u8d28\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg5, data);
                iterator.remove();
                continue;
            }
            String casClassName = entity.getCasClassName();
            if (CharSequenceUtil.isEmpty((CharSequence)casClassName)) {
                String msg6 = I18nUtil.translate((String)"i18n_field_EYSRzARLxOLV_6ad69177", (String)"\u5316\u5b66\u7269\u8d28\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg6, data);
                iterator.remove();
                continue;
            }
            BigDecimal threshold = entity.getThreshold();
            if (ObjectUtil.isEmpty((Object)threshold)) {
                String msg7 = I18nUtil.translate((String)"i18n_field_RVURxOLV_a4e9ecea", (String)"\u7ba1\u63a7\u9608\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg7, data);
                iterator.remove();
                continue;
            }
            entity.setElsAccount(TenantContext.getTenant());
            List templateHeadDTOS = this.invokeBaseRpcService.getDefaultTemplateByType("gpsystemreach");
            if (CollUtil.isEmpty((Collection)templateHeadDTOS)) {
                String msg8 = I18nUtil.translate((String)"i18n_field_VERUEtCLIr_12c70ebc", (String)"\u8bf7\u914d\u7f6e\u5e73\u53f0\u7ea7\u9ed8\u8ba4\u6a21\u677f");
                this.errorAdd(excelImportDTO, msg8, data);
                iterator.remove();
                continue;
            }
            casCode.add(casno);
            entity.setTemplateAccount(((TemplateHeadDTO)templateHeadDTOS.get(0)).getElsAccount());
            entity.setTemplateName(((TemplateHeadDTO)templateHeadDTOS.get(0)).getTemplateName());
            entity.setTemplateVersion(((TemplateHeadDTO)templateHeadDTOS.get(0)).getTemplateVersion());
            entity.setTemplateNumber(((TemplateHeadDTO)templateHeadDTOS.get(0)).getTemplateNumber());
            gpSystemReaches.add(entity);
        }
        if (CollUtil.isEmpty(casCode)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        this.gpSystemReachService.saveBatch(gpSystemReaches);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

