/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rohs.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.mcd.mapper.PurchaseHighRiskMapper;
import com.els.modules.rohs.entity.PurchaseRohsCollect;
import com.els.modules.rohs.entity.PurchaseRohsCollectAttachment;
import com.els.modules.rohs.entity.SaleRohsCollect;
import com.els.modules.rohs.entity.SaleRohsCollectAttachment;
import com.els.modules.rohs.mapper.PurchaseRohsCollectAttachmentMapper;
import com.els.modules.rohs.mapper.PurchaseRohsCollectMapper;
import com.els.modules.rohs.mapper.SaleRohsCollectAttachmentMapper;
import com.els.modules.rohs.mapper.SaleRohsCollectMapper;
import com.els.modules.rohs.service.PurchaseRohsCollectAttachmentService;
import com.els.modules.rohs.service.SaleRohsCollectAttachmentService;
import com.els.modules.rohs.service.SaleRohsCollectService;
import com.els.modules.rohsreport.entity.SaleRohsReportHead;
import com.els.modules.rohsreport.mapper.SaleRohsReportHeadMapper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleRohsCollectServiceImpl
extends BaseServiceImpl<SaleRohsCollectMapper, SaleRohsCollect>
implements SaleRohsCollectService {
    @Resource
    private SaleRohsCollectMapper saleRohsCollectMapper;
    @Resource
    private PurchaseRohsCollectMapper purchaseRohsCollectMapper;
    @Resource
    private SaleRohsCollectAttachmentMapper saleRohsCollectAttachmentMapper;
    @Resource
    private SaleRohsCollectAttachmentService saleRohsCollectAttachmentService;
    @Resource
    private PurchaseRohsCollectAttachmentMapper purchaseRohsCollectAttachmentMapper;
    @Resource
    private PurchaseRohsCollectAttachmentService purchaseRohsCollectAttachmentService;
    @Resource
    private SaleRohsReportHeadMapper saleRohsReportHeadMapper;
    @Resource
    private PurchaseHighRiskMapper purchaseHighRiskMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleRohsCollect saleRohsCollect, List<SaleRohsCollectAttachment> saleRohsCollectAttachmentList) {
        this.updateSale(saleRohsCollect, saleRohsCollectAttachmentList, false);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submit(SaleRohsCollect saleRohsCollect, List<SaleRohsCollectAttachment> saleRohsCollectAttachmentList) {
        List jcNumberList = saleRohsCollectAttachmentList.stream().map(SaleRohsCollectAttachment::getJcNumber).collect(Collectors.toList());
        LambdaQueryWrapper saleRohsReportHeadLambdaQueryWrapper = new LambdaQueryWrapper();
        saleRohsReportHeadLambdaQueryWrapper.in(SaleRohsReportHead::getJcNumber, jcNumberList);
        saleRohsReportHeadLambdaQueryWrapper.eq(SaleRohsReportHead::getJcState, (Object)"9");
        List saleRohsReportHeads = this.saleRohsReportHeadMapper.selectList((Wrapper)saleRohsReportHeadLambdaQueryWrapper);
        if (saleRohsReportHeads.size() > 0) {
            throw new ELSBootException("\u68c0\u6d4b\u62a5\u544a\u9644\u4ef6\u5217\u8868\u4e2d\u6709\u5e9f\u6b62\u7684\u62a5\u544a\u672a\u5220\u9664,\u4e0d\u53ef\u63d0\u4ea4\uff01\u62a5\u544a\u7f16\u53f7\uff1a" + saleRohsReportHeads.stream().map(SaleRohsReportHead::getJcNumber).collect(Collectors.joining(", ")));
        }
        saleRohsCollect.setCollectStatus("2");
        this.updateSale(saleRohsCollect, saleRohsCollectAttachmentList, true);
        super.sendMessage(saleRohsCollect.getElsAccount(), "rohscollect", "publishSupplier", saleRohsCollect.getRelationid(), "siteInspectionBusDataServiceImpl", Arrays.asList(saleRohsCollect.getBusAccount()));
    }

    @Override
    public List<SaleRohsCollect> selectRecentlyExpList() {
        return ((SaleRohsCollectMapper)this.baseMapper).selectRecentlyExpList();
    }

    private void updateSale(SaleRohsCollect saleRohsCollect, List<SaleRohsCollectAttachment> saleRohsCollectAttachmentList, boolean submitFlag) {
        this.saleRohsCollectMapper.updateById((Object)saleRohsCollect);
        this.saleRohsCollectAttachmentMapper.deleteByMainId(saleRohsCollect.getId());
        String riskLevel = "2";
        if (!CollectionUtils.isEmpty(saleRohsCollectAttachmentList)) {
            for (SaleRohsCollectAttachment entity : saleRohsCollectAttachmentList) {
                entity.setId(IdWorker.getIdStr());
                entity.setRelationid(IdWorker.getIdStr());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleRohsCollect);
                entity.setHeadId(saleRohsCollect.getId());
                if ("1".equals(riskLevel)) {
                    entity.setJcExpDate((Date)DateUtil.offsetMonth((Date)entity.getJcDate(), (int)18));
                    continue;
                }
                if ("2".equals(riskLevel)) {
                    entity.setJcExpDate((Date)DateUtil.offsetMonth((Date)entity.getJcDate(), (int)12));
                    continue;
                }
                entity.setJcExpDate((Date)DateUtil.parse((CharSequence)"9999-12-31"));
            }
            long count = saleRohsCollectAttachmentList.stream().filter(e -> e.getJcExpDate().before(new Date())).count();
            if (count > 0L) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MKIRAIisxWxiTDJ_287cbe16", (String)"\u5b58\u5728\u5df2\u8fc7\u671f\u68c0\u6d4b\u62a5\u544a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4"));
            }
            this.saleRohsCollectAttachmentService.saveBatch(saleRohsCollectAttachmentList);
        }
        if (submitFlag) {
            PurchaseRohsCollect purchaseRohsCollect = new PurchaseRohsCollect();
            purchaseRohsCollect.setId(saleRohsCollect.getRelationid());
            purchaseRohsCollect.setCollectStatus("2");
            purchaseRohsCollect.setConfirmTime(new Date());
            this.purchaseRohsCollectMapper.updateById((Object)purchaseRohsCollect);
            this.purchaseRohsCollectAttachmentMapper.deleteByMainId(purchaseRohsCollect.getId());
            ArrayList<PurchaseRohsCollectAttachment> purchaseRohsCollectAttachmentList = new ArrayList<PurchaseRohsCollectAttachment>();
            for (SaleRohsCollectAttachment saleRohsCollectAttachment : saleRohsCollectAttachmentList) {
                PurchaseRohsCollectAttachment purchaseRohsCollectAttachment = new PurchaseRohsCollectAttachment();
                BeanUtils.copyProperties((Object)((Object)saleRohsCollectAttachment), (Object)((Object)purchaseRohsCollectAttachment));
                purchaseRohsCollectAttachment.setId(saleRohsCollectAttachment.getRelationid());
                purchaseRohsCollectAttachment.setRelationid(saleRohsCollectAttachment.getId());
                purchaseRohsCollectAttachment.setHeadId(purchaseRohsCollect.getId());
                purchaseRohsCollectAttachmentList.add(purchaseRohsCollectAttachment);
            }
            this.purchaseRohsCollectAttachmentService.saveBatch(purchaseRohsCollectAttachmentList);
        }
    }

    @Override
    public List<SaleRohsCollect> selectHasExpList() {
        return ((SaleRohsCollectMapper)this.baseMapper).selectHasExpList();
    }

    @Override
    public void updateMaterialDesc() {
        ((SaleRohsCollectMapper)this.baseMapper).updateMaterialDesc();
    }
}

