/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.trial.entity.PurchaseTrialProductionHead;
import com.els.modules.trial.entity.SaleTrialProductionHead;
import com.els.modules.trial.enumerate.PurchaseTrialProductionHeadEnum;
import com.els.modules.trial.service.PurchaseTrialProductionHeadService;
import com.els.modules.trial.service.SaleTrialProductionHeadService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseTrialProductionDubboAdapter")
public class PurchaseTrialProductionAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseTrialProductionHeadService purchaseTrialProductionHeadService;
    @Autowired
    private SaleTrialProductionHeadService saleTrialProductionHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = new PurchaseTrialProductionHead();
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseTrialProductionHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        purchaseTrialProductionHead.setResultAudit("1");
        purchaseTrialProductionHead.setId(flowCallbackDTO.getBusinessId());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        Date now = new Date();
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseTrialProductionHead.setId(flowCallbackDTO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(AuditStatusEnum.AUDIT_FINISH.getValue())) {
            purchaseTrialProductionHead.setTrialEndDate(now);
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.FINAL.getValue());
        }
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
        PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
        trackingItem.setSampleId(purchaseTrialProductionHead.getId());
        trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
        trackingItem.setCheckResult(purchaseTrialProductionHead.getTrialResult());
        trackingItem.setQualified(purchaseTrialProductionHead.getQualified());
        trackingItem.setActualEndTime(now);
        this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
        UpdateWrapper saleHeadQueryWrapper = new UpdateWrapper();
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialStatus, (Object)PurchaseTrialProductionHeadEnum.FINAL.getValue());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getSampleQuantity, (Object)purchaseTrialProductionHead.getSampleQuantity());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedQuantity, (Object)purchaseTrialProductionHead.getQualifiedQuantity());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getDefectiveQuantity, (Object)purchaseTrialProductionHead.getDefectiveQuantity());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedRate, (Object)purchaseTrialProductionHead.getQualifiedRate());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualified, (Object)purchaseTrialProductionHead.getQualified());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResult, (Object)purchaseTrialProductionHead.getTrialResult());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getResultAudit, (Object)purchaseTrialProductionHead.getResultAudit());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultDesc, (Object)purchaseTrialProductionHead.getTrialResultDesc());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultNumber, (Object)purchaseTrialProductionHead.getTrialResultNumber());
        saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialEndDate, (Object)now);
        saleHeadQueryWrapper.lambda().eq(SaleTrialProductionHead::getRelationId, (Object)purchaseTrialProductionHead.getId());
        this.saleTrialProductionHeadService.update((Wrapper)saleHeadQueryWrapper);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseTrialProductionHead.setId(flowCallbackDTO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseTrialProductionHead.setId(flowCallbackDTO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseTrialProductionHead.setFlowId("");
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
    }

    public Map<String, Object> getById(String id) {
        PurchaseTrialProductionHead head = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }
}

