/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.enumerate.SampleUseLinkEnum;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.trial.entity.PurchaseTrialProductionHead;
import com.els.modules.trial.entity.PurchaseTrialProductionItem;
import com.els.modules.trial.entity.SaleTrialProductionHead;
import com.els.modules.trial.enumerate.PurchaseTrialPrincipalEnum;
import com.els.modules.trial.enumerate.PurchaseTrialProductionHeadEnum;
import com.els.modules.trial.mapper.PurchaseTrialProductionHeadMapper;
import com.els.modules.trial.mapper.PurchaseTrialProductionItemMapper;
import com.els.modules.trial.service.PurchaseTrialProductionHeadService;
import com.els.modules.trial.service.PurchaseTrialProductionItemService;
import com.els.modules.trial.service.impl.SaleTrialProductionHeadServiceImpl;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTrialProductionHeadServiceImpl
extends BaseServiceImpl<PurchaseTrialProductionHeadMapper, PurchaseTrialProductionHead>
implements PurchaseTrialProductionHeadService {
    @Resource
    private PurchaseTrialProductionHeadMapper purchaseTrialProductionHeadMapper;
    @Resource
    private PurchaseTrialProductionItemMapper purchaseTrialProductionItemMapper;
    @Resource
    private PurchaseTrialProductionItemService purchaseTrialProductionItemService;
    @Autowired
    private SaleTrialProductionHeadServiceImpl saleTrialProductionHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseTrialProductionHead.setTrialNumber(this.invokeBaseRpcService.getNextCode("srmTrialProdNumber", (Object)purchaseTrialProductionHead));
        purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.NEW.getValue());
        if ("1".equals(purchaseTrialProductionHead.getResultAudit())) {
            purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseTrialProductionHeadMapper.insert((Object)purchaseTrialProductionHead);
        if (purchaseTrialProductionItemList != null) {
            this.insertData(purchaseTrialProductionHead, purchaseTrialProductionItemList, purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        if ("1".equals(purchaseTrialProductionHead.getResultAudit())) {
            purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (StrUtil.isBlank((CharSequence)purchaseTrialProductionHead.getId())) {
            purchaseTrialProductionHead.setTrialNumber(this.invokeBaseRpcService.getNextCode("srmTrialProdNumber", (Object)purchaseTrialProductionHead));
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.NEW.getValue());
            this.purchaseTrialProductionHeadMapper.insert((Object)purchaseTrialProductionHead);
        } else {
            Date now = new Date();
            if (type != null && 2 == type) {
                purchaseTrialProductionHead.setTrialStartDate(now);
            }
            this.purchaseTrialProductionHeadMapper.updateById((Object)purchaseTrialProductionHead);
        }
        this.purchaseTrialProductionItemMapper.deleteByMainId(purchaseTrialProductionHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTrialProductionHead.getId());
        if (purchaseTrialProductionItemList != null) {
            this.insertData(purchaseTrialProductionHead, purchaseTrialProductionItemList, purchaseAttachmentList);
        }
        if (type != null && 2 == type && PurchaseTrialPrincipalEnum.SALE.getValue().equals(purchaseTrialProductionHead.getTrialPrincipal())) {
            String headId = this.saleTrialProductionHeadService.addByPurchase(purchaseTrialProductionHead, purchaseTrialProductionItemList);
            super.sendMessage(TenantContext.getTenant(), "trialProduction", "submitSupplier", headId, "purchaseTrialProductionHeadBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{purchaseTrialProductionHead.getToElsAccount()}));
        }
        if (type != null && 2 == type) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setHeadId(purchaseTrialProductionHead.getSampleHeadId());
            trackingItem.setSampleNumber(purchaseTrialProductionHead.getTrialNumber());
            trackingItem.setSampleId(purchaseTrialProductionHead.getId());
            trackingItem.setPurchasePrincipal(purchaseTrialProductionHead.getPrincipal());
            trackingItem.setActualBeginTime(new Date());
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_ING.getValue());
            trackingItem.setCheckResult(purchaseTrialProductionHead.getTrialResult());
            trackingItem.setQualified(purchaseTrialProductionHead.getQualified());
            trackingItem.setSampleUseLink(SampleUseLinkEnum.TRIAL_PRODUCTION.getValue());
            this.purchaseSampleTrackingItemMapper.insert((Object)trackingItem);
        }
    }

    @Override
    public void record(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        Date now = new Date();
        if (type != null && 2 == type && (StrUtil.isBlank((CharSequence)purchaseTrialProductionHead.getResultAudit()) || "0".equals(purchaseTrialProductionHead.getResultAudit()))) {
            purchaseTrialProductionHead.setTrialEndDate(now);
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.FINAL.getValue());
        }
        if ("1".equals(purchaseTrialProductionHead.getResultAudit())) {
            purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseTrialProductionHeadMapper.updateById((Object)purchaseTrialProductionHead);
        if (purchaseTrialProductionItemList != null) {
            for (PurchaseTrialProductionItem entity : purchaseTrialProductionItemList) {
                this.purchaseTrialProductionItemMapper.updateById((Object)entity);
            }
        }
        if (!purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTrialProductionHead.getId());
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (type != null && 2 == type && (StrUtil.isBlank((CharSequence)purchaseTrialProductionHead.getResultAudit()) || "0".equals(purchaseTrialProductionHead.getResultAudit()))) {
            UpdateWrapper saleHeadQueryWrapper = new UpdateWrapper();
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialStatus, (Object)PurchaseTrialProductionHeadEnum.FINAL.getValue());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getSampleQuantity, (Object)purchaseTrialProductionHead.getSampleQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedQuantity, (Object)purchaseTrialProductionHead.getQualifiedQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getDefectiveQuantity, (Object)purchaseTrialProductionHead.getDefectiveQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedRate, (Object)purchaseTrialProductionHead.getQualifiedRate());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualified, (Object)purchaseTrialProductionHead.getQualified());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResult, (Object)purchaseTrialProductionHead.getTrialResult());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getResultAudit, (Object)purchaseTrialProductionHead.getResultAudit());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultDesc, (Object)purchaseTrialProductionHead.getTrialResultDesc());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultNumber, (Object)purchaseTrialProductionHead.getTrialResultNumber());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialEndDate, (Object)now);
            saleHeadQueryWrapper.lambda().eq(SaleTrialProductionHead::getRelationId, (Object)purchaseTrialProductionHead.getId());
            this.saleTrialProductionHeadService.update((Wrapper)saleHeadQueryWrapper);
        }
        if (type != null && 2 == type && PurchaseTrialPrincipalEnum.PURCHASE.getValue().equals(purchaseTrialProductionHead.getTrialPrincipal())) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setSampleId(purchaseTrialProductionHead.getId());
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
            trackingItem.setCheckResult(purchaseTrialProductionHead.getTrialResult());
            trackingItem.setQualified(purchaseTrialProductionHead.getQualified());
            trackingItem.setActualEndTime(now);
            this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
        }
    }

    private void insertData(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseTrialProductionItemList != null && !purchaseTrialProductionItemList.isEmpty()) {
            for (PurchaseTrialProductionItem entity : purchaseTrialProductionItemList) {
                entity.setHeadId(purchaseTrialProductionHead.getId());
                entity.setId(null);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTrialProductionHead);
            }
            this.purchaseTrialProductionItemService.saveBatch(purchaseTrialProductionItemList, 2000);
        }
        if (purchaseAttachmentList != null && !purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseTrialProductionItemMapper.deleteByMainId(id);
        this.purchaseTrialProductionHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseTrialProductionItemMapper.deleteByMainId(serializable.toString());
            this.purchaseTrialProductionHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void copy(String id) {
        PurchaseTrialProductionHead trialProductionHead;
        if (StrUtil.isNotBlank((CharSequence)id) && (trialProductionHead = (PurchaseTrialProductionHead)((Object)this.getById((Serializable)((Object)id)))) != null) {
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            trialProductionHead.setTrialNumber(this.invokeBaseRpcService.getNextCode("srmTrialProdNumber", (Object)trialProductionHead));
            trialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.NEW.getValue());
            if ("1".equals(trialProductionHead.getResultAudit())) {
                trialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            } else {
                trialProductionHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            trialProductionHead.setId(null);
            trialProductionHead.setCreateBy(loginUser.getSubAccount());
            trialProductionHead.setCreateById(loginUser.getId());
            trialProductionHead.setCreateTime(new Date());
            trialProductionHead.setUpdateBy(loginUser.getSubAccount());
            trialProductionHead.setUpdateById(loginUser.getId());
            trialProductionHead.setUpdateTime(new Date());
            trialProductionHead.setTrialResultNumber(null);
            trialProductionHead.setTrialStartDate(null);
            trialProductionHead.setTrialEndDate(null);
            trialProductionHead.setSampleQuantity(null);
            trialProductionHead.setQualifiedQuantity(null);
            trialProductionHead.setDefectiveQuantity(null);
            trialProductionHead.setQualifiedRate(null);
            trialProductionHead.setQualified(null);
            trialProductionHead.setTrialResult(null);
            trialProductionHead.setTrialResultDesc(null);
            trialProductionHead.setResultAudit(null);
            this.purchaseTrialProductionHeadMapper.insert((Object)trialProductionHead);
            List<PurchaseTrialProductionItem> itemList = this.purchaseTrialProductionItemMapper.selectByMainId(id);
            if (itemList != null && !itemList.isEmpty()) {
                for (PurchaseTrialProductionItem entity : itemList) {
                    entity.setHeadId(trialProductionHead.getId());
                    entity.setId(null);
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)trialProductionHead);
                }
                this.purchaseTrialProductionItemService.saveBatch(itemList, 2000);
            }
        }
    }

    @Override
    public JSONObject getTrialProductionDataById(String id) {
        SaleTrialProductionHead saleTrialProductionHead = (SaleTrialProductionHead)((Object)this.saleTrialProductionHeadService.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)saleTrialProductionHead));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)saleTrialProductionHead, new DictTranslateAspectParam());
        String elsAccount = saleTrialProductionHead.getToElsAccount();
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.invokeAccountRpcService.getByElsAccount(elsAccount);
        if (ObjectUtil.isNotEmpty((Object)elsEnterpriseInfoDTO)) {
            jsonObject.put("purchaseName", (Object)elsEnterpriseInfoDTO.getName());
        } else {
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            if (ObjectUtil.isNotEmpty((Object)loginUser)) {
                jsonObject.put("purchaseName", (Object)loginUser.getCompanyName());
            }
        }
        return jsonObject;
    }
}

